/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.persistence.dropbox;

import com.dropbox.core.DbxAppInfo;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.http.StandardHttpRequestor;
import com.fathzer.soft.jclop.dropbox.DbxConnectionData;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.ResourceBundle;
import net.yapbam.gui.Preferences;

final class YapbamDropboxSession
extends DbxConnectionData {
    private static final String NAME = "Yapbam";
    private static final DbxAppInfo APP_INFO;

    YapbamDropboxSession() {
        super(NAME, YapbamDropboxSession.buildConfig(), APP_INFO);
    }

    private static DbxRequestConfig buildConfig() {
        StandardHttpRequestor.Config.Builder builder = StandardHttpRequestor.Config.builder();
        String proxyHost = Preferences.INSTANCE.getHttpProxyHost();
        if (proxyHost != null) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, Preferences.INSTANCE.getHttpProxyPort()));
            final String proxyUser = Preferences.INSTANCE.getHttpProxyUser();
            if (proxyUser != null) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(proxyUser, Preferences.INSTANCE.getHttpProxyPassword().toCharArray());
                    }
                });
            }
            builder.withProxy(proxy);
        }
        DbxRequestConfig.Builder rbuilder = DbxRequestConfig.newBuilder(NAME);
        rbuilder.withHttpRequestor(new StandardHttpRequestor(builder.build()));
        return rbuilder.build();
    }

    static {
        ResourceBundle bundle = ResourceBundle.getBundle("net.yapbam.gui.persistence.dropbox.keys");
        APP_INFO = new DbxAppInfo(bundle.getString("appKey"), bundle.getString("appSecret"));
    }
}

