/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.persistence.reading;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.jclop.SynchronizationState;
import com.fathzer.soft.jclop.UnreachableHostException;
import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import net.yapbam.data.xml.UnsupportedFileVersionException;
import net.yapbam.data.xml.YapbamSerializer;
import net.yapbam.gui.ErrorManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.dialogs.GetPasswordDialog;
import net.yapbam.gui.persistence.DataWrapper;
import net.yapbam.gui.persistence.PersistenceAdapter;
import net.yapbam.gui.persistence.PersistenceManager;
import net.yapbam.gui.persistence.SynchronizeCommand;
import net.yapbam.gui.persistence.UnsupportedSchemeException;
import net.yapbam.gui.persistence.reading.OnlyReadWorker;
import net.yapbam.gui.persistence.reading.ReaderResult;
import net.yapbam.gui.persistence.reading.State;
import net.yapbam.gui.persistence.reading.SyncAndReadWorker;
import net.yapbam.util.HtmlUtils;

public class DataReader {
    private Window owner;
    private DataWrapper<?> data;
    private URI uri;
    private PersistenceAdapter adapter;
    private PersistenceManager manager;

    public DataReader(PersistenceManager manager, Window owner, DataWrapper<?> data, URI uri) {
        this.owner = owner;
        this.data = data;
        this.uri = uri;
        this.manager = manager;
        this.adapter = manager.getAdapter(uri);
    }

    public boolean read() throws ExecutionException {
        return this.doSyncAndRead(SynchronizeCommand.SYNCHRONIZE);
    }

    public boolean doSyncAndRead(SynchronizeCommand command) throws ExecutionException {
        ReaderResult result;
        if (this.adapter == null) {
            throw new ExecutionException(new UnsupportedSchemeException(this.uri));
        }
        SyncAndReadWorker basicWorker = new SyncAndReadWorker(this.adapter.getService(), this.data, this.uri, command);
        this.manager.buildWaitDialog(this.owner, basicWorker).setVisible(true);
        try {
            result = (ReaderResult)basicWorker.get();
            if (result.getState().equals((Object)State.EXCEPTION_WHILE_SYNC)) {
                if (!(result.getException() instanceof IOException)) {
                    ErrorManager.INSTANCE.log(this.owner, result.getException());
                }
                return this.doSyncFailed(result.getException());
            }
            if (result.getState().equals((Object)State.FINISHED)) {
                this.data.commit(this.uri, basicWorker.getData());
                return true;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (CancellationException e) {
            if (basicWorker.isSynchronizing()) {
                return this.syncCancelled();
            }
            return false;
        }
        catch (ExecutionException e) {
            return this.doErrorOccurred(e);
        }
        File localFile = this.adapter.getLocalFile(this.uri);
        if (basicWorker.isCancelled()) {
            return false;
        }
        SynchronizationState state = result.getSyncState();
        if (state.equals((Object)SynchronizationState.CONFLICT)) {
            return this.doConflict();
        }
        if (state.equals((Object)SynchronizationState.REMOTE_DELETED)) {
            return this.doRemoteNotFound();
        }
        if (state.equals((Object)SynchronizationState.SYNCHRONIZED)) {
            if (result.getState().equals((Object)State.NEED_PASSWORD)) {
                return this.doPasswordNeeded(localFile.toURI());
            }
            throw new RuntimeException("Unexpected state: data is synchronized, not read but has no password required");
        }
        throw new RuntimeException("Unexpected state: " + (Object)((Object)state));
    }

    private boolean doPasswordNeeded(URI localURI) throws ExecutionException {
        GetPasswordDialog dialog = new GetPasswordDialog(this.owner, LocalizationData.get("FilePasswordDialog.title"), LocalizationData.get("FilePasswordDialog.openFile.question"), UIManager.getIcon("OptionPane.questionIcon"), null);
        dialog.setPasswordFieldToolTipText(LocalizationData.get("FilePasswordDialog.openFile.tooltip"));
        dialog.setVisible(true);
        String password = dialog.getPassword();
        while (true) {
            if (password == null) {
                return false;
            }
            try {
                if (YapbamSerializer.isPasswordOk(localURI, password)) {
                    break;
                }
            }
            catch (IOException e) {
                throw new ExecutionException(e);
            }
            dialog = new GetPasswordDialog(this.owner, LocalizationData.get("FilePasswordDialog.title"), LocalizationData.get("FilePasswordDialog.openFile.badPassword.question"), UIManager.getIcon("OptionPane.warningIcon"), null);
            dialog.setPasswordFieldToolTipText(LocalizationData.get("FilePasswordDialog.openFile.tooltip"));
            dialog.setVisible(true);
            password = dialog.getPassword();
        }
        return this.readLocalFile(password);
    }

    private boolean doSyncFailed(Throwable throwable) throws ExecutionException {
        boolean internetIsDown = throwable instanceof UnreachableHostException;
        if (!this.adapter.getLocalFile(this.uri).exists()) {
            String message = LocalizationData.get("synchronization.downloadFailed");
            if (internetIsDown) {
                message = "<HTML>" + HtmlUtils.removeHtmlTags(this.adapter.getMessage("com.fathzer.soft.jclop.connectionFailed")) + "<BR>" + "<BR>" + HtmlUtils.removeHtmlTags(message) + "</HTML>";
            }
            JOptionPane.showMessageDialog(this.owner, message, LocalizationData.get("ErrorManager.title"), internetIsDown ? 2 : 0);
            return false;
        }
        Object[] options = new String[]{LocalizationData.get("GenericButton.yes"), LocalizationData.get("GenericButton.no")};
        if (JOptionPane.showOptionDialog(this.owner, LocalizationData.get("synchronization.question.failed"), LocalizationData.get("Generic.warning"), 0, 2, null, options, 0) != 0) {
            return false;
        }
        return this.readLocalFile(null);
    }

    private boolean doErrorOccurred(ExecutionException e) throws ExecutionException {
        Throwable cause = e.getCause();
        if (this.adapter.getService().isLocal() || cause instanceof FileNotFoundException) {
            throw e;
        }
        if (cause instanceof UnsupportedFileVersionException) {
            String message = Formatter.format(LocalizationData.get("MainMenu.Open.Error.DialogContent.needUpdate"), this.adapter.getService().getDisplayable(this.uri));
            JOptionPane.showMessageDialog(this.owner, message, LocalizationData.get("ErrorManager.title"), 2);
            return false;
        }
        if (this.adapter.getService().isLocal()) {
            return false;
        }
        Object[] options = new String[]{LocalizationData.get("GenericButton.yes"), LocalizationData.get("GenericButton.no")};
        if (JOptionPane.showOptionDialog(this.owner, LocalizationData.get("synchronization.question.cacheCorrupted"), LocalizationData.get("ErrorManager.title"), 0, 0, null, options, 0) != 0) {
            return false;
        }
        this.adapter.getLocalFile(this.uri).delete();
        return this.doSyncAndRead(SynchronizeCommand.DOWNLOAD);
    }

    private boolean doRemoteNotFound() throws ExecutionException {
        String message = Formatter.format(LocalizationData.get("synchronization.question.other"), this.adapter.getMessage("com.fathzer.soft.jclop.remoteMissing"));
        Object[] options = new Object[]{this.adapter.getMessage("com.fathzer.soft.jclop.upload"), LocalizationData.get("synchronization.deleteCache.action"), LocalizationData.get("GenericButton.cancel")};
        int n = JOptionPane.showOptionDialog(this.owner, message, LocalizationData.get("Generic.warning"), 1, 3, null, options, options[2]);
        if (n != 2) {
            if (n == 0) {
                return this.doSyncAndRead(SynchronizeCommand.UPLOAD);
            }
            this.adapter.getService().deleteLocal(this.uri);
        }
        return false;
    }

    private boolean doConflict() throws ExecutionException {
        String message = Formatter.format(LocalizationData.get("synchronization.question.other"), this.adapter.getMessage("com.fathzer.soft.jclop.conflict"));
        Object[] options = new Object[]{this.adapter.getMessage("com.fathzer.soft.jclop.upload"), this.adapter.getMessage("com.fathzer.soft.jclop.download"), LocalizationData.get("GenericButton.cancel")};
        int n = JOptionPane.showOptionDialog(this.owner, message, LocalizationData.get("Generic.warning"), 1, 3, null, options, options[2]);
        if (n == 2) {
            return false;
        }
        if (n == 0) {
            return this.doSyncAndRead(SynchronizeCommand.UPLOAD);
        }
        return this.doSyncAndRead(SynchronizeCommand.DOWNLOAD);
    }

    private boolean syncCancelled() throws ExecutionException {
        if (!this.adapter.getLocalFile(this.uri).exists()) {
            return false;
        }
        Object[] options = new String[]{LocalizationData.get("GenericButton.yes"), LocalizationData.get("GenericButton.no")};
        if (JOptionPane.showOptionDialog(this.owner, LocalizationData.get("synchronization.question.cancelled"), LocalizationData.get("Generic.warning"), 0, 3, null, options, 0) != 0) {
            return false;
        }
        return this.readLocalFile(null);
    }

    private boolean readLocalFile(String password) throws ExecutionException {
        URI localURI = this.adapter.getLocalFile(this.uri).toURI();
        if (password == null) {
            boolean passwordRequired;
            try {
                passwordRequired = !YapbamSerializer.isPasswordOk(localURI, null);
            }
            catch (IOException e) {
                throw new ExecutionException(e);
            }
            if (passwordRequired) {
                return this.doPasswordNeeded(localURI);
            }
        }
        OnlyReadWorker readWorker = new OnlyReadWorker(localURI, password);
        this.manager.buildWaitDialog(this.owner, readWorker).setVisible(true);
        try {
            this.data.commit(this.uri, readWorker.get());
            return true;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (CancellationException e) {
            return false;
        }
    }
}

