/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.persistence.writing;

import com.fathzer.soft.ajlib.swing.worker.Worker;
import com.fathzer.soft.jclop.Cancellable;
import com.fathzer.soft.jclop.Service;
import com.fathzer.soft.jclop.SynchronizationState;
import java.net.URI;
import java.util.Locale;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.persistence.CancelManager;
import net.yapbam.gui.persistence.SynchronizeCommand;

public class SynchronizeWorker
extends Worker<SynchronizationState, Void>
implements Cancellable {
    private URI uri;
    private SynchronizeCommand command;
    private CancelManager cancelManager;
    private Locale locale;
    private Service service;

    SynchronizeWorker(Service service, URI uri, SynchronizeCommand command, Locale locale) {
        this.service = service;
        this.uri = uri;
        this.command = command;
        this.locale = locale;
        this.cancelManager = new CancelManager(this);
    }

    @Override
    protected SynchronizationState doProcessing() throws Exception {
        if (this.command.equals((Object)SynchronizeCommand.SYNCHRONIZE)) {
            this.setPhase(LocalizationData.get("synchronization.synchronizing"), -1);
            return this.service.synchronize(this.uri, this, this.locale);
        }
        if (this.command.equals((Object)SynchronizeCommand.UPLOAD)) {
            this.setPhase(LocalizationData.get("synchronization.uploading"), -1);
            this.service.upload(this.uri, this, this.locale);
            return SynchronizationState.SYNCHRONIZED;
        }
        if (this.command.equals((Object)SynchronizeCommand.DOWNLOAD)) {
            this.setPhase(LocalizationData.get("synchronization.downloading"), -1);
            this.service.download(this.uri, this, this.locale);
            return SynchronizationState.SYNCHRONIZED;
        }
        throw new IllegalArgumentException((Object)((Object)this.command) + " is unknown");
    }

    @Override
    public void reportProgress(int progress) {
        super.reportProgress(progress);
    }

    @Override
    public void setPhase(String phase, int length) {
        super.setPhase(phase, length);
    }

    @Override
    public void setCancelAction(Runnable action) {
        this.cancelManager.setAction(action);
    }

    @Override
    public void setMax(int max) {
        super.setPhaseLength(max);
    }
}

