/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.statementview;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.yapbam.data.FilteredData;
import net.yapbam.data.Transaction;
import net.yapbam.gui.TransactionSelector;
import net.yapbam.gui.statementview.StatementViewPanel;

public class DualTransactionSelector
implements TransactionSelector {
    private List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
    private StatementViewPanel panel;
    private Transaction[] lastSelected;

    public DualTransactionSelector(StatementViewPanel panel) {
        this.panel = panel;
        this.lastSelected = new Transaction[0];
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object[] selected = DualTransactionSelector.this.getSelectedTransactions();
                if (!Arrays.equals(DualTransactionSelector.this.lastSelected, selected)) {
                    Transaction[] old = DualTransactionSelector.this.lastSelected;
                    DualTransactionSelector.access$002(DualTransactionSelector.this, (Transaction[])selected);
                    evt = new PropertyChangeEvent(evt.getSource(), "selectedTransaction", old, DualTransactionSelector.this.lastSelected);
                    for (int i = 0; i < DualTransactionSelector.this.listeners.size(); ++i) {
                        ((PropertyChangeListener)DualTransactionSelector.this.listeners.get(i)).propertyChange(evt);
                    }
                }
            }
        };
        this.panel.getTransactionsTable().addPropertyChangeListener("selectedTransaction", listener);
        this.panel.getUncheckedTransactionsTable().addPropertyChangeListener("selectedTransaction", listener);
        this.panel.addPropertyChangeListener("CheckModeReady", listener);
    }

    @Override
    public Transaction[] getSelectedTransactions() {
        if (this.panel.isCheckModeReady()) {
            return new Transaction[0];
        }
        return (this.panel.isCheckMode() ? this.panel.getUncheckedTransactionsTable() : this.panel.getTransactionsTable()).getSelectedTransactions();
    }

    @Override
    public void setSelectedTransactions(Transaction[] transactions) {
        this.panel.getTransactionsTable().setSelectedTransactions(transactions);
        if (this.panel.isCheckMode()) {
            this.panel.getUncheckedTransactionsTable().setSelectedTransactions(transactions);
        }
    }

    @Override
    public FilteredData getFilteredData() {
        return this.panel.getFilteredData();
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    static /* synthetic */ Transaction[] access$002(DualTransactionSelector x0, Transaction[] x1) {
        x0.lastSelected = x1;
        return x1;
    }
}

