/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.statementview;

import com.fathzer.soft.ajlib.swing.widget.ComboBox;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.yapbam.data.Account;
import net.yapbam.data.FilteredData;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Statement;
import net.yapbam.data.Transaction;
import net.yapbam.data.comparator.AccountComparator;
import net.yapbam.data.event.AccountAddedEvent;
import net.yapbam.data.event.AccountPropertyChangedEvent;
import net.yapbam.data.event.AccountRemovedEvent;
import net.yapbam.data.event.DataEvent;
import net.yapbam.data.event.DataListener;
import net.yapbam.data.event.EverythingChangedEvent;
import net.yapbam.data.event.TransactionsAddedEvent;
import net.yapbam.data.event.TransactionsRemovedEvent;
import net.yapbam.gui.LocalizationData;

public class StatementSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String SELECTED_STATEMENT_PROPERTY_NAME = "SelectedStatement";
    private ComboBox accountMenu;
    private ComboBox statementMenu;
    private FilteredData data;
    private Statement[] statements;
    private String lastSelectedStatement;

    public StatementSelectionPanel(FilteredData data) {
        this.data = data;
        this.initialize();
        if (data != null) {
            this.data.addListener(new DataListener(){

                @Override
                public void processEvent(DataEvent event) {
                    List<Account> validAccounts;
                    if (event instanceof EverythingChangedEvent && (validAccounts = StatementSelectionPanel.this.data.getFilter().getValidAccounts()) != null && validAccounts.size() == 1) {
                        StatementSelectionPanel.this.getAccountMenu().setSelectedItem(validAccounts.get(0).getName());
                    }
                }
            });
            this.data.getGlobalData().addListener(new GlobalDataListener());
            this.init();
        }
    }

    private void init() {
        GlobalData global = this.data.getGlobalData();
        ComboBox accountMenu = this.getAccountMenu();
        if (global.getAccountsNumber() == 0) {
            accountMenu.setSelectedIndex(-1);
            accountMenu.removeAllItems();
            accountMenu.setEnabled(false);
        } else {
            Account[] accounts;
            accountMenu.setEnabled(true);
            accountMenu.setActionEnabled(false);
            accountMenu.removeAllItems();
            for (Account account : accounts = AccountComparator.getSortedAccounts(global, this.getLocale())) {
                accountMenu.addItem(account.getName());
            }
            accountMenu.setActionEnabled(true);
            accountMenu.setSelectedIndex(0);
        }
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbcCheckModePanel = new GridBagConstraints();
        gbcCheckModePanel.anchor = 13;
        gbcCheckModePanel.gridx = 5;
        gbcCheckModePanel.fill = 2;
        gbcCheckModePanel.gridy = 0;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(0, 10, 0, 5);
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 0;
        JLabel jLabel1 = new JLabel();
        jLabel1.setText(LocalizationData.get("TransactionDialog.statement"));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        JLabel jLabel = new JLabel();
        jLabel.setText(LocalizationData.get("AccountDialog.account"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 0.0;
        this.add((Component)jLabel, gridBagConstraints2);
        this.add((Component)this.getAccountMenu(), gridBagConstraints1);
        this.add((Component)jLabel1, gridBagConstraints3);
        this.add((Component)this.getStatementMenu(), gridBagConstraints);
    }

    private ComboBox getAccountMenu() {
        if (this.accountMenu == null) {
            this.accountMenu = new ComboBox();
            this.accountMenu.setToolTipText(LocalizationData.get("StatementView.accountMenu.tooltip"));
            this.accountMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StatementSelectionPanel.this.refresh();
                }
            });
        }
        return this.accountMenu;
    }

    public Account getAccount() {
        if (this.data == null) {
            return null;
        }
        Object accountName = this.getAccountMenu().getSelectedItem();
        return accountName != null ? this.data.getGlobalData().getAccount((String)accountName) : null;
    }

    private ComboBox getStatementMenu() {
        if (this.statementMenu == null) {
            this.statementMenu = new ComboBox();
            this.statementMenu.setToolTipText(LocalizationData.get("StatementView.statementMenu.statementMenu.tooltip"));
            this.statementMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StatementSelectionPanel.this.statementSelected(true);
                }
            });
        }
        return this.statementMenu;
    }

    private void statementSelected(boolean forcePropertyChange) {
        String statementName;
        Statement selectedStatement = this.getSelectedStatement();
        String string = statementName = selectedStatement == null ? null : selectedStatement.getId();
        if (forcePropertyChange || !NullUtils.areEquals(statementName, this.lastSelectedStatement)) {
            this.lastSelectedStatement = statementName;
            this.firePropertyChange(SELECTED_STATEMENT_PROPERTY_NAME, this.lastSelectedStatement, selectedStatement);
        }
    }

    private void refresh() {
        String accountName = (String)this.getAccountMenu().getSelectedItem();
        this.statementMenu.setActionEnabled(false);
        boolean ignoreLastSelected = this.statements == null || this.statementMenu.getSelectedIndex() < 0 || this.statementMenu.getItemCount() <= 2;
        String lastSelectedStatement = (String)(ignoreLastSelected ? null : this.statementMenu.getSelectedItem());
        this.statementMenu.removeAllItems();
        if (accountName == null) {
            this.statements = null;
            this.statementMenu.setActionEnabled(true);
            this.statementMenu.setSelectedIndex(-1);
            this.statementMenu.setEnabled(false);
        } else {
            this.statements = Statement.getStatements(this.data.getGlobalData().getAccount(accountName));
            for (int i = 0; i < this.statements.length; ++i) {
                String id = this.statements[this.statements.length - 1 - i].getId();
                this.statementMenu.addItem(id == null ? LocalizationData.get("StatementView.notChecked") : id);
            }
            this.statementMenu.setActionEnabled(true);
            this.statementMenu.setEnabled(this.statements.length > 0);
            if (lastSelectedStatement != null && this.statementMenu.contains(lastSelectedStatement)) {
                this.statementMenu.setSelectedItem(lastSelectedStatement);
            } else {
                this.statementMenu.setSelectedIndex(this.statements.length > 0 ? 0 : -1);
            }
        }
    }

    public Statement getSelectedStatement() {
        if (this.statements == null || this.getStatementMenu().getSelectedIndex() < 0) {
            return null;
        }
        return this.statements[this.statements.length - 1 - this.getStatementMenu().getSelectedIndex()];
    }

    public void select(String statementId) {
        this.getStatementMenu().setSelectedItem(statementId);
    }

    public Statement getStatement(String statementId) {
        if (this.statements == null) {
            return null;
        }
        for (Statement statement : this.statements) {
            if (!NullUtils.areEquals(statement.getId(), statementId)) continue;
            return statement;
        }
        return null;
    }

    public boolean isThereANewerStatement(String statementId) {
        if (this.statements == null) {
            return false;
        }
        int index = -1;
        for (int i = 0; i < this.statements.length; ++i) {
            if (!NullUtils.areEquals(this.statements[i].getId(), statementId)) continue;
            index = i;
            break;
        }
        return index >= 0 && index != this.statements.length - 1 && (index != this.statements.length - 2 || this.statements[this.statements.length - 1].getId() != null);
    }

    private final class GlobalDataListener
    implements DataListener {
        private GlobalDataListener() {
        }

        @Override
        public void processEvent(DataEvent event) {
            GlobalData global = StatementSelectionPanel.this.data.getGlobalData();
            ComboBox accountMenu = StatementSelectionPanel.this.getAccountMenu();
            if (event instanceof EverythingChangedEvent) {
                StatementSelectionPanel.this.init();
            } else if (event instanceof AccountAddedEvent) {
                if (global.getAccountsNumber() == 1) {
                    StatementSelectionPanel.this.init();
                } else {
                    Account[] accounts = AccountComparator.getSortedAccounts(global, StatementSelectionPanel.this.getLocale());
                    Account account = ((AccountAddedEvent)event).getAccount();
                    int index = Arrays.binarySearch(accounts, account, AccountComparator.getInstance(StatementSelectionPanel.this.getLocale()));
                    accountMenu.insertItemAt(account.getName(), index);
                }
            } else if (event instanceof AccountRemovedEvent) {
                String accountName = ((AccountRemovedEvent)event).getRemoved().getName();
                if (NullUtils.areEquals(accountMenu.getSelectedItem(), accountName)) {
                    StatementSelectionPanel.this.init();
                } else {
                    accountMenu.removeItem(accountName);
                }
            } else if (event instanceof AccountPropertyChangedEvent) {
                String property = ((AccountPropertyChangedEvent)event).getProperty();
                if (property.equals("initialBalance")) {
                    Account account = ((AccountPropertyChangedEvent)event).getAccount();
                    if (account.getName().equals(accountMenu.getSelectedItem())) {
                        StatementSelectionPanel.this.refresh();
                    }
                } else if (property.equals("name")) {
                    accountMenu.setActionEnabled(false);
                    String old = (String)((AccountPropertyChangedEvent)event).getOldValue();
                    int index = accountMenu.getSelectedIndex();
                    for (int i = 0; i < accountMenu.getItemCount(); ++i) {
                        if (!accountMenu.getItemAt(i).equals(old)) continue;
                        accountMenu.removeItemAt(i);
                        accountMenu.insertItemAt(((AccountPropertyChangedEvent)event).getNewValue(), i);
                        break;
                    }
                    accountMenu.setSelectedIndex(index);
                    accountMenu.setActionEnabled(true);
                }
            } else if (event instanceof TransactionsAddedEvent) {
                Transaction[] ts = ((TransactionsAddedEvent)event).getTransactions();
                this.refreshIfNeeded(ts);
            } else if (event instanceof TransactionsRemovedEvent) {
                Transaction[] t = ((TransactionsRemovedEvent)event).getTransactions();
                this.refreshIfNeeded(t);
            }
        }

        private void refreshIfNeeded(Transaction[] ts) {
            boolean refresh = false;
            for (int i = 0; i < ts.length; ++i) {
                if (!ts[i].getAccount().getName().equals(StatementSelectionPanel.this.getAccountMenu().getSelectedItem())) continue;
                refresh = true;
                break;
            }
            if (refresh) {
                StatementSelectionPanel.this.refresh();
            }
        }
    }
}

