/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.statistics;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.yapbam.data.Category;
import net.yapbam.data.FilteredData;
import net.yapbam.data.SubTransaction;
import net.yapbam.data.Transaction;
import net.yapbam.data.event.DataEvent;
import net.yapbam.data.event.DataListener;
import net.yapbam.gui.AbstractPlugIn;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.YapbamState;
import net.yapbam.gui.statistics.BarChartPanel;
import net.yapbam.gui.statistics.PieChartPanel;
import net.yapbam.gui.statistics.Summary;
import net.yapbam.gui.widget.TabbedPane;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.util.ResourceBundleWrapper;
import org.slf4j.LoggerFactory;

public class StatisticsPlugin
extends AbstractPlugIn {
    private FilteredData data;
    private boolean displayed;
    private Map<Category, Summary> categoryToAmount;
    private PieChartPanel pie;
    private BarChartPanel bar;
    private TabbedPane tabbedPane;
    private JCheckBox groupSubCategories;
    private JCheckBox netValues;

    public StatisticsPlugin(FilteredData filteredData, Object restartData) {
        this.data = filteredData;
        this.categoryToAmount = new TreeMap<Category, Summary>();
        this.data.addListener(new DataListener(){

            @Override
            public void processEvent(DataEvent event) {
                if (StatisticsPlugin.this.displayed) {
                    StatisticsPlugin.this.buildSummaries();
                }
            }
        });
        this.setPanelTitle(LocalizationData.get("StatisticsPlugin.title"));
        this.setPanelToolTip(LocalizationData.get("StatisticsPlugin.tooltip"));
        this.setPrintingSupported(true);
        new SimpleChartPanel();
    }

    @Override
    public JPanel getPanel() {
        this.tabbedPane = new TabbedPane();
        this.bar = new BarChartPanel(this.categoryToAmount);
        this.tabbedPane.addTab(LocalizationData.get("StatisticsPlugin.bar.tabname"), null, this.bar, LocalizationData.get("StatisticsPlugin.bar.tooltip"));
        this.pie = new PieChartPanel(this.categoryToAmount);
        this.tabbedPane.addTab(LocalizationData.get("StatisticsPlugin.pie.tabname"), null, this.pie, LocalizationData.get("StatisticsPlugin.pie.tooltip"));
        this.buildSummaries();
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                StatisticsPlugin.this.getNetValues().setVisible(StatisticsPlugin.this.tabbedPane.getSelectedComponent() == StatisticsPlugin.this.bar);
            }
        });
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)this.tabbedPane, "Center");
        JPanel southPane = new JPanel(new BorderLayout());
        southPane.add((Component)this.getGroupSubCategories(), "West");
        southPane.add((Component)this.getNetValues(), "East");
        southPane.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.BLACK));
        result.add((Component)southPane, "South");
        return result;
    }

    private JCheckBox getGroupSubCategories() {
        if (this.groupSubCategories == null) {
            this.groupSubCategories = new JCheckBox(LocalizationData.get("Subcategories.groupButton.title"));
            this.groupSubCategories.setToolTipText(LocalizationData.get("Subcategories.groupButton.tooltip"));
            this.groupSubCategories.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    StatisticsPlugin.this.buildSummaries();
                }
            });
        }
        return this.groupSubCategories;
    }

    private JCheckBox getNetValues() {
        if (this.netValues == null) {
            this.netValues = new JCheckBox(LocalizationData.get("StatisticsPlugin.bar.netValues.title"));
            this.netValues.setToolTipText(LocalizationData.get("StatisticsPlugin.bar.netValues.tooltip"));
            this.netValues.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    StatisticsPlugin.this.bar.setNetValues(StatisticsPlugin.this.netValues.isSelected());
                }
            });
        }
        return this.netValues;
    }

    @Override
    protected Printable getPrintable() {
        return new Printable(){

            @Override
            public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
                ChartPanel pane = (ChartPanel)StatisticsPlugin.this.tabbedPane.getSelectedComponent();
                return pane.print(graphics, pageFormat, pageIndex);
            }
        };
    }

    private void buildSummaries() {
        int i;
        this.categoryToAmount.clear();
        for (i = 0; i < this.data.getGlobalData().getCategoriesNumber(); ++i) {
            this.categoryToAmount.put(this.data.getGlobalData().getCategory(i), new Summary());
        }
        for (i = 0; i < this.data.getTransactionsNumber(); ++i) {
            Transaction transaction = this.data.getTransaction(i);
            if (this.data.getFilter().isOk(transaction)) {
                for (int j = 0; j < transaction.getSubTransactionSize(); ++j) {
                    SubTransaction subTransaction = transaction.getSubTransaction(j);
                    if (!this.data.getFilter().isOk(subTransaction)) continue;
                    this.categoryToAmount.get(subTransaction.getCategory()).add(subTransaction.getAmount());
                }
                Category category = transaction.getCategory();
                if (!this.data.getFilter().isComplementOk(transaction)) continue;
                this.categoryToAmount.get(category).add(transaction.getComplement());
                continue;
            }
            LoggerFactory.getLogger(StatisticsPlugin.class).warn("What a strange thing: transaction {} is in FilteredData but is not ok with its filter", (Object)transaction);
        }
        if (this.getGroupSubCategories().isSelected()) {
            this.groupBySuperCategory();
        }
        this.pie.updateDataSet();
        this.bar.updateDataSet();
    }

    private void groupBySuperCategory() {
        ArrayList<Category> keys = new ArrayList<Category>(this.categoryToAmount.size());
        for (Category category : this.categoryToAmount.keySet()) {
            keys.add(category);
        }
        for (Category category : keys) {
            Category superCategory;
            if (category.equals(superCategory = category.getSuperCategory(this.data.getGlobalData().getSubCategorySeparator()))) continue;
            Summary amounts = this.categoryToAmount.remove(category);
            Summary superAmounts = this.categoryToAmount.get(superCategory);
            if (superAmounts == null) {
                superAmounts = new Summary();
                this.categoryToAmount.put(superCategory, superAmounts);
            }
            superAmounts.add(amounts);
        }
    }

    @Override
    public void setDisplayed(boolean displayed) {
        super.setDisplayed(displayed);
        this.displayed = displayed;
        if (displayed) {
            this.buildSummaries();
        }
    }

    @Override
    public void saveState() {
        YapbamState.INSTANCE.saveState(this.tabbedPane, this.getClass().getCanonicalName());
        YapbamState.INSTANCE.put(this.getGroupSubCategoriesStateKey(), Boolean.toString(this.getGroupSubCategories().isSelected()));
        YapbamState.INSTANCE.put(this.getNetValuesStateKey(), Boolean.toString(this.getNetValues().isSelected()));
    }

    @Override
    public void restoreState() {
        YapbamState.INSTANCE.restoreState(this.tabbedPane, this.getClass().getCanonicalName());
        this.getGroupSubCategories().setSelected(Boolean.parseBoolean(YapbamState.INSTANCE.get(this.getGroupSubCategoriesStateKey(), "false")));
        this.getNetValues().setSelected(Boolean.parseBoolean(YapbamState.INSTANCE.get(this.getNetValuesStateKey(), "false")));
    }

    private String getGroupSubCategoriesStateKey() {
        return this.getClass().getCanonicalName() + ".groupSubCategories";
    }

    private String getNetValuesStateKey() {
        return this.getClass().getCanonicalName() + ".netValues";
    }

    private static class SimpleChartPanel
    extends ChartPanel {
        public SimpleChartPanel() {
            super((JFreeChart)null);
            localizationResources = ResourceBundleWrapper.getBundle("org.jfree.chart.LocalizationBundle", LocalizationData.getLocale());
        }
    }
}

