/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.transactiontable;

import java.awt.print.Printable;
import java.io.Serializable;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JTable;
import net.yapbam.data.FilteredData;
import net.yapbam.data.event.DataEvent;
import net.yapbam.data.event.DataListener;
import net.yapbam.data.event.EverythingChangedEvent;
import net.yapbam.data.event.PeriodicalTransactionsAddedEvent;
import net.yapbam.data.event.PeriodicalTransactionsRemovedEvent;
import net.yapbam.gui.AbstractPlugIn;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.TransactionSelector;
import net.yapbam.gui.YapbamState;
import net.yapbam.gui.dialogs.preferences.PreferencePanel;
import net.yapbam.gui.transactiontable.BalanceReportPanel;
import net.yapbam.gui.transactiontable.TransactionTable;
import net.yapbam.gui.transactiontable.TransactionsPlugInPanel;
import net.yapbam.gui.transactiontable.TransactionsPreferencePanel;
import net.yapbam.gui.util.JTableUtils;

public class TransactionsPlugIn
extends AbstractPlugIn {
    private static final String STATE_PREFIX = "net.yapbam.transactionTable.";
    private static final String BALANCE_REF = "net.yapbam.transactionTable.balanceReport";
    private TransactionsPlugInPanel panel;
    private FilteredData data;

    public TransactionsPlugIn(FilteredData filteredData, Object restoreData) {
        this.data = filteredData;
        this.panel = new TransactionsPlugInPanel(this.data, this);
        this.setPanelTitle(LocalizationData.get("MainFrame.Transactions"));
        this.setPanelToolTip(LocalizationData.get("MainFrame.Transactions.toolTip"));
        this.testAlert();
        this.data.getGlobalData().addListener(new DataListener(){

            @Override
            public void processEvent(DataEvent event) {
                if (TransactionsPlugIn.this.eventMayChangePeridiocalTranscationToGenerate(event)) {
                    TransactionsPlugIn.this.testAlert();
                }
            }
        });
        this.setPrintingSupported(true);
    }

    private boolean eventMayChangePeridiocalTranscationToGenerate(DataEvent event) {
        return event instanceof EverythingChangedEvent || event instanceof PeriodicalTransactionsAddedEvent || event instanceof PeriodicalTransactionsRemovedEvent;
    }

    @Override
    public void restoreState() {
        TransactionTable transactionTable = this.panel.getTransactionTable();
        YapbamState.INSTANCE.restoreState(transactionTable, STATE_PREFIX);
        transactionTable.scrollToLastLine();
        Serializable restoredSelected = YapbamState.INSTANCE.restore(BALANCE_REF);
        if (restoredSelected != null && restoredSelected != BalanceReportPanel.Selection.NONE) {
            this.panel.getBalanceReportPanel().setSelected((BalanceReportPanel.Selection)((Object)restoredSelected));
        }
        JTableUtils.fixColumnSize(transactionTable, 0, 0);
    }

    @Override
    public void saveState() {
        YapbamState.INSTANCE.saveState(this.panel.getTransactionTable(), STATE_PREFIX);
        YapbamState.INSTANCE.save(BALANCE_REF, (Serializable)((Object)this.panel.getBalanceReportPanel().getSelected()));
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public PreferencePanel getLFPreferencePanel() {
        return new TransactionsPreferencePanel();
    }

    @Override
    protected Printable getPrintable() {
        return this.panel.getTransactionTable().getPrintable(JTable.PrintMode.FIT_WIDTH, null, null);
    }

    private void testAlert() {
        String tooltip = LocalizationData.get("MainFrame.Transactions.toolTip");
        boolean hasPendingPeriodicalTransactions = this.data.getGlobalData().hasPendingPeriodicalTransactions(new Date());
        if (hasPendingPeriodicalTransactions) {
            tooltip = "<html>" + tooltip + "<br>" + LocalizationData.get("GeneratePeriodicalTransactionsDialog.alert") + "</html>";
        }
        this.setPanelIcon(hasPendingPeriodicalTransactions ? IconManager.get(IconManager.Name.ALERT) : null);
        this.setPanelToolTip(tooltip);
    }

    @Override
    public TransactionSelector getTransactionSelector() {
        return this.panel.getTransactionTable();
    }
}

