/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.transfer;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.widget.date.DateWidget;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import net.yapbam.data.Account;
import net.yapbam.data.Category;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Mode;
import net.yapbam.data.SubTransaction;
import net.yapbam.data.Transaction;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.dialogs.CategoryWidget;
import net.yapbam.gui.dialogs.SubtransactionListPanel;
import net.yapbam.gui.transfer.FromOrToPane;
import net.yapbam.gui.widget.AutoSelectFocusListener;
import net.yapbam.gui.widget.CurrencyWidget;

public class TransferPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String OK_DISABLED_CAUSE_PROPERTY = "okDisabledCause";
    private JPanel upperPane;
    private FromOrToPane fromPane;
    private FromOrToPane toPane;
    private JLabel dateLabel;
    private DateWidget dateField;
    private JLabel amountLabel;
    private CurrencyWidget amountField;
    private JPanel mainPanel;
    private CategoryWidget categoryWidget;
    private GlobalData data;
    private String okDisabledCause;
    private PropertyChangeListener listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("account".equals(evt.getPropertyName())) {
                TransferPanel.this.setDefaultDescription(evt.getSource() != TransferPanel.this.getFromPane());
            }
            TransferPanel.this.updateOkDisabledCause();
        }
    };
    private SubtransactionListPanel subTransactionsPanel;

    private void setDefaultDescription(boolean from) {
        String format = LocalizationData.get(from ? "TransferDialog.from.description" : "TransferDialog.to.description");
        String description = Formatter.format(format, ((Account)(from ? this.getToPane() : this.getFromPane()).getAccountWidget().get()).getName());
        (from ? this.getFromPane() : this.getToPane()).getDescriptionField().setText(description);
    }

    public TransferPanel(GlobalData data) {
        this.data = data;
        this.initialize();
        this.setDefaultDescription(true);
        this.setDefaultDescription(false);
        this.updateOkDisabledCause();
    }

    private void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gbcUpperPane = new GridBagConstraints();
        gbcUpperPane.insets = new Insets(0, 5, 0, 5);
        gbcUpperPane.weightx = 1.0;
        gbcUpperPane.fill = 2;
        gbcUpperPane.anchor = 18;
        gbcUpperPane.gridx = 0;
        gbcUpperPane.gridy = 0;
        this.add((Component)this.getUpperPane(), gbcUpperPane);
        GridBagConstraints gbcSubTransactionsPanel = new GridBagConstraints();
        gbcSubTransactionsPanel.fill = 1;
        gbcSubTransactionsPanel.gridx = 0;
        gbcSubTransactionsPanel.gridy = 2;
        this.add((Component)this.getSubTransactionsPanel(), gbcSubTransactionsPanel);
        GridBagConstraints gbcMainPanel = new GridBagConstraints();
        gbcMainPanel.insets = new Insets(0, 0, 5, 0);
        gbcMainPanel.gridwidth = 0;
        gbcMainPanel.weighty = 1.0;
        gbcMainPanel.weightx = 1.0;
        gbcMainPanel.fill = 1;
        gbcMainPanel.gridx = 0;
        gbcMainPanel.gridy = 1;
        this.add((Component)this.getMainPanel(), gbcMainPanel);
    }

    private JPanel getUpperPane() {
        if (this.upperPane == null) {
            this.upperPane = new JPanel();
            GridBagLayout gblUpperPane = new GridBagLayout();
            this.upperPane.setLayout(gblUpperPane);
            GridBagConstraints gbcDateLabel = new GridBagConstraints();
            gbcDateLabel.insets = new Insets(0, 0, 0, 5);
            gbcDateLabel.anchor = 17;
            gbcDateLabel.gridx = 0;
            gbcDateLabel.gridy = 0;
            this.upperPane.add((Component)this.getDateLabel(), gbcDateLabel);
            GridBagConstraints gbcDateField = new GridBagConstraints();
            gbcDateField.insets = new Insets(0, 0, 0, 5);
            gbcDateField.gridx = 1;
            gbcDateField.gridy = 0;
            this.upperPane.add((Component)this.getDateField(), gbcDateField);
            GridBagConstraints gbcAmountLabel = new GridBagConstraints();
            gbcAmountLabel.insets = new Insets(0, 5, 0, 5);
            gbcAmountLabel.anchor = 13;
            gbcAmountLabel.gridx = 2;
            gbcAmountLabel.gridy = 0;
            this.upperPane.add((Component)this.getAmountLabel(), gbcAmountLabel);
            GridBagConstraints gbcAmountField = new GridBagConstraints();
            gbcAmountField.anchor = 17;
            gbcAmountField.insets = new Insets(0, 0, 0, 5);
            gbcAmountField.gridx = 3;
            gbcAmountField.gridy = 0;
            this.upperPane.add((Component)this.getAmountField(), gbcAmountField);
            GridBagConstraints gbcCategoryWidget = new GridBagConstraints();
            gbcCategoryWidget.weightx = 1.0;
            gbcCategoryWidget.fill = 2;
            gbcCategoryWidget.gridwidth = 0;
            gbcCategoryWidget.gridx = 4;
            gbcCategoryWidget.gridy = 0;
            this.upperPane.add((Component)this.getCategoryWidget(), gbcCategoryWidget);
        }
        return this.upperPane;
    }

    FromOrToPane getFromPane() {
        if (this.fromPane == null) {
            this.fromPane = new FromOrToPane(this.data, true);
            this.fromPane.getAccountWidget().setToolTipText(LocalizationData.get("TransferDialog.from.account.tooltip"));
            this.fromPane.getValueDateField().setToolTipText(LocalizationData.get("TransferDialog.from.valueDate.tooltip"));
            this.fromPane.setBorder(new TitledBorder(null, LocalizationData.get("TransferDialog.from.title"), 4, 0, null, null));
            this.fromPane.addPropertyChangeListener("account", this.listener);
            this.fromPane.addPropertyChangeListener("ValueDate", this.listener);
            this.fromPane.setDate(this.getDateField().getDate());
        }
        return this.fromPane;
    }

    FromOrToPane getToPane() {
        if (this.toPane == null) {
            this.toPane = new FromOrToPane(this.data, false);
            if (this.data != null && this.data.getAccountsNumber() > 1) {
                this.toPane.setAccount(this.data.getAccount(1));
            }
            this.toPane.getAccountWidget().setToolTipText(LocalizationData.get("TransferDialog.to.account.tooltip"));
            this.toPane.getValueDateField().setToolTipText(LocalizationData.get("TransferDialog.to.valueDate.tooltip"));
            this.toPane.setBorder(new TitledBorder(null, LocalizationData.get("TransferDialog.to.title"), 4, 0, null, null));
            this.toPane.addPropertyChangeListener("account", this.listener);
            this.toPane.addPropertyChangeListener("ValueDate", this.listener);
            this.toPane.setDate(this.getDateField().getDate());
        }
        return this.toPane;
    }

    private JLabel getDateLabel() {
        if (this.dateLabel == null) {
            this.dateLabel = new JLabel(LocalizationData.get("TransactionDialog.date"));
        }
        return this.dateLabel;
    }

    private DateWidget getDateField() {
        if (this.dateField == null) {
            this.dateField = new DateWidget();
            this.dateField.setToolTipText(LocalizationData.get("TransactionDialog.date.tooltip"));
            this.dateField.setColumns(10);
            this.dateField.addPropertyChangeListener("date", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    TransferPanel.this.getFromPane().setDate(TransferPanel.this.dateField.getDate());
                    TransferPanel.this.getToPane().setDate(TransferPanel.this.dateField.getDate());
                    TransferPanel.this.updateOkDisabledCause();
                }
            });
            this.dateField.getDateField().addFocusListener(AutoSelectFocusListener.INSTANCE);
        }
        return this.dateField;
    }

    private JLabel getAmountLabel() {
        if (this.amountLabel == null) {
            this.amountLabel = new JLabel(LocalizationData.get("TransactionDialog.amount"));
        }
        return this.amountLabel;
    }

    private CurrencyWidget getAmountField() {
        if (this.amountField == null) {
            this.amountField = new CurrencyWidget();
            this.amountField.setToolTipText(LocalizationData.get("TransferDialog.amount"));
            this.amountField.setColumns(10);
            this.amountField.setValue(0.0);
            this.amountField.addPropertyChangeListener("value", this.listener);
            this.amountField.addFocusListener(AutoSelectFocusListener.INSTANCE);
        }
        return this.amountField;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridLayout(0, 2, 0, 0));
            this.mainPanel.add(this.getFromPane());
            this.mainPanel.add(this.getToPane());
        }
        return this.mainPanel;
    }

    private CategoryWidget getCategoryWidget() {
        if (this.categoryWidget == null) {
            this.categoryWidget = new CategoryWidget(this.data);
        }
        return this.categoryWidget;
    }

    public String getOkDisabledCause() {
        return this.okDisabledCause;
    }

    private void updateOkDisabledCause() {
        String old = this.okDisabledCause;
        this.okDisabledCause = null;
        if (this.getDateField().getDate() == null) {
            this.okDisabledCause = LocalizationData.get("TransactionDialog.bad.date");
        } else if (this.getAmountField().getValue() == null) {
            this.okDisabledCause = LocalizationData.get("TransactionDialog.bad.amount");
        } else if (GlobalData.AMOUNT_COMPARATOR.compare(this.getAmountField().getValue(), 0.0) <= 0) {
            this.okDisabledCause = LocalizationData.get("TransferDialog.error.amountIsNotPositive");
        } else if (((Account)this.getFromPane().getAccountWidget().get()).equals(this.getToPane().getAccountWidget().get())) {
            this.okDisabledCause = LocalizationData.get("TransferDialog.error.accountAreEquals");
        } else if (this.getFromPane().getValueDateField().getDate() == null) {
            this.okDisabledCause = Formatter.format(LocalizationData.get("TransferDialog.errorValueDate"), LocalizationData.get("TransferDialog.from.title"));
        } else if (this.getToPane().getValueDateField().getDate() == null) {
            this.okDisabledCause = Formatter.format(LocalizationData.get("TransferDialog.errorValueDate"), LocalizationData.get("TransferDialog.to.title"));
        }
        if (!NullUtils.areEquals(old, this.okDisabledCause)) {
            this.firePropertyChange(OK_DISABLED_CAUSE_PROPERTY, old, this.okDisabledCause);
        }
    }

    private SubtransactionListPanel getSubTransactionsPanel() {
        if (this.subTransactionsPanel == null) {
            this.subTransactionsPanel = new SubtransactionListPanel(this.data);
            this.subTransactionsPanel.addPropertyChangeListener("sum", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (TransferPanel.this.getAmountField().getValue() != null && TransferPanel.this.subTransactionsPanel.isAddToTransactionSelected()) {
                        double diff = (Double)evt.getNewValue() - (Double)evt.getOldValue();
                        double newValue = TransferPanel.this.getAmountField().getValue() + diff;
                        TransferPanel.this.getAmountField().setValue(newValue);
                    }
                }
            });
        }
        return this.subTransactionsPanel;
    }

    public Transaction[] getTransactions() {
        Transaction[] result = new Transaction[2];
        ArrayList<SubTransaction> subFrom = new ArrayList<SubTransaction>();
        ArrayList<SubTransaction> subTo = new ArrayList<SubTransaction>();
        for (int i = 0; i < this.getSubTransactionsPanel().getSubtransactionsCount(); ++i) {
            SubTransaction sub = this.getSubTransactionsPanel().getSubtransaction(i);
            subTo.add(sub);
            subFrom.add(new SubTransaction(-sub.getAmount(), sub.getDescription(), sub.getCategory()));
        }
        result[0] = new Transaction(this.getDateField().getDate(), this.getFromPane().getNumberField().getNumber(), this.getFromPane().getDescriptionField().getText(), this.getFromPane().getCommentField().getText(), -this.getAmountField().getValue().doubleValue(), (Account)this.getFromPane().getAccountWidget().get(), (Mode)this.getFromPane().getModeWidget().get(), (Category)this.getCategoryWidget().get(), this.getFromPane().getValueDateField().getDate(), this.getFromPane().getStatementField().getText(), subFrom);
        result[1] = new Transaction(this.getDateField().getDate(), this.getToPane().getNumberField().getNumber(), this.getToPane().getDescriptionField().getText(), this.getToPane().getCommentField().getText(), (double)this.getAmountField().getValue(), (Account)this.getToPane().getAccountWidget().get(), (Mode)this.getToPane().getModeWidget().get(), (Category)this.getCategoryWidget().get(), this.getToPane().getValueDateField().getDate(), this.getToPane().getStatementField().getText(), subFrom);
        return result;
    }
}

