/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.util;

import com.fathzer.soft.ajlib.swing.table.JTable;
import com.fathzer.soft.ajlib.utilities.CSVWriter;
import com.fathzer.soft.ajlib.utilities.FileUtils;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import net.yapbam.gui.util.XTableColumnModel;
import net.yapbam.gui.widget.JLabelMenu;

public class FriendlyTable
extends JTable {
    private static final long serialVersionUID = 1L;

    public FriendlyTable() {
        this.setColumnModel(new XTableColumnModel());
    }

    public boolean isColumnVisible(int index) {
        XTableColumnModel model = (XTableColumnModel)this.getColumnModel();
        return model.isColumnVisible(model.getColumn(index, false));
    }

    public void setColumnVisible(int index, boolean visible) {
        XTableColumnModel model = (XTableColumnModel)this.getColumnModel();
        model.setColumnVisible(model.getColumn(index, false), visible);
    }

    public int getColumnCount(boolean onlyVisible) {
        XTableColumnModel model = (XTableColumnModel)this.getColumnModel();
        return model.getColumnCount(onlyVisible);
    }

    public String getColumnName(int index, boolean onlyVisible) {
        XTableColumnModel model = (XTableColumnModel)this.getColumnModel();
        if (onlyVisible) {
            return this.getColumnName(index);
        }
        return this.getModel().getColumnName(model.getColumn(index, onlyVisible).getModelIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(File file, ExportFormat format) throws IOException {
        FileWriter fileWriter = new FileWriter(FileUtils.getCanonical(file));
        try {
            CSVWriter out = new CSVWriter(fileWriter);
            out.setSeparator(format.getSeparator());
            int[] modelIndexes = new int[this.getColumnCount(false)];
            for (int colIndex = 0; colIndex < this.getColumnCount(false); ++colIndex) {
                if (!this.isColumnVisible(colIndex)) continue;
                modelIndexes[colIndex] = ((XTableColumnModel)this.getColumnModel()).getColumn(colIndex, false).getModelIndex();
                if (!format.hasHeader()) continue;
                out.writeCell(this.getModel().getColumnName(modelIndexes[colIndex]));
            }
            out.newLine();
            for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
                int modelRowIndex = this.convertRowIndexToModel(rowIndex);
                for (int colIndex = 0; colIndex < this.getColumnCount(false); ++colIndex) {
                    if (!this.isColumnVisible(colIndex)) continue;
                    Object obj = this.getModel().getValueAt(modelRowIndex, modelIndexes[colIndex]);
                    out.writeCell(format.format(obj));
                }
                out.newLine();
            }
            out.flush();
        }
        finally {
            ((Writer)fileWriter).close();
        }
    }

    public static interface ExportFormat {
        public boolean hasHeader();

        public char getSeparator();

        public String format(Object var1);
    }

    public static class ShowHideColumsMenu
    extends JLabelMenu {
        private static final long serialVersionUID = 1L;
        private FriendlyTable table;

        public ShowHideColumsMenu(FriendlyTable table, String title) {
            super(title);
            this.table = table;
        }

        @Override
        protected void fillPopUp(JPopupMenu popup) {
            for (int i = 0; i < this.table.getColumnCount(false); ++i) {
                JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(new ShowHideColumnAction(this.table, i));
                menuItem.setSelected(this.table.isColumnVisible(i));
                popup.add(menuItem);
            }
        }
    }

    private static final class ShowHideColumnAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private int index;
        private FriendlyTable table;

        public ShowHideColumnAction(FriendlyTable table, int i) {
            super(table.getColumnName(i, false));
            this.index = i;
            this.table = table;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean visible = !this.table.isColumnVisible(this.index);
            this.table.setColumnVisible(this.index, visible);
        }
    }
}

