/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.widget;

import com.fathzer.soft.javaluator.BracketPair;
import com.fathzer.soft.javaluator.DoubleEvaluator;
import com.fathzer.soft.javaluator.Parameters;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import net.yapbam.gui.LocalizationData;

public class CurrencyWidget
extends com.fathzer.soft.ajlib.swing.widget.CurrencyWidget {
    private static final DoubleEvaluator EVALUATOR = new Evaluator();
    private static final DecimalFormat US_FORMAT = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);

    public CurrencyWidget(Locale locale) {
        super(locale);
    }

    public CurrencyWidget() {
        this(LocalizationData.getLocale());
    }

    @Override
    protected Number parseValue(String text) {
        Number result = this.parseLiteral(text);
        if (result == null) {
            try {
                result = (Number)EVALUATOR.evaluate(text, (Object)this);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return result;
    }

    private Number parseLiteral(String text) {
        Number result = super.parseValue(text);
        if (result == null) {
            result = CurrencyWidget.safeParse(US_FORMAT, text);
        }
        return result;
    }

    private static class Evaluator
    extends DoubleEvaluator {
        Evaluator() {
            super(Evaluator.buildParameters());
        }

        private static Parameters buildParameters() {
            Parameters params = new Parameters();
            params.addExpressionBracket(BracketPair.PARENTHESES);
            params.add(DoubleEvaluator.MULTIPLY);
            params.add(DoubleEvaluator.DIVIDE);
            params.add(DoubleEvaluator.PLUS);
            params.add(DoubleEvaluator.MINUS);
            params.add(DoubleEvaluator.NEGATE);
            params.setFunctionArgumentSeparator(';');
            return params;
        }

        @Override
        protected Double toValue(String literal, Object evaluationContext) {
            CurrencyWidget widget = (CurrencyWidget)evaluationContext;
            Number result = widget.parseLiteral(literal);
            if (result == null) {
                throw new IllegalArgumentException();
            }
            return result.doubleValue();
        }
    }
}

