/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.remote;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.yapbam.remote.Cache;

public class MemoryCache
implements Cache {
    private ByteArrayOutputStream writer;
    private byte[] byteArrays;
    private long timeStamp = -1L;
    private long tmpTimeStamp = -1L;

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.writer = new ByteArrayOutputStream();
        this.tmpTimeStamp = System.currentTimeMillis();
        return this.writer;
    }

    @Override
    public InputStream getInputStream(boolean tmp) throws IOException {
        if (tmp) {
            if (this.writer == null) {
                throw new FileNotFoundException();
            }
            return new ByteArrayInputStream(this.writer.toByteArray());
        }
        if (this.byteArrays == null) {
            throw new FileNotFoundException();
        }
        return new ByteArrayInputStream(this.byteArrays);
    }

    @Override
    public void commit() {
        this.byteArrays = this.writer.toByteArray();
        this.timeStamp = this.tmpTimeStamp;
    }

    @Override
    public boolean isEmpty() {
        return this.byteArrays == null && this.writer == null;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }
}

