/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.server.exchange;

import java.io.IOException;
import java.io.Serializable;
import java.net.Proxy;
import net.yapbam.server.exchange.AccountExistsException;
import net.yapbam.server.exchange.InvalidAdminAccountException;
import net.yapbam.server.exchange.UserExistsException;
import net.yapbam.server.exchange.UserServerView;

public class AdminServerView
extends UserServerView {
    private static final String CREATE_USER_COMMAND = "CREATE_USER";
    private static final String CREATE_ACCOUNT_COMMAND = "CREATE_ACCOUNT";
    private static final int INVALID_ADMIN_ACCOUNT = 8;
    private static final int USER_EXISTS = 2;
    private static final int ACCOUNT_EXISTS = 5;

    public AdminServerView(Proxy proxy, String eMail, String password) {
        super(proxy, eMail, password);
    }

    @Override
    protected void codeToException(int errCode) {
        if (errCode == 8) {
            throw new InvalidAdminAccountException();
        }
        if (errCode == 2) {
            throw new UserExistsException();
        }
        if (errCode == 5) {
            throw new AccountExistsException();
        }
        super.codeToException(errCode);
    }

    public void createUser(String userEMail, String userPassword, boolean admin) throws IOException, InvalidAdminAccountException, UserExistsException {
        this.toServer(CREATE_USER_COMMAND, new Serializable[]{userEMail, userPassword, Boolean.valueOf(admin)});
    }

    public void createAccount(String userEMail, String account) throws IOException, InvalidAdminAccountException, AccountExistsException {
        this.toServer(CREATE_ACCOUNT_COMMAND, new Serializable[]{userEMail, account});
    }
}

