/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;

public final class CheckSum {
    private CheckSum() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getChecksum(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            int numRead;
            MessageDigest digest;
            byte[] buffer = new byte[1024];
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            do {
                if ((numRead = ((InputStream)is).read(buffer)) <= 0) continue;
                digest.update(buffer, 0, numRead);
            } while (numRead != -1);
            byte[] byArray = digest.digest();
            return byArray;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public static String[] getCheckSums(File[] versionFolders, String filePath) throws IOException {
        HashSet<String> checkSums = new HashSet<String>();
        for (File folder : versionFolders) {
            File file = new File(folder, filePath);
            if (!file.exists()) continue;
            checkSums.add(CheckSum.toString(CheckSum.getChecksum(file)));
        }
        return checkSums.toArray(new String[checkSums.size()]);
    }

    public static String toString(byte[] bytes) {
        String brute = new BigInteger(1, bytes).toString(16);
        if (brute.length() != bytes.length * 2) {
            StringBuilder builder = new StringBuilder(bytes.length * 2);
            for (int i = brute.length(); i < bytes.length * 2; ++i) {
                builder.append('0');
            }
            builder.append(brute);
            return builder.toString();
        }
        return brute;
    }

    public static byte[] toBytes(String string) {
        byte[] byteArray = new BigInteger(string, 16).toByteArray();
        int nbDigits = string.length();
        if (string.startsWith("-")) {
            --nbDigits;
        }
        int resultSize = nbDigits / 2;
        if (nbDigits % 2 != 0) {
            ++resultSize;
        }
        if (byteArray.length == resultSize) {
            return byteArray;
        }
        byte[] result = new byte[resultSize];
        if (byteArray.length < resultSize) {
            System.arraycopy(byteArray, 0, result, resultSize - byteArray.length, byteArray.length);
        } else {
            System.arraycopy(byteArray, byteArray.length - resultSize, result, 0, resultSize);
        }
        return result;
    }
}

