/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoolHttpConnection {
    private static final String HTTPS_PROTOCOL = "https";
    private static final Logger LOGGER = LoggerFactory.getLogger(CoolHttpConnection.class);
    public static final boolean IS_SSL_PATCHED;
    private static ProxiedFailover proxiedFailOver;
    private HttpURLConnection ct;

    public static void setProxiedFailOver(ProxiedFailover failOver) {
        proxiedFailOver = failOver;
    }

    private static boolean patchSSL() {
        String javaVersion = System.getProperty("java.version");
        boolean deactivate = false;
        if (javaVersion.startsWith("1.8_")) {
            try {
                int release = Integer.parseInt(javaVersion.substring("1.8_".length()));
                if (release < 101) {
                    deactivate = true;
                }
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Unable to find java 8 release number", e);
            }
        } else if (javaVersion.startsWith("1.7") || javaVersion.startsWith("1.6")) {
            deactivate = true;
        }
        if (deactivate) {
            CoolHttpConnection.deactivateSSLCertificate();
            LOGGER.warn("{} java version is too old, SSL certificate checking is deactivated", (Object)javaVersion);
        }
        return deactivate;
    }

    protected static void deactivateSSLCertificate() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CoolHttpConnection(URL url, Proxy proxy, URL ... failOvers) throws IOException {
        block4: {
            try {
                this.ct = this.buildConnection(url, proxy);
            }
            catch (IOException e) {
                if (!this.tryFailOvers(proxy, url, e, failOvers)) {
                    throw e;
                }
            }
            catch (RuntimeException e) {
                if (this.tryFailOvers(proxy, url, e, failOvers)) break block4;
                throw e;
            }
        }
    }

    private boolean tryFailOvers(Proxy proxy, URL original, Exception e, URL ... failOvers) throws IOException {
        LOGGER.warn("Error while trying target URL " + original, e);
        for (URL failOver : failOvers) {
            if (!this.tryIt(proxy, failOver)) continue;
            return true;
        }
        if (proxiedFailOver != null && IS_SSL_PATCHED) {
            if (HTTPS_PROTOCOL.equals(original.getProtocol()) && this.tryIt(proxy, proxiedFailOver.getProxied(original))) {
                return true;
            }
            for (URL failOver : failOvers) {
                if (!HTTPS_PROTOCOL.equals(failOver.getProtocol()) || !this.tryIt(proxy, proxiedFailOver.getProxied(failOver))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean tryIt(Proxy proxy, URL failOver) {
        try {
            this.ct = this.buildConnection(failOver, proxy);
            return true;
        }
        catch (Exception ee) {
            LOGGER.warn("Error while trying failover URL " + failOver, ee);
            return false;
        }
    }

    private HttpURLConnection buildConnection(URL url, Proxy proxy) throws IOException {
        HttpURLConnection connect = (HttpURLConnection)url.openConnection(proxy);
        if (connect.getResponseCode() == 301 || connect.getResponseCode() == 302) {
            String redirect = connect.getHeaderField("Location");
            connect.disconnect();
            url = new URL(redirect);
            return (HttpURLConnection)url.openConnection(proxy);
        }
        return connect;
    }

    public int getResponseCode() throws IOException {
        return this.ct.getResponseCode();
    }

    public InputStream getInputStream() throws IOException {
        return this.ct.getInputStream();
    }

    public String getContentEncoding() {
        return this.ct.getContentEncoding();
    }

    public String getHeaderField(String field) {
        return this.ct.getHeaderField(field);
    }

    static {
        proxiedFailOver = null;
        IS_SSL_PATCHED = CoolHttpConnection.patchSSL();
    }

    public static interface ProxiedFailover {
        public URL getProxied(URL var1) throws IOException;
    }
}

