/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.yapbam.util.Mangler;
import org.apache.commons.lang3.StringEscapeUtils;

public abstract class HtmlUtils {
    private static final Pattern P = Pattern.compile("\\[([^\\[\\]]*)\\[([^\\]]+)\\]\\]");
    private static final Mangler MANGLER = new Mangler("[]", '_');
    public static final String START_TAG = "<HTML>";
    public static final String END_TAG = "</HTML>";
    public static final String START_BODY_TAG = "<BODY>";
    public static final String END_BODY_TAG = "</BODY>";
    public static final String NEW_LINE_TAG = "<BR>";
    public static final String NON_BREAKING_SPACE = "&nbsp;";

    private HtmlUtils() {
    }

    public static String removeHtmlTags(String text) {
        String upper = (text = text.trim()).toUpperCase();
        if (upper.startsWith(START_TAG) && upper.endsWith(END_TAG)) {
            text = text.substring(START_TAG.length());
            text = text.substring(0, text.length() - END_TAG.length());
        }
        return text;
    }

    public static String toHtml(String content) {
        Matcher m = P.matcher(content);
        StringBuilder sb = new StringBuilder();
        int previousEnd = 0;
        while (m.find()) {
            if (previousEnd != m.start()) {
                sb.append(StringEscapeUtils.escapeHtml3(content.substring(previousEnd, m.start())));
            }
            previousEnd = m.end();
            if (HtmlUtils.isValidURL(m.group(2))) {
                sb.append(HtmlUtils.getHTMLLink(m.group(1), m.group(2)));
                continue;
            }
            sb.append(content.substring(m.start(), previousEnd));
        }
        if (previousEnd < content.length()) {
            sb.append(StringEscapeUtils.escapeHtml3(content.substring(previousEnd)));
        }
        return sb.toString();
    }

    private static String getHTMLLink(String name, String url) {
        return "<a href=\"" + url + "\">" + StringEscapeUtils.escapeHtml3(name.isEmpty() ? url : MANGLER.unmangle(name)) + "</a>";
    }

    public static Matcher getLink(String encodedContent, int start, int end) {
        Matcher m = P.matcher(encodedContent);
        while (m.find()) {
            if (m.start() >= end || start >= m.end()) continue;
            if (HtmlUtils.isValidURL(m.group(2))) {
                return m;
            }
            return null;
        }
        return null;
    }

    public static boolean isValidURL(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static String toEncoded(String name, String url) {
        return '[' + MANGLER.mangle(name) + '[' + url + "]]";
    }

    public static String decodeLinkName(String name) {
        return MANGLER.unmangle(name);
    }
}

