/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine;

import java.math.BigDecimal;
import java.util.logging.Level;
import java.util.logging.Logger;
import jgnash.engine.Account;
import jgnash.engine.ReconciledState;
import jgnash.engine.TransactionTag;

public class TransactionEntry
implements Comparable<TransactionEntry>,
Cloneable {
    private int hash = 0;
    private String transactionTag = TransactionTag.BANK.name();
    private transient TransactionTag cachedTransactionTag;
    private Account debitAccount;
    private Account creditAccount;
    private BigDecimal creditAmount = BigDecimal.ZERO;
    private BigDecimal debitAmount = BigDecimal.ZERO;
    private ReconciledState creditReconciled = ReconciledState.NOT_RECONCILED;
    private ReconciledState debitReconciled = ReconciledState.NOT_RECONCILED;
    private String memo = "";

    public TransactionEntry() {
    }

    public TransactionEntry(Account account, BigDecimal amount) {
        assert (account != null && amount != null);
        this.creditAccount = account;
        this.debitAccount = account;
        this.creditAmount = amount;
        this.debitAmount = amount;
    }

    protected TransactionEntry(Account creditAccount, Account debitAccount, BigDecimal amount) {
        assert (creditAccount != null && debitAccount != null && amount != null);
        this.creditAccount = creditAccount;
        this.debitAccount = debitAccount;
        this.setAmount(amount.abs());
    }

    protected TransactionEntry(Account creditAccount, Account debitAccount, BigDecimal creditAmount, BigDecimal debitAmount) {
        assert (creditAccount != null && debitAccount != null && creditAmount != null && debitAmount != null);
        assert (creditAmount.signum() == 1 && debitAmount.signum() == -1);
        this.creditAccount = creditAccount;
        this.debitAccount = debitAccount;
        this.creditAmount = creditAmount;
        this.debitAmount = debitAmount;
    }

    public BigDecimal getCreditAmount() {
        return this.creditAmount;
    }

    public BigDecimal getAmount(Account account) {
        assert (account != null);
        if (account.equals(this.creditAccount)) {
            return this.creditAmount;
        }
        if (account.equals(this.debitAccount)) {
            return this.debitAmount;
        }
        return BigDecimal.ZERO;
    }

    public final void setAmount(BigDecimal amount) {
        assert (amount != null && amount.signum() >= 0);
        this.creditAmount = amount;
        this.debitAmount = amount.negate();
    }

    public Account getCreditAccount() {
        return this.creditAccount;
    }

    ReconciledState getCreditReconciled() {
        return this.creditReconciled;
    }

    public Account getDebitAccount() {
        return this.debitAccount;
    }

    ReconciledState getDebitReconciled() {
        return this.debitReconciled;
    }

    public String getMemo() {
        return this.memo;
    }

    public ReconciledState getReconciled(Account account) {
        if (account == this.getDebitAccount()) {
            return this.debitReconciled;
        }
        if (account == this.getCreditAccount()) {
            return this.creditReconciled;
        }
        return ReconciledState.NOT_RECONCILED;
    }

    public void setCreditAmount(BigDecimal amount) {
        this.creditAmount = amount;
    }

    public void setCreditAccount(Account creditAccount) {
        this.creditAccount = creditAccount;
    }

    void setCreditReconciled(ReconciledState creditReconciled) {
        this.creditReconciled = creditReconciled;
    }

    public void setDebitAccount(Account debitAccount) {
        this.debitAccount = debitAccount;
    }

    void setDebitReconciled(ReconciledState debitReconciled) {
        this.debitReconciled = debitReconciled;
    }

    public void setMemo(String memo) {
        if (memo != null) {
            this.memo = memo;
        }
    }

    public void setReconciled(Account account, ReconciledState reconciled) {
        if (account.equals(this.getCreditAccount())) {
            this.setCreditReconciled(reconciled);
        } else if (account.equals(this.getDebitAccount())) {
            this.setDebitReconciled(reconciled);
        }
    }

    public BigDecimal getDebitAmount() {
        return this.debitAmount;
    }

    public void setDebitAmount(BigDecimal debitAmount) {
        this.debitAmount = debitAmount;
    }

    @Override
    public int compareTo(TransactionEntry entry) {
        if (this == entry) {
            return 0;
        }
        int result = this.memo.compareTo(entry.getMemo());
        if (result != 0) {
            return result;
        }
        result = this.transactionTag.compareTo(entry.transactionTag);
        if (result != 0) {
            return result;
        }
        if (this.hashCode() > entry.hashCode()) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object entry) {
        assert (entry instanceof TransactionEntry);
        return this.equals((TransactionEntry)entry);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = 5;
            h = 17 * h + (this.transactionTag != null ? this.transactionTag.hashCode() : 0);
            h = 17 * h + (this.debitAccount != null ? this.debitAccount.hashCode() : 0);
            h = 17 * h + (this.creditAccount != null ? this.creditAccount.hashCode() : 0);
            h = 17 * h + (this.creditAmount != null ? this.creditAmount.hashCode() : 0);
            h = 17 * h + (this.debitAmount != null ? this.debitAmount.hashCode() : 0);
            h = 17 * h + (this.creditReconciled != null ? this.creditReconciled.hashCode() : 0);
            h = 17 * h + (this.debitReconciled != null ? this.debitReconciled.hashCode() : 0);
            this.hash = h = 17 * h + (this.memo != null ? this.memo.hashCode() : 0);
        }
        return h;
    }

    boolean equals(TransactionEntry entry) {
        if (this == entry) {
            return true;
        }
        if (!this.creditAccount.equals(entry.getCreditAccount())) {
            return false;
        }
        if (!this.debitAccount.equals(entry.getDebitAccount())) {
            return false;
        }
        if (!this.creditAmount.equals(entry.getCreditAmount())) {
            return false;
        }
        if (!this.debitAmount.equals(entry.getDebitAmount())) {
            return false;
        }
        if (this.creditReconciled != entry.creditReconciled) {
            return false;
        }
        if (this.debitReconciled != entry.debitReconciled) {
            return false;
        }
        return this.memo.equals(entry.getMemo());
    }

    public boolean isSingleEntry() {
        return this.creditAccount.equals(this.debitAccount) && this.creditAmount.equals(this.debitAmount);
    }

    public void setTransactionTag(TransactionTag transactionTag) {
        this.transactionTag = transactionTag.name();
        this.cachedTransactionTag = transactionTag;
    }

    public TransactionTag getTransactionTag() {
        if (this.cachedTransactionTag == null) {
            this.cachedTransactionTag = TransactionTag.valueOf(this.transactionTag);
        }
        return this.cachedTransactionTag;
    }

    public Object clone() throws CloneNotSupportedException {
        TransactionEntry e = null;
        try {
            e = (TransactionEntry)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(TransactionEntry.class.getName()).log(Level.SEVERE, ex.toString(), ex);
        }
        return e;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TransactionEntry hashCode: ").append(this.hashCode()).append('\n');
        b.append("Tag:            ").append(this.getTransactionTag().name()).append('\n');
        b.append("Memo:           ").append(this.getMemo()).append('\n');
        b.append("Debit Account:  ").append(this.getDebitAccount().getName()).append('\n');
        b.append("Credit Account: ").append(this.getCreditAccount().getName()).append('\n');
        b.append("Debit Amount:   ").append(this.getDebitAmount().toPlainString()).append('\n');
        b.append("Credit Amount:  ").append(this.getCreditAmount().toPlainString()).append('\n');
        return b.toString();
    }
}

