/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.db4o;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.config.Configuration;
import com.db4o.config.ObjectTranslator;
import com.db4o.events.Event4;
import com.db4o.events.EventArgs;
import com.db4o.events.EventListener4;
import com.db4o.events.EventRegistry;
import com.db4o.events.EventRegistryFactory;
import com.db4o.events.ObjectEventArgs;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.logging.Logger;
import jgnash.engine.Account;
import jgnash.engine.AccountProperty;
import jgnash.engine.Config;
import jgnash.engine.CurrencyNode;
import jgnash.engine.DataStore;
import jgnash.engine.Engine;
import jgnash.engine.ExchangeRate;
import jgnash.engine.InvestmentTransaction;
import jgnash.engine.RootAccount;
import jgnash.engine.SecurityNode;
import jgnash.engine.StoredObject;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionEntry;
import jgnash.engine.TrashObject;
import jgnash.engine.budget.Budget;
import jgnash.engine.db4o.Db4oEngineDAO;
import jgnash.engine.db4o.config.TBigDecimal;
import jgnash.engine.db4o.config.TBigInteger;
import jgnash.engine.db4o.config.TEnum;
import jgnash.engine.recurring.DailyReminder;
import jgnash.engine.recurring.MonthlyReminder;
import jgnash.engine.recurring.OneTimeReminder;
import jgnash.engine.recurring.Reminder;
import jgnash.engine.recurring.WeeklyReminder;
import jgnash.engine.recurring.YearlyReminder;
import jgnash.util.Resource;

public class Db4oDataStore
implements DataStore {
    private static final String FILE_EXT = "jdb";
    private boolean remote;
    private String fileName;
    private ObjectContainer db;
    private EventListener4 transactionDeletedListener;
    private EventListener4 accountDeletedListener;
    private static final boolean DEBUG = false;

    static Configuration createConfig() {
        Configuration config = Db4o.newConfiguration();
        config.optimizeNativeQueries(true);
        config.callConstructors(true);
        config.reserveStorageSpace(400000L);
        config.objectClass(BigDecimal.class).translate((ObjectTranslator)new TBigDecimal());
        config.objectClass(BigInteger.class).translate((ObjectTranslator)new TBigInteger());
        config.objectClass(Enum.class).translate((ObjectTranslator)new TEnum());
        config.objectClass(ExchangeRate.class).cascadeOnUpdate(true);
        config.objectClass(ExchangeRate.class).cascadeOnActivate(true);
        config.objectClass(SecurityNode.class).cascadeOnUpdate(true);
        config.objectClass(SecurityNode.class).cascadeOnActivate(true);
        config.objectClass(CurrencyNode.class).cascadeOnActivate(true);
        config.objectClass(CurrencyNode.class).cascadeOnUpdate(true);
        config.objectClass(Budget.class).cascadeOnActivate(true);
        config.objectClass(Budget.class).cascadeOnUpdate(true);
        config.objectClass(Config.class).cascadeOnActivate(true);
        config.objectClass(Config.class).cascadeOnUpdate(true);
        config.objectClass(Account.class).cascadeOnActivate(true);
        config.objectClass(Account.class).objectField("propertyMap").cascadeOnUpdate(true);
        config.objectClass(Account.class).updateDepth(1);
        config.objectClass(RootAccount.class).updateDepth(1);
        config.objectClass(DailyReminder.class).cascadeOnActivate(true);
        config.objectClass(DailyReminder.class).cascadeOnUpdate(true);
        config.objectClass(MonthlyReminder.class).cascadeOnActivate(true);
        config.objectClass(MonthlyReminder.class).cascadeOnUpdate(true);
        config.objectClass(OneTimeReminder.class).cascadeOnActivate(true);
        config.objectClass(OneTimeReminder.class).cascadeOnUpdate(true);
        config.objectClass(WeeklyReminder.class).cascadeOnActivate(true);
        config.objectClass(WeeklyReminder.class).cascadeOnUpdate(true);
        config.objectClass(YearlyReminder.class).cascadeOnActivate(true);
        config.objectClass(YearlyReminder.class).cascadeOnUpdate(true);
        config.objectClass(Reminder.class).cascadeOnActivate(true);
        config.objectClass(Reminder.class).cascadeOnUpdate(true);
        config.objectClass(TrashObject.class).cascadeOnActivate(true);
        config.objectClass(TrashObject.class).cascadeOnUpdate(true);
        config.objectClass(InvestmentTransaction.class).cascadeOnActivate(true);
        config.objectClass(Transaction.class).cascadeOnActivate(true);
        config.objectClass(TransactionEntry.class).cascadeOnActivate(true);
        config.objectClass(StoredObject.class).indexed(true);
        config.objectClass(Account.class).indexed(true);
        config.objectClass(Budget.class).indexed(true);
        config.objectClass(CurrencyNode.class).indexed(true);
        config.objectClass(Reminder.class).indexed(true);
        config.objectClass(RootAccount.class).indexed(true);
        config.objectClass(StoredObject.class).objectField("uuid").indexed(true);
        config.objectClass(StoredObject.class).objectField("markedForRemoval").indexed(true);
        config.objectClass(Account.class).objectField("accountType").indexed(true);
        config.objectClass(ExchangeRate.class).objectField("rateId").indexed(true);
        config.exceptionsOnNotStorable(true);
        config.automaticShutDown(true);
        config.messageLevel(1);
        return config;
    }

    @Override
    public final String getFileExt() {
        return FILE_EXT;
    }

    @Override
    public final String getFileName() {
        return this.fileName;
    }

    private ObjectContainer createLocalContainer(String filename) {
        boolean result;
        File parent;
        Configuration config = Db4oDataStore.createConfig();
        File file = new File(filename);
        if (!(file.exists() || (parent = file.getParentFile()) == null || parent.exists() || (result = parent.mkdirs()))) {
            throw new RuntimeException("Could not create directory for file: " + parent.getAbsolutePath());
        }
        ObjectContainer container = Db4o.openFile((Configuration)config, (String)filename);
        this.registerListeners(container);
        return container;
    }

    private ObjectContainer createClientContainer(String host, int port, String user, String password) {
        Configuration config = Db4oDataStore.createConfig();
        ObjectContainer container = Db4o.openClient((Configuration)config, (String)host, (int)port, (String)user, (String)password);
        this.registerListeners(container);
        return container;
    }

    private void registerListeners(ObjectContainer container) {
        EventRegistry registry = EventRegistryFactory.forObjectContainer((ObjectContainer)container);
        this.transactionDeletedListener = new TransactionDeletedListener(container);
        this.accountDeletedListener = new AccountDeletedListener(container);
        registry.deleted().addListener(this.transactionDeletedListener);
        registry.deleted().addListener(this.accountDeletedListener);
    }

    private void unregisterListeners(ObjectContainer container) {
        EventRegistry registry = EventRegistryFactory.forObjectContainer((ObjectContainer)container);
        registry.deleted().removeListener(this.transactionDeletedListener);
        registry.deleted().removeListener(this.accountDeletedListener);
        this.transactionDeletedListener = null;
        this.accountDeletedListener = null;
    }

    @Override
    public Engine getLocalEngine(String filename, String engineName) {
        this.db = this.createLocalContainer(filename);
        Engine engine = null;
        if (this.db != null) {
            Logger.getLogger(Db4oDataStore.class.getName()).info("Created local db4o container and engine");
            engine = new Engine(new Db4oEngineDAO(this.db, false), engineName);
            this.fileName = filename;
            this.remote = false;
        }
        return engine;
    }

    @Override
    public Engine getClientEngine(String host, int port, String user, String password, String engineName) {
        this.db = this.createClientContainer(host, port, user, password);
        Engine engine = null;
        if (this.db != null) {
            Logger.getLogger(Db4oDataStore.class.getName()).info("Created client db4o container and engine");
            engine = new Engine(new Db4oEngineDAO(this.db, true), engineName);
            this.fileName = null;
            this.remote = true;
        }
        return engine;
    }

    @Override
    public void closeEngine() {
        if (this.db != null) {
            this.db.commit();
            this.unregisterListeners(this.db);
            this.db.close();
        }
    }

    @Override
    public boolean isRemote() {
        return this.remote;
    }

    @Override
    public void saveAs(File file, Collection<StoredObject> objects) {
        Configuration config = Db4oDataStore.createConfig();
        ObjectContainer container = Db4o.openFile((Configuration)config, (String)file.getAbsolutePath());
        for (StoredObject o : objects) {
            container.set((Object)o);
        }
        container.commit();
        container.close();
    }

    public String toString() {
        return Resource.get().getString("DataStoreType.Db4o");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float getFileVersion(File file) {
        float fileVersion = 0.0f;
        Configuration config = Db4oDataStore.createConfig();
        config.readOnly(true);
        ObjectContainer container = null;
        try {
            container = Db4o.openFile((Configuration)config, (String)file.getAbsolutePath());
            ObjectSet set = container.query(Config.class);
            if (set.size() == 1) {
                fileVersion = ((Config)set.get(0)).getFileVersion();
            } else {
                Logger.getLogger(Db4oDataStore.class.getName()).severe("Invalid file");
            }
        }
        catch (Exception e) {
            container = null;
            Logger.getLogger(Db4oDataStore.class.getName()).warning("Tried to open an incompatible file version");
        }
        finally {
            if (container != null) {
                container.close();
            }
        }
        return fileVersion;
    }

    private static class AccountDeletedListener
    implements EventListener4 {
        private final ObjectContainer container;

        AccountDeletedListener(ObjectContainer container) {
            this.container = container;
        }

        public void onEvent(Event4 e, EventArgs args) {
            if (args instanceof ObjectEventArgs) {
                ObjectEventArgs queryArgs = (ObjectEventArgs)args;
                Object obj = queryArgs.object();
                if (obj instanceof Account) {
                    Account account = (Account)obj;
                    for (AccountProperty key : account.getProperties()) {
                        Object o = account.getProperty(key);
                        this.container.delete(o);
                        this.container.ext().purge(o);
                    }
                }
            } else {
                throw new RuntimeException("Unexpected event");
            }
        }
    }

    private static class TransactionDeletedListener
    implements EventListener4 {
        private final ObjectContainer container;

        TransactionDeletedListener(ObjectContainer container) {
            this.container = container;
        }

        public void onEvent(Event4 e, EventArgs args) {
            if (args instanceof ObjectEventArgs) {
                ObjectEventArgs queryArgs = (ObjectEventArgs)args;
                Object obj = queryArgs.object();
                if (obj instanceof Transaction) {
                    for (TransactionEntry entry : ((Transaction)obj).getTransactionEntries()) {
                        this.container.delete((Object)entry);
                        this.container.ext().purge((Object)entry);
                    }
                }
            } else {
                throw new RuntimeException("Unexpected event");
            }
        }
    }
}

