/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.account;

import com.jgoodies.forms.builder.ButtonStackBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import jgnash.engine.Account;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.SecurityNode;
import jgnash.ui.components.SortedListModel;
import jgnash.util.Resource;

class AccountSecuritiesPanel
extends JPanel
implements ActionListener {
    private Resource rb = Resource.get();
    private Engine engine = EngineFactory.getEngine("default");
    private JButton addButton;
    private JButton removeButton;
    private JList availJList;
    private JList selectedJList;
    private SortedListModel<SecurityElement> availModel;
    private SortedListModel<SecurityElement> selectedModel;
    private Account account;

    AccountSecuritiesPanel(Account account) {
        this.account = account;
        this.layoutMainPanel();
    }

    private void initComponents() {
        this.addButton = new JButton(this.rb.getString("Button.Add"), Resource.getIcon("/jgnash/resource/list-add.png"));
        this.addButton.setHorizontalTextPosition(10);
        this.removeButton = new JButton(this.rb.getString("Button.Remove"), Resource.getIcon("/jgnash/resource/list-remove.png"));
        this.availJList = new JList();
        this.selectedJList = new JList();
        this.selectedJList.setCellRenderer(new SecurityRenderer(this.selectedJList.getCellRenderer()));
        this.addButton.addActionListener(this);
        this.removeButton.addActionListener(this);
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("75dlu:g(0.5), 8dlu, p, 8dlu, 75dlu:g(0.5)", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.appendTitle(this.rb.getString("Title.Available"));
        builder.append("");
        builder.appendTitle(this.rb.getString("Title.Current"));
        builder.appendRow("f:p:g(1.0)");
        builder.append((Component)new JScrollPane(this.availJList));
        builder.append((Component)this.layoutButtonStack());
        builder.append((Component)new JScrollPane(this.selectedJList));
    }

    private JPanel layoutButtonStack() {
        ButtonStackBuilder builder = new ButtonStackBuilder();
        builder.addGridded((JComponent)this.addButton);
        builder.addRelatedGap();
        builder.addGridded((JComponent)this.removeButton);
        return builder.getPanel();
    }

    private void addAction() {
        SecurityElement obj = (SecurityElement)this.availJList.getSelectedValue();
        if (obj != null) {
            this.availModel.removeElement(obj);
            this.selectedModel.addElement(obj);
        }
    }

    private void removeAction() {
        SecurityElement obj = (SecurityElement)this.selectedJList.getSelectedValue();
        if (obj != null && obj.enabled) {
            this.selectedModel.removeElement(obj);
            this.availModel.addElement(obj);
        }
    }

    public void setSecuritiesList(Set<SecurityNode> list) {
        this.selectedModel = new SortedListModel();
        if (this.account != null) {
            Set<SecurityNode> used = this.account.getUsedSecurities();
            for (SecurityNode node : list) {
                if (used.contains(node)) {
                    this.selectedModel.addElement(new SecurityElement(node, false));
                    continue;
                }
                this.selectedModel.addElement(new SecurityElement(node, true));
            }
        } else {
            for (SecurityNode node : list) {
                this.selectedModel.addElement(new SecurityElement(node, true));
            }
        }
        this.selectedJList.setModel(this.selectedModel);
        this.buildAvailableList();
    }

    public Set<SecurityNode> getSecuritiesList() {
        TreeSet<SecurityNode> set = new TreeSet<SecurityNode>();
        for (SecurityElement e : this.selectedModel.asList()) {
            set.add(e.getNode());
        }
        return set;
    }

    private void buildAvailableList() {
        ArrayList<SecurityElement> list = new ArrayList<SecurityElement>();
        for (SecurityNode node : this.engine.getSecurities()) {
            list.add(new SecurityElement(node, true));
        }
        ArrayList<SecurityElement> tList = new ArrayList<SecurityElement>();
        for (SecurityElement node : list) {
            if (this.selectedModel.contains(node)) continue;
            tList.add(node);
        }
        this.availModel = new SortedListModel(tList);
        this.availJList.setModel(this.availModel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addButton) {
            this.addAction();
        } else if (e.getSource() == this.removeButton) {
            this.removeAction();
        }
    }

    private static final class SecurityRenderer
    implements ListCellRenderer {
        private ListCellRenderer delegate;

        public SecurityRenderer(ListCellRenderer delegate) {
            this.delegate = delegate;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            boolean enabled = ((SecurityElement)value).isEnabled();
            Component c = this.delegate.getListCellRendererComponent(list, value, index, isSelected, hasFocus);
            c.setEnabled(enabled);
            return c;
        }
    }

    static final class SecurityElement
    implements Comparable<SecurityElement> {
        private SecurityNode node;
        private boolean enabled;

        SecurityElement(SecurityNode node, boolean enabled) {
            this.node = node;
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public SecurityNode getNode() {
            return this.node;
        }

        public String toString() {
            return this.node.toString();
        }

        @Override
        public int compareTo(SecurityElement cnode) {
            return this.node.compareTo(cnode.node);
        }

        public int hashCode() {
            return this.node.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SecurityElement other = (SecurityElement)obj;
            return this.node == other.node || this.node != null && this.node.equals(other.node);
        }
    }
}

