/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register.invest;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import jgnash.engine.Account;
import jgnash.engine.TransactionEntry;
import jgnash.ui.ThemeManager;
import jgnash.ui.components.JFloatField;
import jgnash.ui.plaf.NimbusUtils;
import jgnash.ui.register.invest.IncomeDialog;
import jgnash.util.Resource;

class GainsPanel
extends JPanel
implements ActionListener {
    private JFloatField gainsField;
    private JButton gainsButton;
    private Account account;
    private List<TransactionEntry> gainsList = new ArrayList<TransactionEntry>();

    GainsPanel(Account account) {
        this.account = account;
        this.gainsField = new JFloatField(account.getCurrencyNode());
        this.gainsField.setEditable(false);
        this.gainsButton = new JButton(Resource.getIcon("/jgnash/resource/document-properties.png"));
        this.gainsButton.setMargin(new Insets(0, 0, 0, 0));
        this.gainsButton.addActionListener(this);
        this.gainsButton.setFocusPainted(false);
        if (ThemeManager.isLookAndFeelNimbus()) {
            NimbusUtils.reduceNimbusButtonMargin(this.gainsButton);
            this.gainsButton.setIcon(NimbusUtils.scaleIcon(Resource.getIcon("/jgnash/resource/document-properties.png")));
        }
        this.layoutPanel();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        IncomeDialog d;
        boolean status;
        if (e.getSource() == this.gainsButton && (status = (d = IncomeDialog.getIncomeDialog(this, this.account, this.gainsList)).showIncomeDialog())) {
            this.setTransactionEntries(d.getSplits());
            this.fireActionPerformed();
        }
    }

    private void layoutPanel() {
        FormLayout layout = new FormLayout("55dlu:g, 1px, min", "f:p");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.append((Component)this.gainsField, (Component)this.gainsButton);
    }

    public List<TransactionEntry> getTransactions() {
        return this.gainsList;
    }

    public void setTransactionEntries(List<TransactionEntry> gains) {
        this.gainsList = new ArrayList<TransactionEntry>();
        for (TransactionEntry entry : gains) {
            try {
                this.gainsList.add((TransactionEntry)entry.clone());
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        if (this.sumGains().compareTo(BigDecimal.ZERO) != 0) {
            this.gainsField.setDecimal(this.sumGains());
        } else {
            this.gainsField.setDecimal(null);
        }
    }

    private BigDecimal sumGains() {
        BigDecimal sum = BigDecimal.ZERO;
        for (TransactionEntry entry : this.gainsList) {
            sum = sum.add(entry.getAmount(this.account));
        }
        return sum;
    }

    void clearForm() {
        this.gainsList = new ArrayList<TransactionEntry>();
        this.gainsField.setDecimal(null);
    }

    void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    private void fireActionPerformed() {
        ActionEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (event == null) {
                event = new ActionEvent(this, 1001, null);
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }
}

