/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register.table;

import java.math.BigDecimal;
import java.util.Date;
import jgnash.engine.Account;
import jgnash.engine.InvestmentTransaction;
import jgnash.engine.Transaction;
import jgnash.ui.register.table.AbstractRegisterTableModel;
import jgnash.ui.register.table.QuantityStyle;
import jgnash.ui.register.table.ShortCommodityStyle;

public class InvestmentRegisterTableModel
extends AbstractRegisterTableModel {
    private static final long serialVersionUID = -8280207838778167891L;
    private static String[] names = new String[]{rb.getString("Column.Date"), rb.getString("Column.Action"), rb.getString("Column.Investment"), rb.getString("Column.Clr"), rb.getString("Column.Quantity"), rb.getString("Column.Price"), rb.getString("Column.Total")};
    private static int[] PREF_COLUMN_WEIGHTS = new int[]{0, 0, 20, 0, 0, 0, 0};
    private static Class<?>[] clazz = new Class[]{Date.class, String.class, String.class, String.class, QuantityStyle.class, ShortCommodityStyle.class, ShortCommodityStyle.class};

    public InvestmentRegisterTableModel(Account account) {
        super(account, names, clazz);
        this.setPreferredColumnWeights(PREF_COLUMN_WEIGHTS);
    }

    @Override
    public Object getInternalValueAt(int row, int col) {
        InvestmentTransaction _t = null;
        Transaction t = this.getTransactionAt(row);
        if (t instanceof InvestmentTransaction) {
            _t = (InvestmentTransaction)t;
        }
        switch (col) {
            case 0: {
                return t.getDate();
            }
            case 1: {
                if (_t != null) {
                    return _t.getTransactionType().toString();
                }
                if (t.getAmount(this.account).signum() > 0) {
                    return rb.getString("Item.CashDeposit");
                }
                return rb.getString("Item.CashWithdrawl");
            }
            case 2: {
                if (_t != null) {
                    return _t.getSecurityNode().getSymbol();
                }
                return t.getMemo();
            }
            case 3: {
                return t.getReconciled(this.account).toString();
            }
            case 4: {
                BigDecimal quantity;
                if (_t != null && (quantity = _t.getQuantity()).compareTo(BigDecimal.ZERO) != 0) {
                    return quantity;
                }
                return null;
            }
            case 5: {
                BigDecimal price;
                if (_t != null && (price = _t.getPrice()).compareTo(BigDecimal.ZERO) != 0) {
                    return price;
                }
                return null;
            }
            case 6: {
                if (_t != null) {
                    return _t.getNetCashValue();
                }
                return t.getAmount(this.account);
            }
        }
        return "error";
    }
}

