/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.util;

import java.awt.Component;
import java.util.regex.Pattern;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jgnash.ui.register.table.PackableTableModel;

public class JTableUtils {
    private static final int MIN_WIDTH_PADDING = 15;
    private static final Pattern SPACE_DELIMITER_PATTERN = Pattern.compile(" ");

    private JTableUtils() {
    }

    public static String getColumnOrder(JTable table) {
        StringBuilder buffer = new StringBuilder();
        int count = table.getColumnCount();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buffer.append(' ');
            }
            buffer.append(table.convertColumnIndexToModel(i));
        }
        return buffer.toString();
    }

    public static void setColumnOrder(JTable table, String positions) {
        int count;
        if (positions == null) {
            return;
        }
        String[] array = SPACE_DELIMITER_PATTERN.split(positions);
        if (array.length == (count = table.getColumnCount())) {
            for (int i = 0; i < count; ++i) {
                int index = table.convertColumnIndexToView(i);
                int position = Integer.parseInt(array[i]);
                table.getColumnModel().moveColumn(index, position);
            }
        }
    }

    public static String getColumnWidths(JTable table) {
        assert (table != null);
        TableColumnModel model = table.getColumnModel();
        int count = model.getColumnCount();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buffer.append(' ');
            }
            int index = table.convertColumnIndexToView(i);
            buffer.append(model.getColumn(index).getWidth());
        }
        return buffer.toString();
    }

    public static void setColumnWidths(JTable table, String widths) {
        assert (table != null);
        if (widths == null) {
            JTableUtils.packTable(table);
            return;
        }
        String[] array = SPACE_DELIMITER_PATTERN.split(widths);
        TableColumnModel model = table.getColumnModel();
        int count = model.getColumnCount();
        if (count == array.length) {
            for (int i = 0; i < count; ++i) {
                int width = Integer.parseInt(array[i]);
                model.getColumn(i).setPreferredWidth(width);
            }
        } else {
            JTableUtils.packTable(table);
        }
    }

    public static void packGenericTable(JTable table) {
        TableColumnModel model = table.getColumnModel();
        int columns = model.getColumnCount();
        for (int i = 0; i < columns; ++i) {
            TableColumn col = model.getColumn(i);
            TableCellRenderer renderer = col.getHeaderRenderer();
            if (renderer == null) {
                renderer = table.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
            int width = comp.getPreferredSize().width;
            int rows = table.getRowCount();
            for (int r = 0; r < rows; ++r) {
                renderer = table.getCellRenderer(r, i);
                comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, i), false, false, r, i);
                width = Math.max(width, comp.getPreferredSize().width);
            }
            col.setPreferredWidth(width + 15);
        }
    }

    public static void packTable(JTable table) {
        if (!(table.getModel() instanceof PackableTableModel)) {
            JTableUtils.packGenericTable(table);
            return;
        }
        PackableTableModel model = (PackableTableModel)table.getModel();
        int tableWidth = table.getWidth();
        int[] widths = new int[model.getColumnCount()];
        int tWidth = 0;
        for (int i = 0; i < model.getColumnCount(); ++i) {
            TableColumn col = table.getColumnModel().getColumn(i);
            TableCellRenderer renderer = col.getHeaderRenderer();
            if (renderer == null) {
                renderer = table.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
            int width = comp.getMinimumSize().width;
            int rows = table.getRowCount();
            for (int r = 0; r < rows; ++r) {
                renderer = table.getCellRenderer(r, i);
                comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, i), false, false, r, i);
                width = Math.max(width, comp.getMinimumSize().width);
            }
            widths[i] = width;
            if (i != model.getColumnCount() - 1) {
                int n = i;
                widths[n] = widths[n] + 4;
            } else {
                int n = i;
                widths[n] = widths[n] + 15;
            }
            tWidth += widths[i];
        }
        int[] optimizedWidths = (int[])widths.clone();
        if (tWidth > tableWidth) {
            int[] columnWeights = (int[])model.getPreferredColumnWeights().clone();
            int fixedWidth = 0;
            for (int i = 0; i < optimizedWidths.length; ++i) {
                if (columnWeights[i] != 0) continue;
                fixedWidth += optimizedWidths[i];
            }
            int diff = tableWidth - fixedWidth;
            int totalWeight = 0;
            for (int columnWeight : columnWeights) {
                totalWeight += columnWeight;
            }
            for (int i = 0; i < columnWeights.length; ++i) {
                if (columnWeights[i] <= 0) continue;
                int adj = (int)((float)columnWeights[i] / (float)totalWeight * (float)diff);
                if (optimizedWidths[i] > adj) {
                    optimizedWidths[i] = adj;
                    continue;
                }
                diff -= optimizedWidths[i];
                totalWeight -= columnWeights[i];
                optimizedWidths = (int[])widths.clone();
                columnWeights[i] = 0;
                i = -1;
            }
        }
        for (int i = 0; i < model.getColumnCount(); ++i) {
            TableColumn col = table.getColumnModel().getColumn(i);
            col.setPreferredWidth(optimizedWidths[i]);
        }
    }

    public static void packTables(JTable tableOne, JTable tableTwo) {
        JTableUtils.packGenericTable(tableOne);
        JTableUtils.packGenericTable(tableTwo);
        for (int i = 0; i < tableOne.getModel().getColumnCount(); ++i) {
            int footerTableWidth;
            int tableWidth = tableOne.getColumnModel().getColumn(i).getPreferredWidth();
            if (tableWidth > (footerTableWidth = tableTwo.getColumnModel().getColumn(i).getPreferredWidth())) {
                tableTwo.getColumnModel().getColumn(i).setPreferredWidth(tableWidth);
                continue;
            }
            tableOne.getColumnModel().getColumn(i).setPreferredWidth(footerTableWidth);
        }
    }
}

