/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation.network;

import com.db4o.Db4oIOException;
import com.db4o.config.NativeSocketFactory;
import com.db4o.foundation.network.Socket4;
import com.db4o.internal.Platform4;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;

public class NetworkSocket
implements Socket4 {
    private Socket _socket;
    private OutputStream _out;
    private InputStream _in;
    private String _hostName;
    private NativeSocketFactory _factory;

    public NetworkSocket(NativeSocketFactory nativeSocketFactory, String string, int n) throws Db4oIOException {
        this._factory = nativeSocketFactory;
        try {
            Socket socket = this._factory.createSocket(string, n);
            this.initSocket(socket);
        }
        catch (IOException iOException) {
            throw new Db4oIOException(iOException);
        }
        this._hostName = string;
    }

    public NetworkSocket(NativeSocketFactory nativeSocketFactory, Socket socket) throws IOException {
        this._factory = nativeSocketFactory;
        this.initSocket(socket);
    }

    private void initSocket(Socket socket) throws IOException {
        this._socket = socket;
        this._out = this._socket.getOutputStream();
        this._in = this._socket.getInputStream();
    }

    public void close() throws Db4oIOException {
        try {
            this._socket.close();
        }
        catch (IOException iOException) {
            throw new Db4oIOException(iOException);
        }
    }

    public void flush() throws Db4oIOException {
        try {
            this._out.flush();
        }
        catch (IOException iOException) {
            throw new Db4oIOException(iOException);
        }
    }

    public boolean isConnected() {
        return Platform4.isConnected(this._socket);
    }

    public int read() throws Db4oIOException {
        try {
            int n = this._in.read();
            this.checkEOF(n);
            return n;
        }
        catch (IOException iOException) {
            throw new Db4oIOException(iOException);
        }
    }

    public int read(byte[] byArray, int n, int n2) throws Db4oIOException {
        try {
            int n3 = this._in.read(byArray, n, n2);
            this.checkEOF(n3);
            return n3;
        }
        catch (IOException iOException) {
            throw new Db4oIOException(iOException);
        }
    }

    private void checkEOF(int n) {
        if (n == -1) {
            throw new Db4oIOException();
        }
    }

    public void setSoTimeout(int n) {
        try {
            this._socket.setSoTimeout(n);
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
        }
    }

    public void write(byte[] byArray) throws Db4oIOException {
        try {
            this._out.write(byArray);
        }
        catch (IOException iOException) {
            throw new Db4oIOException(iOException);
        }
    }

    public void write(byte[] byArray, int n, int n2) throws Db4oIOException {
        try {
            this._out.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new Db4oIOException(iOException);
        }
    }

    public void write(int n) throws Db4oIOException {
        try {
            this._out.write(n);
        }
        catch (IOException iOException) {
            throw new Db4oIOException(iOException);
        }
    }

    public Socket4 openParalellSocket() throws Db4oIOException {
        if (this._hostName == null) {
            throw new IllegalStateException();
        }
        return new NetworkSocket(this._factory, this._hostName, this._socket.getPort());
    }
}

