/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.internal.Buffer;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.Transaction;

public class PersistentIntegerArray
extends PersistentBase {
    private int[] _ints;

    public PersistentIntegerArray(int n) {
        this.setID(n);
    }

    public PersistentIntegerArray(int[] nArray) {
        this._ints = new int[nArray.length];
        System.arraycopy(nArray, 0, this._ints, 0, nArray.length);
    }

    public byte getIdentifier() {
        return 73;
    }

    public int ownLength() {
        return 4 * (this.size() + 1) + 0;
    }

    public void readThis(Transaction transaction, Buffer buffer) {
        int n = buffer.readInt();
        this._ints = new int[n];
        for (int i = 0; i < n; ++i) {
            this._ints[i] = buffer.readInt();
        }
    }

    public void writeThis(Transaction transaction, Buffer buffer) {
        buffer.writeInt(this.size());
        for (int i = 0; i < this._ints.length; ++i) {
            buffer.writeInt(this._ints[i]);
        }
    }

    private int size() {
        return this._ints.length;
    }

    public int[] array() {
        return this._ints;
    }
}

