/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cs;

import com.db4o.Db4o;
import com.db4o.Db4oIOException;
import com.db4o.ObjectContainer;
import com.db4o.ObjectServer;
import com.db4o.ObjectSet;
import com.db4o.User;
import com.db4o.config.Configuration;
import com.db4o.config.NativeSocketFactory;
import com.db4o.ext.ExtObjectServer;
import com.db4o.foundation.BlockingQueue;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.network.LoopbackSocket;
import com.db4o.foundation.network.LoopbackSocketServer;
import com.db4o.foundation.network.ServerSocket4;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.EmbeddedClientObjectContainer;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.Transaction;
import com.db4o.internal.cs.BroadcastFilter;
import com.db4o.internal.cs.ClientTransactionHandle;
import com.db4o.internal.cs.ClientTransactionPool;
import com.db4o.internal.cs.CommittedCallbacksDispatcher;
import com.db4o.internal.cs.ServerMessageDispatcher;
import com.db4o.internal.cs.ServerMessageDispatcherImpl;
import com.db4o.internal.cs.messages.MCommittedInfo;
import com.db4o.internal.cs.messages.Msg;
import java.io.IOException;

public class ObjectServerImpl
implements ObjectServer,
ExtObjectServer,
Runnable,
LoopbackSocketServer {
    private static final int START_THREAD_WAIT_TIMEOUT = 5000;
    private final String _name;
    private ServerSocket4 _serverSocket;
    private int _port;
    private int i_threadIDGen = 1;
    private final Collection4 _dispatchers = new Collection4();
    LocalObjectContainer _container;
    ClientTransactionPool _transactionPool;
    private final Object _startupLock = new Object();
    private Config4Impl _config;
    private BlockingQueue _committedInfosQueue = new BlockingQueue();
    private CommittedCallbacksDispatcher _committedCallbacksDispatcher;
    private boolean _caresAboutCommitted;
    private final NativeSocketFactory _socketFactory;
    private final boolean _isEmbeddedServer;

    public ObjectServerImpl(LocalObjectContainer localObjectContainer, int n, NativeSocketFactory nativeSocketFactory) {
        this(localObjectContainer, n < 0 ? 0 : n, n == 0, nativeSocketFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectServerImpl(LocalObjectContainer localObjectContainer, int n, boolean bl, NativeSocketFactory nativeSocketFactory) {
        this._isEmbeddedServer = bl;
        this._socketFactory = nativeSocketFactory;
        this._container = localObjectContainer;
        this._transactionPool = new ClientTransactionPool(localObjectContainer);
        this._port = n;
        this._config = this._container.configImpl();
        this._name = "db4o ServerSocket FILE: " + localObjectContainer.toString() + "  PORT:" + this._port;
        this._container.setServer(true);
        this.configureObjectServer();
        boolean bl2 = false;
        try {
            this.ensureLoadStaticClass();
            this.startCommittedCallbackThread(this._committedInfosQueue);
            this.startServer();
            bl2 = true;
        }
        finally {
            if (!bl2) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServer() {
        if (this.isEmbeddedServer()) {
            return;
        }
        Object object = this._startupLock;
        synchronized (object) {
            this.startServerSocket();
            this.startServerThread();
            boolean bl = false;
            while (!bl) {
                try {
                    this._startupLock.wait(5000L);
                    bl = true;
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServerThread() {
        Object object = this._startupLock;
        synchronized (object) {
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            thread.start();
        }
    }

    private void startServerSocket() {
        try {
            this._serverSocket = new ServerSocket4(this._socketFactory, this._port);
            this._port = this._serverSocket.getLocalPort();
        }
        catch (IOException iOException) {
            throw new Db4oIOException(iOException);
        }
        this._serverSocket.setSoTimeout(this._config.timeoutServerSocket());
    }

    private boolean isEmbeddedServer() {
        return this._isEmbeddedServer;
    }

    private void ensureLoadStaticClass() {
        this._container.produceClassMetadata(this._container._handlers.ICLASS_STATICCLASS);
    }

    private void configureObjectServer() {
        this._config.callbacks(false);
        this._config.isServer(true);
        this._config.objectClass(User.class).minimumActivationDepth(1);
    }

    public void backup(String string) throws IOException {
        this._container.backup(string);
    }

    final void checkClosed() {
        if (this._container == null) {
            Exceptions4.throwRuntimeException(20, this._name);
        }
        this._container.checkClosed();
    }

    public synchronized boolean close() {
        this.closeServerSocket();
        this.stopCommittedCallbacksDispatcher();
        this.closeMessageDispatchers();
        return this.closeFile();
    }

    private void stopCommittedCallbacksDispatcher() {
        if (this._committedCallbacksDispatcher != null) {
            this._committedCallbacksDispatcher.stop();
        }
    }

    private boolean closeFile() {
        if (this._container != null) {
            this._transactionPool.close();
            this._container = null;
        }
        return true;
    }

    private void closeMessageDispatchers() {
        Iterator4 iterator4 = this.iterateDispatchers();
        while (iterator4.moveNext()) {
            try {
                ((ServerMessageDispatcher)iterator4.current()).close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        iterator4 = this.iterateDispatchers();
        while (iterator4.moveNext()) {
            try {
                ((Thread)iterator4.current()).join();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator4 iterateDispatchers() {
        Collection4 collection4 = this._dispatchers;
        synchronized (collection4) {
            return new Collection4(this._dispatchers).iterator();
        }
    }

    private void closeServerSocket() {
        try {
            if (this._serverSocket != null) {
                this._serverSocket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._serverSocket = null;
    }

    public Configuration configure() {
        return this._config;
    }

    public ExtObjectServer ext() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerMessageDispatcherImpl findThread(int n) {
        Collection4 collection4 = this._dispatchers;
        synchronized (collection4) {
            Iterator4 iterator4 = this._dispatchers.iterator();
            while (iterator4.moveNext()) {
                ServerMessageDispatcherImpl serverMessageDispatcherImpl = (ServerMessageDispatcherImpl)iterator4.current();
                if (serverMessageDispatcherImpl._threadID != n) continue;
                return serverMessageDispatcherImpl;
            }
        }
        return null;
    }

    Transaction findTransaction(int n) {
        ServerMessageDispatcherImpl serverMessageDispatcherImpl = this.findThread(n);
        return serverMessageDispatcherImpl == null ? null : serverMessageDispatcherImpl.getTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void grantAccess(String string, String string2) {
        this.checkClosed();
        Object object = this._container._lock;
        synchronized (object) {
            User user = this.getUser(string);
            if (user != null) {
                this.setPassword(user, string2);
            } else {
                this.addUser(string, string2);
            }
            this._container.commit();
        }
    }

    private void addUser(String string, String string2) {
        this._container.set(new User(string, string2));
    }

    private void setPassword(User user, String string) {
        user.password = string;
        this._container.set(user);
    }

    public User getUser(String string) {
        ObjectSet objectSet = this.queryUsers(string);
        if (!objectSet.hasNext()) {
            return null;
        }
        return (User)objectSet.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectSet queryUsers(String string) {
        this._container.showInternalClasses(true);
        try {
            ObjectSet objectSet = this._container.get(new User(string, null));
            return objectSet;
        }
        finally {
            this._container.showInternalClasses(false);
        }
    }

    public ObjectContainer objectContainer() {
        return this._container;
    }

    public ObjectContainer openClient() {
        return this.openClient(Db4o.cloneConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ObjectContainer openClient(Configuration configuration) {
        this.checkClosed();
        Object object = this._container._lock;
        synchronized (object) {
            return new EmbeddedClientObjectContainer(this._container);
        }
    }

    public LoopbackSocket openClientSocket() {
        int n = this._config.timeoutClientSocket();
        LoopbackSocket loopbackSocket = new LoopbackSocket(this, n);
        LoopbackSocket loopbackSocket2 = new LoopbackSocket(this, n, loopbackSocket);
        try {
            ServerMessageDispatcherImpl serverMessageDispatcherImpl = new ServerMessageDispatcherImpl(this, new ClientTransactionHandle(this._transactionPool), loopbackSocket2, this.newThreadId(), true, this._container.lock());
            this.addServerMessageDispatcher(serverMessageDispatcherImpl);
            serverMessageDispatcherImpl.startDispatcher();
            return loopbackSocket;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeThread(ServerMessageDispatcherImpl serverMessageDispatcherImpl) {
        Collection4 collection4 = this._dispatchers;
        synchronized (collection4) {
            this._dispatchers.remove(serverMessageDispatcherImpl);
            this.checkCaresAboutCommitted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void revokeAccess(String string) {
        this.checkClosed();
        Object object = this._container._lock;
        synchronized (object) {
            this.deleteUsers(string);
            this._container.commit();
        }
    }

    private void deleteUsers(String string) {
        ObjectSet objectSet = this.queryUsers(string);
        while (objectSet.hasNext()) {
            this._container.delete(objectSet.next());
        }
    }

    public void run() {
        this.setThreadName();
        this.logListeningOnPort();
        this.notifyThreadStarted();
        this.listen();
    }

    private void startCommittedCallbackThread(BlockingQueue blockingQueue) {
        if (this.isEmbeddedServer()) {
            return;
        }
        this._committedCallbacksDispatcher = new CommittedCallbacksDispatcher(this, blockingQueue);
        Thread thread = new Thread(this._committedCallbacksDispatcher);
        thread.setName("committed callback thread");
        thread.setDaemon(true);
        thread.start();
    }

    private void setThreadName() {
        Thread.currentThread().setName(this._name);
    }

    private void listen() {
        while (this._serverSocket != null) {
            try {
                ServerMessageDispatcherImpl serverMessageDispatcherImpl = new ServerMessageDispatcherImpl(this, new ClientTransactionHandle(this._transactionPool), this._serverSocket.accept(), this.newThreadId(), false, this._container.lock());
                this.addServerMessageDispatcher(serverMessageDispatcherImpl);
                serverMessageDispatcherImpl.startDispatcher();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyThreadStarted() {
        Object object = this._startupLock;
        synchronized (object) {
            this._startupLock.notifyAll();
        }
    }

    private void logListeningOnPort() {
        this._container.logMsg(31, "" + this._serverSocket.getLocalPort());
    }

    private int newThreadId() {
        return this.i_threadIDGen++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServerMessageDispatcher(ServerMessageDispatcher serverMessageDispatcher) {
        Collection4 collection4 = this._dispatchers;
        synchronized (collection4) {
            this._dispatchers.add(serverMessageDispatcher);
            this.checkCaresAboutCommitted();
        }
    }

    public void addCommittedInfoMsg(MCommittedInfo mCommittedInfo) {
        this._committedInfosQueue.add(mCommittedInfo);
    }

    public void broadcastMsg(Msg msg, BroadcastFilter broadcastFilter) {
        Iterator4 iterator4 = this.iterateDispatchers();
        while (iterator4.moveNext()) {
            ServerMessageDispatcher serverMessageDispatcher = (ServerMessageDispatcher)iterator4.current();
            if (!broadcastFilter.accept(serverMessageDispatcher)) continue;
            serverMessageDispatcher.write(msg);
        }
    }

    public boolean caresAboutCommitted() {
        return this._caresAboutCommitted;
    }

    public void checkCaresAboutCommitted() {
        this._caresAboutCommitted = this.anyDispatcherCaresAboutCommitted();
    }

    private boolean anyDispatcherCaresAboutCommitted() {
        Iterator4 iterator4 = this.iterateDispatchers();
        while (iterator4.moveNext()) {
            ServerMessageDispatcher serverMessageDispatcher = (ServerMessageDispatcher)iterator4.current();
            if (!serverMessageDispatcher.caresAboutCommitted()) continue;
            return true;
        }
        return false;
    }

    public int port() {
        return this._port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int clientCount() {
        Collection4 collection4 = this._dispatchers;
        synchronized (collection4) {
            return this._dispatchers.size();
        }
    }
}

