/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.nativequery.optimization;

import EDU.purdue.cs.bloat.editor.Instruction;
import EDU.purdue.cs.bloat.editor.LocalVariable;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.NameAndType;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.file.ClassSource;
import com.db4o.nativequery.expr.cmp.operand.ArithmeticExpression;
import com.db4o.nativequery.expr.cmp.operand.ArrayAccessValue;
import com.db4o.nativequery.expr.cmp.operand.CandidateFieldRoot;
import com.db4o.nativequery.expr.cmp.operand.ComparisonOperand;
import com.db4o.nativequery.expr.cmp.operand.ComparisonOperandVisitor;
import com.db4o.nativequery.expr.cmp.operand.ConstValue;
import com.db4o.nativequery.expr.cmp.operand.FieldValue;
import com.db4o.nativequery.expr.cmp.operand.MethodCallValue;
import com.db4o.nativequery.expr.cmp.operand.PredicateFieldRoot;
import com.db4o.nativequery.expr.cmp.operand.StaticFieldRoot;
import com.db4o.nativequery.optimization.ReflectUtil;
import com.db4o.nativequery.optimization.TypeDeducingVisitor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

class ComparisonBytecodeGeneratingVisitor
implements ComparisonOperandVisitor {
    private MethodEditor methodEditor;
    private Class predicateClass;
    private Class candidateClass;
    private Map conversions;
    private boolean inArithmetic = false;
    private Class opClass = null;
    private Class staticRoot = null;
    private ClassSource classSource;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Boolean;

    public ComparisonBytecodeGeneratingVisitor(MethodEditor methodEditor, Class clazz, Class clazz2, ClassSource classSource) {
        this.methodEditor = methodEditor;
        this.predicateClass = clazz;
        this.candidateClass = clazz2;
        this.classSource = classSource;
        this.buildConversions();
    }

    public void visit(ConstValue constValue) {
        Object object = constValue.value();
        if (object != null) {
            this.opClass = object.getClass();
            this.prepareConversion(object.getClass(), !this.inArithmetic);
        }
        this.methodEditor.addInstruction(18, this.coerce(object));
        if (object != null) {
            this.applyConversion(object.getClass(), !this.inArithmetic);
        }
    }

    private Object coerce(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object != false ? new Integer(1) : new Integer(0);
        }
        if (object instanceof Character) {
            return new Integer(((Character)object).charValue());
        }
        if (object instanceof Byte || object instanceof Short) {
            return new Integer(((Number)object).intValue());
        }
        return object;
    }

    public void visit(FieldValue fieldValue) {
        try {
            Class clazz = this.deduceFieldClass(fieldValue);
            Class clazz2 = this.deduceFieldClass(fieldValue.parent());
            boolean bl = clazz.isPrimitive();
            this.prepareConversion(clazz, !this.inArithmetic && bl);
            fieldValue.parent().accept(this);
            if (this.staticRoot != null) {
                this.methodEditor.addInstruction(178, this.createFieldReference(this.staticRoot, clazz, fieldValue.fieldName()));
                this.staticRoot = null;
                return;
            }
            MemberRef memberRef = this.createFieldReference(clazz2, clazz, fieldValue.fieldName());
            this.methodEditor.addInstruction(180, memberRef);
            this.applyConversion(clazz, !this.inArithmetic && bl);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public void visit(CandidateFieldRoot candidateFieldRoot) {
        this.methodEditor.addInstruction(25, new LocalVariable(1));
    }

    public void visit(PredicateFieldRoot predicateFieldRoot) {
        this.methodEditor.addInstruction(25, new LocalVariable(0));
    }

    public void visit(StaticFieldRoot staticFieldRoot) {
        try {
            this.staticRoot = this.classSource.loadClass(staticFieldRoot.className());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    public void visit(ArrayAccessValue arrayAccessValue) {
        Class<?> clazz = this.deduceFieldClass(arrayAccessValue.parent()).getComponentType();
        this.prepareConversion(clazz, !this.inArithmetic);
        arrayAccessValue.parent().accept(this);
        boolean bl = this.inArithmetic;
        this.inArithmetic = true;
        arrayAccessValue.index().accept(this);
        this.inArithmetic = bl;
        int n = 50;
        if (clazz == Integer.TYPE) {
            n = 46;
        }
        if (clazz == Long.TYPE) {
            n = 47;
        }
        if (clazz == Float.TYPE) {
            n = 48;
        }
        if (clazz == Double.TYPE) {
            n = 49;
        }
        this.methodEditor.addInstruction(n);
        this.applyConversion(clazz, !this.inArithmetic);
    }

    public void visit(MethodCallValue methodCallValue) {
        int n;
        Class clazz = this.deduceFieldClass(methodCallValue.parent());
        Method method = ReflectUtil.methodFor(clazz, methodCallValue.methodName(), methodCallValue.paramTypes());
        Class<?> clazz2 = method.getReturnType();
        boolean bl = clazz2.isPrimitive();
        this.prepareConversion(clazz2, !this.inArithmetic && bl);
        methodCallValue.parent().accept(this);
        boolean bl2 = this.inArithmetic;
        for (n = 0; n < methodCallValue.args().length; ++n) {
            this.inArithmetic = methodCallValue.paramTypes()[n].isPrimitive();
            methodCallValue.args()[n].accept(this);
        }
        this.inArithmetic = bl2;
        n = (method.getModifiers() & 8) != 0 ? 184 : 182;
        this.methodEditor.addInstruction(n, this.createMethodReference(method.getDeclaringClass(), method.getName(), method.getParameterTypes(), method.getReturnType()));
        this.applyConversion(clazz2, !this.inArithmetic && bl);
    }

    public void visit(ArithmeticExpression arithmeticExpression) {
        boolean bl = this.inArithmetic;
        this.inArithmetic = true;
        Instruction instruction = this.prepareConversion(this.opClass, !bl, true);
        arithmeticExpression.left().accept(this);
        arithmeticExpression.right().accept(this);
        Class clazz = this.arithmeticType(arithmeticExpression);
        int n = Integer.MIN_VALUE;
        switch (arithmeticExpression.op().id()) {
            case 0: {
                if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Double")) : class$java$lang$Double)) {
                    n = 99;
                    break;
                }
                if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Float")) : class$java$lang$Float)) {
                    n = 98;
                    break;
                }
                if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Long")) : class$java$lang$Long)) {
                    n = 97;
                    break;
                }
                n = 96;
                break;
            }
            case 1: {
                if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Double")) : class$java$lang$Double)) {
                    n = 103;
                    break;
                }
                if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Float")) : class$java$lang$Float)) {
                    n = 102;
                    break;
                }
                if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Long")) : class$java$lang$Long)) {
                    n = 101;
                    break;
                }
                n = 100;
                break;
            }
            case 2: {
                if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Double")) : class$java$lang$Double)) {
                    n = 107;
                    break;
                }
                if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Float")) : class$java$lang$Float)) {
                    n = 106;
                    break;
                }
                if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Long")) : class$java$lang$Long)) {
                    n = 105;
                    break;
                }
                n = 104;
                break;
            }
            case 3: {
                if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Double")) : class$java$lang$Double)) {
                    n = 111;
                    break;
                }
                if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Float")) : class$java$lang$Float)) {
                    n = 110;
                    break;
                }
                if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Long")) : class$java$lang$Long)) {
                    n = 109;
                    break;
                }
                n = 108;
                break;
            }
            default: {
                throw new RuntimeException("Unknown operand: " + arithmeticExpression.op());
            }
        }
        this.methodEditor.addInstruction(n);
        if (instruction != null) {
            instruction.setOperand(this.createType(this.opClass));
        }
        this.applyConversion(this.opClass, !bl);
        this.inArithmetic = bl;
    }

    private Class deduceFieldClass(ComparisonOperand comparisonOperand) {
        TypeDeducingVisitor typeDeducingVisitor = new TypeDeducingVisitor(this.predicateClass, this.candidateClass, this.classSource);
        comparisonOperand.accept(typeDeducingVisitor);
        return typeDeducingVisitor.operandClass();
    }

    private MemberRef createFieldReference(Class clazz, Class clazz2, String string) throws NoSuchFieldException {
        NameAndType nameAndType = new NameAndType(string, this.createType(clazz2));
        return new MemberRef(this.createType(clazz), nameAndType);
    }

    private Class arithmeticType(ComparisonOperand comparisonOperand) {
        if (comparisonOperand instanceof ConstValue) {
            return ((ConstValue)comparisonOperand).value().getClass();
        }
        if (comparisonOperand instanceof FieldValue) {
            try {
                return this.deduceFieldClass(comparisonOperand);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        if (comparisonOperand instanceof ArithmeticExpression) {
            ArithmeticExpression arithmeticExpression = (ArithmeticExpression)comparisonOperand;
            Class clazz = this.arithmeticType(arithmeticExpression.left());
            Class clazz2 = this.arithmeticType(arithmeticExpression.right());
            if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Double")) : class$java$lang$Double) || clazz2 == (class$java$lang$Double == null ? (class$java$lang$Double = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Double")) : class$java$lang$Double)) {
                return class$java$lang$Double == null ? (class$java$lang$Double = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Double")) : class$java$lang$Double;
            }
            if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Float")) : class$java$lang$Float) || clazz2 == (class$java$lang$Float == null ? (class$java$lang$Float = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Float")) : class$java$lang$Float)) {
                return class$java$lang$Float == null ? (class$java$lang$Float = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Float")) : class$java$lang$Float;
            }
            if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Long")) : class$java$lang$Long) || clazz2 == (class$java$lang$Long == null ? (class$java$lang$Long = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Long")) : class$java$lang$Long)) {
                return class$java$lang$Long == null ? (class$java$lang$Long = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Long")) : class$java$lang$Long;
            }
            return class$java$lang$Integer == null ? (class$java$lang$Integer = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        return null;
    }

    private Instruction prepareConversion(Class clazz, boolean bl) {
        return this.prepareConversion(clazz, bl, false);
    }

    private Instruction prepareConversion(Class clazz, boolean bl, boolean bl2) {
        if ((bl2 || this.conversions.containsKey(clazz)) && bl) {
            Class[] classArray = (Class[])this.conversions.get(clazz);
            Instruction instruction = new Instruction(187, classArray == null ? null : this.createType(classArray[0]));
            this.methodEditor.addInstruction(instruction);
            this.methodEditor.addInstruction(89);
            return instruction;
        }
        return null;
    }

    private void applyConversion(Class clazz, boolean bl) {
        if (this.conversions.containsKey(clazz) && bl) {
            Class[] classArray = (Class[])this.conversions.get(clazz);
            this.methodEditor.addInstruction(183, this.createMethodReference(classArray[0], "<init>", new Class[]{classArray[1]}, Void.TYPE));
        }
    }

    private MemberRef createMethodReference(Class clazz, String string, Class[] classArray, Class clazz2) {
        Type[] typeArray = new Type[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            typeArray[i] = this.createType(classArray[i]);
        }
        NameAndType nameAndType = new NameAndType(string, Type.getType(typeArray, this.createType(clazz2)));
        return new MemberRef(this.createType(clazz), nameAndType);
    }

    private Type createType(Class clazz) {
        return Type.getType(clazz);
    }

    private void buildConversions() {
        this.conversions = new HashMap();
        this.conversions.put(class$java$lang$Integer == null ? (class$java$lang$Integer = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Integer")) : class$java$lang$Integer, new Class[]{class$java$lang$Integer == null ? (class$java$lang$Integer = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Integer")) : class$java$lang$Integer, Integer.TYPE});
        this.conversions.put(class$java$lang$Long == null ? (class$java$lang$Long = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Long")) : class$java$lang$Long, new Class[]{class$java$lang$Long == null ? (class$java$lang$Long = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Long")) : class$java$lang$Long, Long.TYPE});
        this.conversions.put(class$java$lang$Short == null ? (class$java$lang$Short = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Short")) : class$java$lang$Short, new Class[]{class$java$lang$Short == null ? (class$java$lang$Short = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Short")) : class$java$lang$Short, Short.TYPE});
        this.conversions.put(class$java$lang$Byte == null ? (class$java$lang$Byte = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Byte")) : class$java$lang$Byte, new Class[]{class$java$lang$Byte == null ? (class$java$lang$Byte = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Byte")) : class$java$lang$Byte, Byte.TYPE});
        this.conversions.put(class$java$lang$Double == null ? (class$java$lang$Double = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Double")) : class$java$lang$Double, new Class[]{class$java$lang$Double == null ? (class$java$lang$Double = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Double")) : class$java$lang$Double, Double.TYPE});
        this.conversions.put(class$java$lang$Float == null ? (class$java$lang$Float = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Float")) : class$java$lang$Float, new Class[]{class$java$lang$Float == null ? (class$java$lang$Float = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Float")) : class$java$lang$Float, Float.TYPE});
        this.conversions.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Boolean")) : class$java$lang$Boolean, new Class[]{class$java$lang$Boolean == null ? (class$java$lang$Boolean = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Boolean")) : class$java$lang$Boolean, Boolean.TYPE});
        this.conversions.put(Integer.TYPE, this.conversions.get(class$java$lang$Integer == null ? (class$java$lang$Integer = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Integer")) : class$java$lang$Integer));
        this.conversions.put(Long.TYPE, this.conversions.get(class$java$lang$Long == null ? (class$java$lang$Long = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Long")) : class$java$lang$Long));
        this.conversions.put(Short.TYPE, this.conversions.get(class$java$lang$Short == null ? (class$java$lang$Short = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Short")) : class$java$lang$Short));
        this.conversions.put(Byte.TYPE, this.conversions.get(class$java$lang$Byte == null ? (class$java$lang$Byte = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Byte")) : class$java$lang$Byte));
        this.conversions.put(Double.TYPE, this.conversions.get(class$java$lang$Double == null ? (class$java$lang$Double = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Double")) : class$java$lang$Double));
        this.conversions.put(Float.TYPE, this.conversions.get(class$java$lang$Float == null ? (class$java$lang$Float = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Float")) : class$java$lang$Float));
        this.conversions.put(Boolean.TYPE, this.conversions.get(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ComparisonBytecodeGeneratingVisitor.class$("java.lang.Boolean")) : class$java$lang$Boolean));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

