/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.cfg;

import EDU.purdue.cs.bloat.cfg.Block;
import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.util.GraphNode;
import java.util.Iterator;
import java.util.LinkedList;

public class DominanceFrontier {
    public static void buildFrontier(FlowGraph graph, boolean reverse) {
        if (!reverse) {
            DominanceFrontier.calcFrontier(graph.source(), graph, reverse);
        } else {
            DominanceFrontier.calcFrontier(graph.sink(), graph, reverse);
        }
    }

    private static LinkedList calcFrontier(Block block, FlowGraph graph, boolean reverse) {
        Block[] local = new Block[graph.size()];
        Iterator children = !reverse ? block.domChildren().iterator() : block.pdomChildren().iterator();
        while (children.hasNext()) {
            Block child = (Block)children.next();
            LinkedList df = DominanceFrontier.calcFrontier(child, graph, reverse);
            Iterator e = df.iterator();
            while (e.hasNext()) {
                Block dfChild = (Block)e.next();
                if (!reverse) {
                    if (block == dfChild.domParent()) continue;
                    local[graph.preOrderIndex((GraphNode)dfChild)] = dfChild;
                    continue;
                }
                if (block == dfChild.pdomParent()) continue;
                local[graph.preOrderIndex((GraphNode)dfChild)] = dfChild;
            }
        }
        Iterator succs = reverse ? graph.preds(block).iterator() : graph.succs(block).iterator();
        while (succs.hasNext()) {
            Block succ = (Block)succs.next();
            if (!reverse) {
                if (block == succ.domParent()) continue;
                local[graph.preOrderIndex((GraphNode)succ)] = succ;
                continue;
            }
            if (block == succ.pdomParent()) continue;
            local[graph.preOrderIndex((GraphNode)succ)] = succ;
        }
        LinkedList<Block> v = new LinkedList<Block>();
        int i = 0;
        while (i < local.length) {
            if (local[i] != null) {
                v.add(local[i]);
            }
            ++i;
        }
        if (!reverse) {
            block.domFrontier().clear();
            block.domFrontier().addAll(v);
        } else {
            block.pdomFrontier().clear();
            block.pdomFrontier().addAll(v);
        }
        return v;
    }
}

