/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.trans;

import EDU.purdue.cs.bloat.cfg.Block;
import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.editor.EditorContext;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.trans.SideEffectChecker;
import EDU.purdue.cs.bloat.tree.InitStmt;
import EDU.purdue.cs.bloat.tree.NewArrayExpr;
import EDU.purdue.cs.bloat.tree.NewExpr;
import EDU.purdue.cs.bloat.tree.NewMultiArrayExpr;
import EDU.purdue.cs.bloat.tree.RCExpr;
import EDU.purdue.cs.bloat.tree.TreeVisitor;
import EDU.purdue.cs.bloat.tree.UCExpr;
import EDU.purdue.cs.bloat.util.Assert;
import java.util.BitSet;
import java.util.Iterator;

public class PersistentCheckElimination {
    public static boolean DEBUG = false;
    private static final int RC = 0;
    private static final int AUPDATE = 1;
    private static final int SUPDATE = 2;
    private static final int SIZE = 3;
    private EditorContext context;

    public void transform(FlowGraph cfg) {
        this.context = cfg.method().declaringClass().context();
        BitSet[] seen = new BitSet[3];
        int i = 0;
        while (i < 3) {
            seen[i] = new BitSet();
            ++i;
        }
        this.search(cfg, cfg.source(), seen);
    }

    private void search(FlowGraph cfg, Block block, final BitSet[] seen) {
        BitSet[] save = new BitSet[3];
        int i = 0;
        while (i < 3) {
            save[i] = new BitSet(seen[i].size());
            save[i].or(seen[i]);
            ++i;
        }
        block.visit(new TreeVisitor(){

            public void visitNewArrayExpr(NewArrayExpr expr) {
                expr.visitChildren(this);
                int v = expr.valueNumber();
                Assert.isTrue(v != -1);
                seen[0].set(v);
            }

            public void visitNewMultiArrayExpr(NewMultiArrayExpr expr) {
                expr.visitChildren(this);
                int v = expr.valueNumber();
                Assert.isTrue(v != -1);
                seen[0].set(v);
            }

            public void visitNewExpr(NewExpr expr) {
                expr.visitChildren(this);
                int v = expr.valueNumber();
                Assert.isTrue(v != -1);
                seen[0].set(v);
            }

            public void visitInitStmt(InitStmt stmt) {
                stmt.visitChildren(this);
                MethodEditor method = stmt.block().graph().method();
                if (!method.isStatic()) {
                    Assert.isTrue(stmt.targets().length > 0);
                    int v = stmt.targets()[0].valueNumber();
                    Assert.isTrue(v != -1);
                    seen[0].set(v);
                }
            }

            public void visitRCExpr(RCExpr expr) {
                expr.visitChildren(this);
                int v = expr.expr().valueNumber();
                Assert.isTrue(v != -1);
                SideEffectChecker sideEffects = new SideEffectChecker(PersistentCheckElimination.this.context);
                expr.expr().visit(sideEffects);
                int flag = sideEffects.sideEffects();
                if (seen[0].get(v) && (flag & 0x100) == 0) {
                    expr.expr().setParent(null);
                    expr.replaceWith(expr.expr(), false);
                    expr.cleanupOnly();
                }
                seen[0].set(v);
            }

            public void visitUCExpr(UCExpr expr) {
                expr.visitChildren(this);
                int v = expr.expr().valueNumber();
                Assert.isTrue(v != -1);
                SideEffectChecker sideEffects = new SideEffectChecker(PersistentCheckElimination.this.context);
                expr.expr().visit(sideEffects);
                int flag = sideEffects.sideEffects();
                if (expr.kind() == 1) {
                    if (seen[1].get(v) && (flag & 0x100) == 0) {
                        expr.expr().setParent(null);
                        expr.replaceWith(expr.expr(), false);
                        expr.cleanupOnly();
                    }
                    seen[1].set(v);
                } else {
                    if (seen[2].get(v) && (flag & 0x100) == 0) {
                        expr.expr().setParent(null);
                        expr.replaceWith(expr.expr(), false);
                        expr.cleanupOnly();
                    }
                    seen[2].set(v);
                }
            }
        });
        Iterator children = cfg.domChildren(block).iterator();
        while (children.hasNext()) {
            Block child = (Block)children.next();
            this.search(cfg, child, seen);
        }
        int i2 = 0;
        while (i2 < 3) {
            seen[i2] = save[i2];
            ++i2;
        }
    }
}

