/*
 * Decompiled with CFR 0.152.
 */
package BlowfishJ;

import BlowfishJ.BinConverter;
import BlowfishJ.BlowfishCBC;
import BlowfishJ.BlowfishECB;
import java.io.IOException;

public class BlowfishTest {
    static final int MAX_MESS_SIZE = 64;
    static final int TESTBUFSIZE = 100000;
    static final int TESTLOOPS = 10000;
    static final long CBCIV_START = 72623859790382856L;
    static final long[] TEST_DATA = new long[]{0L, 0L, 5690745928405278072L, -1L, -1L, 5874505727663328138L, 0x3000000000000000L, 0x1000000000000001L, 9044758135489717234L, 0x1111111111111111L, 0x1111111111111111L, 2623027407222095005L, 81985529216486895L, 0x1111111111111111L, 7059888845982118038L, 0x1111111111111111L, 81985529216486895L, 9010794866872557255L, 0L, 0L, 5690745928405278072L, -81985529216486896L, 81985529216486895L, 778747869826949773L, 8980477021735513687L, 117611255094011714L, 6469001151571634219L, 86088881178490734L, 6689337107006052314L, -5640534185043097184L, 549741787767056006L, 164614723499094386L, 1671087763365698980L, 4055886516176695710L, 5856169732564009994L, -6746822877516508693L, 340327136592049590L, 4827089350059065250L, 3834958779591331610L, 77609513531011790L, 404019981405066298L, 5257055948861053208L, 103848277426812390L, 528848464848052690L, 4837309891264773272L, 4839539656546808830L, 8513233451820730474L, 1436720113764866789L, 551430852305365526L, 4313623329492117506L, 3381599224412216441L, 317663223366892335L, 2780233246153072794L, -2844058103233796381L, 4021832892757538118L, 1607044272340030002L, 6888766144289061225L, 2236079052714821214L, 7711690988273491146L, 5333803728129726331L, 6359121586699264374L, 21346945391353954L, 4981035896711862926L, 168909270948622343L, 5191868619451491058L, 8454855439414953917L, 5294331816167286159L, 4860862602324950266L, 6036336002209923097L, 5742192969548264359L, 517143888688272018L, 8831132235466705315L, 5325890758360836543L, 215703803915661610L, -3486809231690650187L, 108949354149783254L, 2133963297529473218L, -3338378365516396680L, 2042522189576687599L, 3482745036057028954L, 6182095888362435073L, 0x101010101010101L, 81985529216486895L, -417449070253938510L, 2242545357694045710L, 81985529216486895L, -6372460083780371282L, -2234100979542855170L, 81985529216486895L, -4351032297459522787L, 0L, -1L, 92662307954357988L, -1L, 0L, -1000192228265801284L, 81985529216486895L, 0L, 2619202209687287450L, -81985529216486896L, -1L, 7736157887547705946L};

    public static void main(String[] args) {
        byte[] msgbuf;
        System.out.print("running self test...");
        if (!BlowfishECB.selfTest()) {
            System.out.println(", FAILED");
            return;
        }
        System.out.println(", passed.");
        byte[] testkey = new byte[5];
        for (int nI = 0; nI < testkey.length; ++nI) {
            testkey[nI] = (byte)(nI + 1);
        }
        System.out.print("setting up Blowfish keys...");
        BlowfishECB bfecb = new BlowfishECB(testkey, 0, testkey.length);
        BlowfishCBC bfcbc = new BlowfishCBC(testkey, 0, testkey.length, 72623859790382856L);
        System.out.println(", done.");
        if (bfecb.weakKeyCheck()) {
            System.out.println("ECB key is weak!");
        } else {
            System.out.println("ECB key OK");
        }
        if (bfcbc.weakKeyCheck()) {
            System.out.println("CBC key is weak!");
        } else {
            System.out.println("CBC key OK");
        }
        System.out.print("something to encrypt please >");
        System.out.flush();
        byte[] tempbuf = new byte[64];
        int nMsgSize = 0;
        int nLnBrkLen = 0;
        try {
            nLnBrkLen = System.getProperty("line.separator").length();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            nMsgSize = System.in.read(tempbuf) - nLnBrkLen;
            byte[] cpyBuf = new byte[nMsgSize];
            System.arraycopy(tempbuf, 0, cpyBuf, 0, nMsgSize);
            tempbuf = cpyBuf;
        }
        catch (IOException ioe) {
            return;
        }
        int nRest = nMsgSize & 7;
        if (nRest != 0) {
            msgbuf = new byte[(nMsgSize & 0xFFFFFFF8) + 8];
            System.arraycopy(tempbuf, 0, msgbuf, 0, nMsgSize);
            for (int nI = nMsgSize; nI < msgbuf.length; ++nI) {
                msgbuf[nI] = 0;
            }
            System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf("message with ").concat(String.valueOf(nMsgSize))).concat(String.valueOf(" bytes aligned to "))).concat(String.valueOf(msgbuf.length))).concat(String.valueOf(" bytes")));
        } else {
            msgbuf = new byte[nMsgSize];
            System.arraycopy(tempbuf, 0, msgbuf, 0, nMsgSize);
        }
        System.out.println(String.valueOf("aligned data : ").concat(String.valueOf(BinConverter.bytesToBinHex(msgbuf))));
        bfecb.encrypt(msgbuf, 0, msgbuf, 0, msgbuf.length);
        System.out.println(String.valueOf("ECB encrypted: ").concat(String.valueOf(BinConverter.bytesToBinHex(msgbuf))));
        bfecb.decrypt(msgbuf, 0, msgbuf, 0, msgbuf.length);
        System.out.println(String.valueOf(String.valueOf("ECB decrypted: >>>").concat(String.valueOf(new String(msgbuf)))).concat(String.valueOf("<<<")));
        byte[] showIV = new byte[8];
        bfcbc.getCBCIV(showIV, 0);
        System.out.println(String.valueOf("CBC IV: ").concat(String.valueOf(BinConverter.bytesToBinHex(showIV))));
        bfcbc.encrypt(msgbuf, 0, msgbuf, 0, msgbuf.length);
        System.out.println(String.valueOf("CBC encrypted: ").concat(String.valueOf(BinConverter.bytesToBinHex(msgbuf))));
        bfcbc.setCBCIV(72623859790382856L);
        bfcbc.decrypt(msgbuf, 0, msgbuf, 0, msgbuf.length);
        System.out.println(String.valueOf(String.valueOf("CBC decrypted: >>>").concat(String.valueOf(new String(msgbuf)))).concat(String.valueOf("<<<")));
        int nI = 0;
        while (nI < TEST_DATA.length) {
            int nJ;
            byte[] key = new byte[8];
            long lKey = TEST_DATA[nI++];
            byte[] plain = new byte[8];
            long lPlain = TEST_DATA[nI++];
            byte[] cipher = new byte[8];
            long lCipher = TEST_DATA[nI++];
            for (nJ = 7; nJ >= 0; --nJ) {
                key[nJ] = (byte)(lKey & (long)255);
                lKey >>>= 8;
                plain[nJ] = (byte)(lPlain & (long)255);
                lPlain >>>= 8;
                cipher[nJ] = (byte)(lCipher & (long)255);
                lCipher >>>= 8;
            }
            byte[] testBuf = new byte[8];
            bfecb = new BlowfishECB(key, 0, key.length);
            bfecb.encrypt(plain, 0, testBuf, 0, plain.length);
            for (nJ = 0; nJ < 8; ++nJ) {
                if (testBuf[nJ] == cipher[nJ]) continue;
                System.out.println(String.valueOf("error on vector ").concat(String.valueOf(nI / 3)));
            }
        }
        System.out.println("tests done.");
        System.out.println("\nbenchmark is running, encrypting 1000000000 bytes\nplease wait...");
        long lTm = System.currentTimeMillis();
        byte[] testbuf = new byte[100000];
        for (nI = 0; nI < 10000; ++nI) {
            bfecb.encrypt(testbuf, 0, testbuf, 0, testbuf.length);
            if (nI % 15 != 0) continue;
            System.out.print("#");
            System.out.flush();
        }
        lTm = System.currentTimeMillis() - lTm;
        System.out.println();
        double dAmount = 1.0E9;
        double dTime = lTm;
        double fRate = dAmount * (double)1000 / dTime;
        long lRate = (long)fRate;
        System.out.println(String.valueOf(String.valueOf("rate: ").concat(String.valueOf(lRate))).concat(String.valueOf(" bytes/sec")));
        bfecb.cleanUp();
        bfcbc.cleanUp();
    }
}

