/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.allday.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LicensePane
extends JPanel {
    private String lineSeparator = System.getProperty("line.separator");
    private static final String ERR_TITLE = "Error";

    public LicensePane(Dimension d, String licensePath) {
        JTextArea licText = new JTextArea(this.getLicenseText(this.getClass().getResourceAsStream(licensePath)));
        licText.setEditable(false);
        licText.setFont(new Font("Courier", 0, 12));
        JScrollPane licPane = new JScrollPane();
        licPane = new JScrollPane(licText);
        licPane.setPreferredSize(d);
        licPane.setVerticalScrollBarPolicy(20);
        licPane.setHorizontalScrollBarPolicy(30);
        this.setLayout(new BorderLayout());
        this.add((Component)licPane, "Center");
        licText.setCaretPosition(0);
    }

    private String getLicenseText(InputStream is) {
        StringBuffer license = new StringBuffer();
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(is));
            String buf = r.readLine();
            while (buf != null) {
                license.append(buf);
                license.append(this.lineSeparator);
                buf = r.readLine();
            }
            r.close();
            is.close();
        }
        catch (Exception e) {
            this.errMsg(this, "The license text could not be opened.\n\nPlease consult file 'readme.txt' for installation guidelines\n\nSimplyHTML and all of its parts are distributed under\nthe terms and conditions of the GNU General Public License (GPL).\nYou may want to obtain a free and complete distribution package at\nhttp://www.lightdev.com", e);
        }
        return license.toString();
    }

    private void errMsg(Component owner, String msg, Exception e) {
        if (msg != null) {
            JOptionPane.showMessageDialog(owner, msg, ERR_TITLE, 0);
        }
        if (e != null) {
            e.printStackTrace();
        }
    }
}

