/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.allday.ui;

import com.lightdev.app.allday.ui.ColorPanel;
import com.lightdev.app.allday.ui.DialogShell;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormatSymbols;
import java.util.prefs.Preferences;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;

public class PrefsDialog
extends DialogShell
implements ActionListener {
    public static final String PREFSID_SUNDAY_DAY_OF_WEEK = "sdaw";
    public static final String PREFSID_SUNDAY_COLOR = "scol";
    public static final String PREFSID_FIRST_DAY_OF_WEEK = "fdow";
    public static final String PREFSID_HEADER_COLOR = "hcol";
    protected Preferences prefs = Preferences.userNodeForPackage(this.getClass());
    private DateFormatSymbols dateFormatSymbols = new DateFormatSymbols();
    private JComboBox sundayDayOfWeek;
    private ColorPanel sundayColor;
    private JComboBox firstDayOfWeek;
    private ColorPanel headerColor;

    public PrefsDialog(Frame parent, String title) {
        super(parent, title);
        this.initDialog();
    }

    private void initDialog() {
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel sundayPanel = new JPanel(g);
        sundayPanel.setBorder(new TitledBorder(this.mf.getResourceString("sundayPanelTitle", "sunday / Sabbath")));
        this.addGridBagComponent(sundayPanel, new JLabel(this.mf.getResourceString("sundayDayOfWeekLabel", "Day of week:")), g, c, 0, 0, 13);
        String[] wkDays = this.dateFormatSymbols.getWeekdays();
        this.sundayDayOfWeek = new JComboBox();
        int i = 1;
        while (i < wkDays.length) {
            this.sundayDayOfWeek.addItem(wkDays[i]);
            ++i;
        }
        this.addGridBagComponent(sundayPanel, this.sundayDayOfWeek, g, c, 1, 0, 17);
        this.sundayColor = new ColorPanel(this.mf.getResourceString("sundayColorLabel", "Color:"), Color.RED);
        this.addGridBagComponent(sundayPanel, this.sundayColor, g, c, 0, 1, 10, 2, 1, 0, 1.0, 1.0);
        JPanel yvPrefsPanel = new JPanel(g);
        this.addGridBagComponent(yvPrefsPanel, sundayPanel, g, c, 0, 0, 10, 2, 1, 0, 1.0, 1.0);
        this.addGridBagComponent(yvPrefsPanel, new JLabel(this.mf.getResourceString("firstDayOfWeekLabel", "First day of week:")), g, c, 0, 1, 13);
        this.firstDayOfWeek = new JComboBox();
        int i2 = 1;
        while (i2 < wkDays.length) {
            this.firstDayOfWeek.addItem(wkDays[i2]);
            ++i2;
        }
        this.addGridBagComponent(yvPrefsPanel, this.firstDayOfWeek, g, c, 1, 1, 17);
        this.headerColor = new ColorPanel(this.mf.getResourceString("headerColorLabel", "Header color:"), new Color(0, 51, 153));
        this.addGridBagComponent(yvPrefsPanel, this.headerColor, g, c, 0, 2, 10, 2, 1, 0, 1.0, 1.0);
        JTabbedPane yearPanel = new JTabbedPane();
        yearPanel.add(this.mf.getResourceString("yearViewTabLabel", "Year View"), yvPrefsPanel);
        Container contentPane = super.getContentPane();
        contentPane.add((Component)yearPanel, "Center");
        this.loadPrefs();
        this.pack();
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.okButton) {
            this.savePrefs();
        }
        super.actionPerformed(e);
    }

    private void savePrefs() {
        this.prefs.putInt(PREFSID_SUNDAY_DAY_OF_WEEK, this.sundayDayOfWeek.getSelectedIndex() + 1);
        this.prefs.putInt(PREFSID_SUNDAY_COLOR, this.sundayColor.getColor().getRGB());
        this.prefs.putInt(PREFSID_FIRST_DAY_OF_WEEK, this.firstDayOfWeek.getSelectedIndex() + 1);
        this.prefs.putInt(PREFSID_HEADER_COLOR, this.headerColor.getColor().getRGB());
    }

    private void loadPrefs() {
        this.sundayDayOfWeek.setSelectedIndex(this.prefs.getInt(PREFSID_SUNDAY_DAY_OF_WEEK, 1) - 1);
        this.sundayColor.setColor(new Color(this.prefs.getInt(PREFSID_SUNDAY_COLOR, Color.RED.getRGB())));
        this.firstDayOfWeek.setSelectedIndex(this.prefs.getInt(PREFSID_FIRST_DAY_OF_WEEK, 1) - 1);
        this.headerColor.setColor(new Color(this.prefs.getInt(PREFSID_HEADER_COLOR, Color.RED.getRGB())));
    }

    private void addGridBagComponent(JComponent container, JComponent comp, GridBagLayout g, GridBagConstraints c, int gx, int gy, int a) {
        this.addGridBagComponent(container, comp, g, c, gx, gy, a, 1, 1, 0, 0.0, 0.0);
    }

    private void addGridBagComponent(JComponent container, JComponent comp, GridBagLayout g, GridBagConstraints c, int gx, int gy, int a, int gw, int gh, int f, double wx, double wy) {
        c.gridx = gx;
        c.gridy = gy;
        c.anchor = a;
        c.insets = new Insets(2, 2, 2, 2);
        c.ipadx = 2;
        c.ipady = 2;
        c.gridwidth = gw;
        c.gridheight = gh;
        c.fill = f;
        c.weightx = wx;
        c.weighty = wy;
        g.setConstraints(comp, c);
        container.add(comp);
    }
}

