/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.allday.ui;

import com.lightdev.app.allday.ui.MonthBox;
import com.lightdev.app.allday.ui.MonthBoxModel;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormatSymbols;
import java.util.GregorianCalendar;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class YearPanel
extends JPanel {
    private MonthBox[] mb = new MonthBox[12];
    private int year;

    public YearPanel(int year) {
        this.setRequestFocusEnabled(false);
        this.setFocusable(false);
        this.year = year;
        this.setVisible(false);
        this.buildView();
    }

    public void setYear(int year) {
        this.year = year;
        int month = 0;
        while (month <= 11) {
            this.mb[month].setCalendar(new GregorianCalendar(year, month, 1));
            ++month;
        }
        this.markToday();
    }

    public int getYear() {
        return this.year;
    }

    private Color getColorFromRGB(int rgb) {
        return new Color(rgb);
    }

    private void buildView() {
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(g);
        this.setBackground(Color.WHITE);
        int gx = 0;
        int gy = 0;
        String[] months = new DateFormatSymbols().getMonths();
        Preferences prefs = null;
        try {
            prefs = Preferences.userNodeForPackage(Class.forName("com.lightdev.app.allday.ui.PrefsDialog"));
        }
        catch (Exception cnf) {
            // empty catch block
        }
        int month = 0;
        while (month <= 11) {
            MonthBoxModel model = new MonthBoxModel();
            try {
                model.setSundayDay(prefs.getInt("sdaw", 1));
                Color color = new Color(prefs.getInt("scol", Color.RED.getRGB()));
                model.setSundayColor(color);
                model.setFirstDayOfWeek(prefs.getInt("fdow", 2));
                color = new Color(prefs.getInt("hcol", new Color(0, 51, 153).getRGB()));
                model.setHeaderColor(color);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.mb[month] = new MonthBox(model, new GregorianCalendar(this.year, month, 1));
            JLabel lb = new JLabel(months[month]);
            lb.setVerticalAlignment(3);
            this.addGridBagComponent(this, lb, g, c, gx, gy, 10, 1, 1, 1, 0.25, 0.33);
            this.addGridBagComponent(this, this.mb[month], g, c, gx, gy + 1, 10, 1, 1, 1, 0.25, 0.33);
            if (++gx > 3) {
                gy += 2;
                gx = 0;
            }
            ++month;
        }
        this.markToday();
    }

    private void markToday() {
        GregorianCalendar today = new GregorianCalendar();
        if (today.get(1) == this.year) {
            this.mb[today.get(2)].setToday(today.get(5));
        } else {
            this.mb[today.get(2)].setToday(0);
        }
    }

    private void addGridBagComponent(JComponent container, JComponent comp, GridBagLayout g, GridBagConstraints c, int gx, int gy, int a, int gw, int gh, int f, double wx, double wy) {
        c.gridx = gx;
        c.gridy = gy;
        c.anchor = a;
        c.insets = new Insets(2, 2, 2, 2);
        c.ipadx = 2;
        c.ipady = 2;
        c.gridwidth = gw;
        c.gridheight = gh;
        c.fill = f;
        c.weightx = wx;
        c.weighty = wy;
        g.setConstraints(comp, c);
        container.add(comp);
    }
}

