/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.Resource;
import net.sf.borg.model.AddressModel;
import net.sf.borg.model.AppointmentModel;
import net.sf.borg.model.LinkModel;
import net.sf.borg.model.MemoModel;
import net.sf.borg.model.TaskModel;
import net.sf.borg.model.db.DBHelper;
import net.sf.borg.ui.util.GridBagConstraintsFactory;
import net.sf.borg.ui.util.ScrolledDialog;
import net.sf.borg.ui.util.TableSorter;

class SqlRunner
extends JDialog {
    private static final Logger log = Logger.getLogger("net.sf.borg");
    private static final long serialVersionUID = 1L;
    private JEditorPane editor;

    public SqlRunner() {
        this.setModal(false);
        this.initComponents();
        this.setTitle(Resource.getResourceString("RunSQL"));
        this.pack();
    }

    private void initComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.editor = new JEditorPane();
        JPanel jPanel1 = new JPanel();
        JButton runButton = new JButton();
        this.editor.setBorder(new LineBorder(new Color(0, 0, 0)));
        JScrollPane jScrollPane1 = new JScrollPane();
        jScrollPane1.setPreferredSize(new Dimension(554, 404));
        jScrollPane1.setViewportView(this.editor);
        runButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Forward16.gif")));
        runButton.setText("Run");
        runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SqlRunner.this.runbuttonActionPerformed();
            }
        });
        jPanel1.add(runButton);
        JButton clearButton = new JButton();
        clearButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Undo16.gif")));
        clearButton.setText("Clear");
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SqlRunner.this.editor.setText("");
            }
        });
        this.getContentPane().add((Component)jScrollPane1, GridBagConstraintsFactory.create(0, 0, 1, 1.0, 1.0));
        jPanel1.add((Component)clearButton, clearButton.getName());
        this.getContentPane().add((Component)jPanel1, GridBagConstraintsFactory.create(0, 1, 1));
    }

    private void runbuttonActionPerformed() {
        try {
            DBHelper.getController().beginTransaction();
            ResultSet r = DBHelper.getController().execQuery(this.editor.getText());
            DBHelper.getController().commitTransaction();
            if (r != null && r.next()) {
                JTable tbl = new JTable();
                tbl.setAutoResizeMode(0);
                int cols = r.getMetaData().getColumnCount();
                String[] colnames = new String[cols];
                Class[] classes = new Class[cols];
                for (int c = 0; c < cols; ++c) {
                    colnames[c] = r.getMetaData().getColumnName(c + 1);
                    classes[c] = String.class;
                }
                TableSorter ts = new TableSorter(colnames, classes);
                ts.addMouseListenerToHeaderInTable(tbl);
                tbl.setModel(ts);
                Object[] row = new Object[cols];
                while (!r.isAfterLast()) {
                    for (int i = 1; i <= cols; ++i) {
                        row[i - 1] = r.getString(i);
                    }
                    ts.addRow(row);
                    r.next();
                }
                ScrolledDialog.showTable(tbl);
            } else {
                ScrolledDialog.showNotice(Resource.getResourceString("noOutput"));
            }
            if (r != null) {
                r.close();
            }
        }
        catch (Exception e) {
            log.severe(e.toString());
            try {
                DBHelper.getController().rollbackTransaction();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Errmsg.getErrorHandler().errmsg(e);
        }
        AppointmentModel.getReference().refresh();
        TaskModel.getReference().refresh();
        AddressModel.getReference().refresh();
        MemoModel.getReference().refresh();
        LinkModel.getReference().refresh();
    }
}

