/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui;

import java.awt.Dialog;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observer;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.UIManager;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.common.Warning;
import net.sf.borg.model.ExportImport;
import net.sf.borg.model.db.DBHelper;
import net.sf.borg.model.ical.IcalFTP;
import net.sf.borg.model.ical.SyncLog;
import net.sf.borg.ui.FileView;
import net.sf.borg.ui.InfoView;
import net.sf.borg.ui.MultiView;
import net.sf.borg.ui.SearchView;
import net.sf.borg.ui.SunTrayIconProxy;
import net.sf.borg.ui.address.AddrListView;
import net.sf.borg.ui.calendar.DayPanel;
import net.sf.borg.ui.calendar.MonthPanel;
import net.sf.borg.ui.calendar.TodoView;
import net.sf.borg.ui.calendar.WeekPanel;
import net.sf.borg.ui.calendar.YearPanel;
import net.sf.borg.ui.checklist.CheckListPanel;
import net.sf.borg.ui.ical.IcalModule;
import net.sf.borg.ui.memo.MemoPanel;
import net.sf.borg.ui.options.MiscellaneousOptionsPanel;
import net.sf.borg.ui.popup.ReminderListManager;
import net.sf.borg.ui.popup.ReminderManager;
import net.sf.borg.ui.popup.ReminderPopupManager;
import net.sf.borg.ui.task.TaskModule;
import net.sf.borg.ui.util.NwFontChooserS;
import net.sf.borg.ui.util.SplashScreen;
import net.sf.borg.ui.util.UIErrorHandler;

public class UIControl {
    private static final Logger log = Logger.getLogger("net.sf.borg");
    private static Observer shutdownListener = null;
    private static SplashScreen splashScreen = null;

    public static void setShutdownListener(Observer shutdownListener) {
        UIControl.shutdownListener = shutdownListener;
    }

    public static void startUI(String trayname) {
        Errmsg.setErrorHandler(new UIErrorHandler());
        try {
            DBHelper.checkTimestamp();
        }
        catch (Warning e1) {
            Errmsg.getErrorHandler().notice(e1.getMessage());
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        String deffont = Prefs.getPref(PrefName.DEFFONT);
        if (!deffont.equals("")) {
            Font f = Font.decode(deffont);
            NwFontChooserS.setDefaultFont(f);
        }
        String lnf = Prefs.getPref(PrefName.LNF);
        try {
            String theme;
            if (lnf.contains("jgoodies") && (theme = System.getProperty("Plastic.defaultTheme")) == null) {
                System.setProperty("Plastic.defaultTheme", Prefs.getPref(PrefName.GOODIESTHEME));
            }
            UIManager.setLookAndFeel(lnf);
            UIManager.getLookAndFeelDefaults().put("ClassLoader", UIControl.class.getClassLoader());
        }
        catch (Exception e) {
            log.severe(e.toString());
        }
        if (Prefs.getBoolPref(PrefName.SPLASH)) {
            splashScreen = new SplashScreen(Dialog.ModalityType.MODELESS);
            splashScreen.setText(Resource.getResourceString("Initializing"));
            splashScreen.setVisible(true);
            final String tn = trayname;
            Timer t = new Timer(3000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    UIControl.completeUIInitialization(tn);
                }
            });
            t.setRepeats(false);
            t.start();
        } else {
            UIControl.completeUIInitialization(trayname);
        }
    }

    private static void completeUIInitialization(String trayname) {
        boolean bgStart;
        SunTrayIconProxy.startTrayIcon(trayname);
        if (Prefs.getBoolPref(PrefName.REMINDERLIST)) {
            ReminderListManager.getReference();
        } else {
            ReminderPopupManager.getReference();
        }
        MultiView mv = MultiView.getMainView();
        mv.addModule(new MonthPanel());
        mv.addModule(new WeekPanel());
        mv.addModule(new DayPanel());
        mv.addModule(new YearPanel());
        mv.addModule(new AddrListView());
        mv.addModule(new TodoView());
        mv.addModule(new TaskModule());
        mv.addModule(new MemoPanel());
        mv.addModule(new CheckListPanel());
        mv.addModule(new SearchView());
        mv.addModule(new InfoView("/resource/RELEASE_NOTES.txt", Resource.getResourceString("rlsnotes")));
        mv.addModule(new InfoView("/resource/CHANGES.txt", Resource.getResourceString("viewchglog")));
        mv.addModule(new InfoView("/resource/license.htm", Resource.getResourceString("License")));
        mv.addModule(new FileView(System.getProperty("user.home", "") + "/.borg.log", Resource.getResourceString("view_log")));
        mv.addModule(new IcalModule());
        if (Prefs.getBoolPref(PrefName.DYNAMIC_LOADING)) {
            UIControl.addExternalModule("net.sf.borg.plugin.reports.ReportModule");
            UIControl.addExternalModule("net.sf.borg.plugin.sync.SyncModule");
        }
        boolean bl = bgStart = Prefs.getBoolPref(PrefName.BACKGSTART) && SunTrayIconProxy.hasTrayIcon();
        if (!bgStart) {
            mv.setVisible(true);
        }
        mv.startupViews(bgStart);
        if (splashScreen != null) {
            splashScreen.dispose();
            splashScreen = null;
        }
    }

    public static void toFront() {
        MultiView.getMainView().setVisible(true);
        MultiView.getMainView().toFront();
        MultiView.getMainView().setState(0);
    }

    public static void shutDownUI() {
        ReminderManager rm;
        try {
            int res;
            if (SyncLog.getReference().isProcessUpdates() && !SyncLog.getReference().getAll().isEmpty() && (res = JOptionPane.showConfirmDialog(null, Resource.getResourceString("Sync-Warn"), null, 2, 2)) != 0) {
                return;
            }
        }
        catch (Exception e1) {
            Errmsg.getErrorHandler().errmsg(e1);
        }
        boolean do_backup = false;
        boolean backup_email = false;
        boolean export_ical = false;
        String backupdir = Prefs.getPref(PrefName.BACKUPDIR);
        if (backupdir != null && !backupdir.equals("")) {
            String shutdown_action = Prefs.getPref(PrefName.SHUTDOWN_ACTION);
            if (shutdown_action.isEmpty() || MiscellaneousOptionsPanel.SHUTDOWN_ACTION.PROMPT.toString().equals(shutdown_action)) {
                JCheckBox ic;
                JCheckBox b4;
                JCheckBox b1 = new JCheckBox(Resource.getResourceString("backup_notice") + " " + backupdir);
                Object[] array = new Object[]{b1, b4 = new JCheckBox(Resource.getResourceString("backup_with_email")), ic = new JCheckBox("ical: " + Resource.getResourceString("exportToFTP"))};
                int res = JOptionPane.showConfirmDialog(null, array, Resource.getResourceString("shutdown_options"), 2);
                if (res != 0) {
                    return;
                }
                if (b1.isSelected() || b4.isSelected()) {
                    do_backup = true;
                }
                if (b4.isSelected()) {
                    backup_email = true;
                }
                if (ic.isSelected()) {
                    export_ical = true;
                }
            } else if (MiscellaneousOptionsPanel.SHUTDOWN_ACTION.BACKUP.toString().equals(shutdown_action)) {
                do_backup = true;
            } else if (MiscellaneousOptionsPanel.SHUTDOWN_ACTION.EMAIL.toString().equals(shutdown_action)) {
                do_backup = true;
                backup_email = true;
            }
        }
        if ((rm = ReminderManager.getReminderManager()) != null) {
            rm.remove();
        }
        new NonUIShutdown(do_backup, backup_email, export_ical).execute();
        try {
            SplashScreen ban = new SplashScreen(Dialog.ModalityType.APPLICATION_MODAL);
            ban.setText(Resource.getResourceString("shutdown"));
            ban.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addExternalModule(String className) {
        try {
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            Class<?> clazz = cl.loadClass(className);
            MultiView.Module module = (MultiView.Module)clazz.newInstance();
            MultiView.getMainView().addModule(module);
        }
        catch (Exception e) {
            log.info(e.toString());
        }
    }

    private static class NonUIShutdown
    extends SwingWorker<Object, Object> {
        private boolean do_backup;
        private boolean backup_email;
        private boolean export_ical;

        public NonUIShutdown(boolean b, boolean e, boolean ic) {
            this.do_backup = b;
            this.backup_email = e;
            this.export_ical = ic;
        }

        @Override
        protected Object doInBackground() throws Exception {
            if (this.do_backup) {
                try {
                    String backupdir = Prefs.getPref(PrefName.BACKUPDIR);
                    ExportImport.exportToZip((String)backupdir, (boolean)this.backup_email);
                    log.info("Export to ZIP Complete");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.export_ical) {
                try {
                    IcalFTP.exportftp((Integer)Prefs.getIntPref(PrefName.ICAL_EXPORTYEARS));
                    log.info("FTP Ical Complete");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (shutdownListener != null) {
                shutdownListener.update(null, null);
            }
            return null;
        }
    }
}

