/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.model.Model;
import net.sf.borg.ui.ViewSize;

public abstract class View
extends JFrame
implements Model.Listener {
    private static final long serialVersionUID = 1L;
    static Image image = Toolkit.getDefaultToolkit().getImage(View.class.getResource("/resource/borg32x32.jpg"));
    private PrefName prefName_ = null;

    public View() {
        this.initialize();
    }

    public abstract void destroy();

    private void initialize() {
        this.setIconImage(image);
    }

    public void manageMySize(PrefName pname) {
        this.prefName_ = pname;
        String s = Prefs.getPref(this.prefName_);
        ViewSize vs = ViewSize.fromString(s);
        if (vs.getX() != -1) {
            this.setBounds(new Rectangle(vs.getX(), vs.getY(), vs.getWidth(), vs.getHeight()));
        } else if (vs.getWidth() != -1) {
            this.setSize(new Dimension(vs.getWidth(), vs.getHeight()));
        }
        if (vs.isMaximized()) {
            this.setExtendedState(6);
        }
        this.validate();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                View.this.recordSize(false);
            }

            @Override
            public void componentResized(ComponentEvent e) {
                View.this.recordSize(true);
            }
        });
    }

    private void recordSize(boolean resize) {
        String s = Prefs.getPref(this.prefName_);
        ViewSize vsnew = ViewSize.fromString(s);
        if (!resize) {
            if (vsnew.getHeight() != this.getBounds().height || vsnew.getWidth() != this.getBounds().width) {
                return;
            }
            if (this.getBounds().x < 0 || this.getBounds().y < 0) {
                return;
            }
            vsnew.setX(this.getBounds().x);
            vsnew.setY(this.getBounds().y);
            vsnew.setWidth(this.getBounds().width);
            vsnew.setHeight(this.getBounds().height);
        } else if (this.getExtendedState() == 6) {
            vsnew.setMaximized(true);
        } else {
            vsnew.setMaximized(false);
            vsnew.setX(this.getBounds().x);
            vsnew.setY(this.getBounds().y);
            vsnew.setWidth(this.getBounds().width);
            vsnew.setHeight(this.getBounds().height);
        }
        Prefs.putPref(this.prefName_, vsnew.toString());
    }

    public abstract void refresh();

    protected void setDismissButton(final JButton bn) {
        this.getLayeredPane().registerKeyboardAction(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                bn.getActionListeners()[0].actionPerformed(e);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }
}

