/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.calendar;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.AppointmentModel;
import net.sf.borg.model.entity.Appointment;
import net.sf.borg.model.entity.CalendarEntity;
import net.sf.borg.model.entity.LabelEntity;
import net.sf.borg.ui.calendar.ApptBox;
import net.sf.borg.ui.calendar.Box;
import net.sf.borg.ui.calendar.DateZone;
import net.sf.borg.ui.calendar.LabelBox;
import net.sf.borg.ui.calendar.NoteBox;

abstract class ApptBoxPanel
extends JPanel
implements ComponentListener {
    private static final long serialVersionUID = 1L;
    private static final int radius = 2;
    private static SimpleDateFormat sdf = new SimpleDateFormat("hh:mm");
    private static final int translation = -10;
    protected Collection<Box> boxes = new ArrayList<Box>();
    private Box currentBox = null;
    private int draggedAnchor = -1;
    private Box draggedBox = null;
    private DragNewBox dragNewBox = null;
    private boolean dragStarted = false;
    private double dragXMax = 0.0;
    private double dragXMin = 0.0;
    private double dragYMax = 0.0;
    private double dragYMin = 0.0;
    protected double endmin = 0.0;
    private ApptBox resizedBox = null;
    private Rectangle resizeRectangle = null;
    private double resizeYMax = 0.0;
    private double resizeYMin = 0.0;
    protected double startmin = 0.0;
    private Collection<DateZone> zones = new ArrayList<DateZone>();

    public static boolean isStrike(CalendarEntity appt, Date date) {
        return appt.getColor() != null && appt.getColor().equals("strike") || appt.isTodo() && appt.getNextTodo() != null && appt.getNextTodo().after(date);
    }

    public ApptBoxPanel() {
        MyMouseListener myOneListener = new MyMouseListener();
        this.addMouseListener(myOneListener);
        this.addMouseMotionListener(myOneListener);
        this.addComponentListener(this);
    }

    protected void addApptBox(Date d, Appointment ap, Rectangle bounds, Rectangle clip) {
        if (Prefs.getBoolPref(PrefName.HIDESTRIKETHROUGH) && ApptBoxPanel.isStrike((CalendarEntity)ap, d)) {
            return;
        }
        ApptBox b = new ApptBox(d, ap, bounds, clip);
        this.boxes.add(b);
    }

    public void addDateZone(Date d, Rectangle bounds) {
        DateZone b = new DateZone(d, bounds);
        this.zones.add(b);
    }

    public Box addNoteBox(Date d, CalendarEntity ap, Rectangle bounds, Rectangle clip) {
        if (Prefs.getBoolPref(PrefName.HIDESTRIKETHROUGH) && ApptBoxPanel.isStrike(ap, d)) {
            return null;
        }
        Box b = ap instanceof LabelEntity ? new LabelBox((LabelEntity)ap, bounds, clip) : new NoteBox(d, ap, bounds, clip);
        this.boxes.add(b);
        return b;
    }

    public void clearBoxes() {
        this.boxes.clear();
        this.zones.clear();
    }

    public void drawBoxes(Graphics2D g2) {
        for (Box b : this.boxes) {
            b.draw(g2, this);
        }
        if (this.resizeRectangle != null) {
            g2.setColor(Color.RED);
            g2.drawRoundRect(this.resizeRectangle.x, this.resizeRectangle.y, this.resizeRectangle.width, this.resizeRectangle.height, 4, 4);
            if (this.isInsideResizeArea(this.resizeRectangle.y, this.resizeRectangle.y + this.resizeRectangle.height)) {
                double top = ((double)this.resizeRectangle.y - this.resizeYMin) / (this.resizeYMax - this.resizeYMin);
                double bot = ((double)this.resizeRectangle.y - this.resizeYMin + (double)this.resizeRectangle.height) / (this.resizeYMax - this.resizeYMin);
                g2.setColor(new Color(50, 50, 50));
                Rectangle2D bb = g2.getFont().getStringBounds("00:00", g2.getFontRenderContext());
                g2.fillRect(this.resizeRectangle.x + 2, this.resizeRectangle.y - (int)bb.getHeight(), (int)bb.getWidth(), (int)bb.getHeight());
                g2.fillRect(this.resizeRectangle.x + 2, this.resizeRectangle.y + this.resizeRectangle.height - (int)bb.getHeight(), (int)bb.getWidth(), (int)bb.getHeight());
                g2.setColor(Color.WHITE);
                if (this.draggedBox != null && this.draggedBox instanceof ApptBox) {
                    ApptBox draggedApptBox = (ApptBox)this.draggedBox;
                    if (!this.dragStarted) {
                        top = draggedApptBox.getTopAdjustment();
                        bot = draggedApptBox.getBottomAdjustment();
                    } else {
                        bot = top + draggedApptBox.getBottomAdjustment() - draggedApptBox.getTopAdjustment();
                    }
                } else if (this.resizedBox != null) {
                    ApptBox resizedApptBox = this.resizedBox;
                    if (!this.dragStarted) {
                        top = resizedApptBox.getTopAdjustment();
                        bot = resizedApptBox.getBottomAdjustment();
                    }
                }
                g2.drawString(this.getTimeString(top), this.resizeRectangle.x + 2, this.resizeRectangle.y - 2);
                g2.drawString(this.getTimeString(bot), this.resizeRectangle.x + 2, this.resizeRectangle.y + this.resizeRectangle.height - 2);
            }
        }
        if (this.dragNewBox != null) {
            this.dragNewBox.draw(g2, this);
        }
        g2.setColor(Color.black);
    }

    private ClickedBoxInfo getClickedBoxInfo(MouseEvent evt) {
        boolean onTopBorder = false;
        boolean onBottomBorder = false;
        ClickedBoxInfo ret = new ClickedBoxInfo();
        if (this.dragNewBox != null) {
            Rectangle r = this.dragNewBox.getBounds();
            if (evt.getX() > r.x && evt.getX() < r.x + r.width && evt.getY() > r.y && evt.getY() < r.y + r.height) {
                ret.box = this.dragNewBox;
                this.dragNewBox.setSelected(true);
                if (Math.abs(evt.getY() - r.y) < 4) {
                    onTopBorder = true;
                } else if (Math.abs(evt.getY() - (r.y + r.height)) < 4) {
                    onBottomBorder = true;
                }
            } else {
                this.dragNewBox.setSelected(false);
            }
        }
        for (Box box : this.boxes) {
            if (!box.isClickable()) continue;
            if (ret.box == null && evt.getX() > box.getBounds().x && evt.getX() < box.getBounds().x + box.getBounds().width && evt.getY() > box.getBounds().y && evt.getY() < box.getBounds().y + box.getBounds().height) {
                box.setSelected(true);
                ret.box = box;
                if (!(box instanceof ApptBox)) continue;
                if (Math.abs(evt.getY() - box.getBounds().y) < 4) {
                    onTopBorder = true;
                    continue;
                }
                if (Math.abs(evt.getY() - (box.getBounds().y + box.getBounds().height)) >= 4) continue;
                onBottomBorder = true;
                continue;
            }
            box.setSelected(false);
        }
        for (DateZone dateZone : this.zones) {
            if (evt.getX() <= dateZone.getBounds().x || evt.getX() >= dateZone.getBounds().x + dateZone.getBounds().width || evt.getY() <= dateZone.getBounds().y || evt.getY() >= dateZone.getBounds().y + dateZone.getBounds().height) continue;
            ret.zone = dateZone;
            break;
        }
        ret.onTopBorder = onTopBorder;
        ret.onBottomBorder = onBottomBorder;
        if (ret.box != this.currentBox) {
            ret.boxChanged = true;
        }
        this.currentBox = ret.box;
        if (ret.box == null && ret.zone == null) {
            return null;
        }
        return ret;
    }

    abstract Date getDateForCoord(double var1, double var3);

    public String getTimeString(double y_fraction) {
        int realtime = this.realMins(y_fraction);
        int hour = realtime / 60;
        int min = realtime % 60;
        GregorianCalendar newCal = new GregorianCalendar();
        newCal.set(11, hour);
        newCal.set(12, min);
        Date newTime = newCal.getTime();
        return sdf.format(newTime);
    }

    private boolean isInsideResizeArea(int top, int bot) {
        return (double)top >= this.resizeYMin && (double)bot <= this.resizeYMax;
    }

    private int realMins(double y_fraction) {
        double realtime = this.startmin + (this.endmin - this.startmin) * y_fraction;
        int min = 5 * (int)Math.round(realtime / 5.0);
        return min;
    }

    public abstract void refresh();

    protected void removeDragNewBox() {
        this.dragNewBox = null;
        this.draggedAnchor = -1;
    }

    public void removeResizeBox() {
        this.resizeRectangle = null;
    }

    protected void setDragBounds(int ymin, int ymax, int xmin, int xmax) {
        this.dragYMin = ymin;
        this.dragYMax = ymax;
        this.dragXMin = xmin;
        this.dragXMax = xmax;
    }

    protected void setDragNewBox(double x, double y, double w, double h) {
        Rectangle bounds = new Rectangle();
        bounds.x = (int)x;
        bounds.y = (int)y;
        bounds.height = (int)h;
        bounds.width = (int)w;
        this.dragNewBox.setBounds(bounds);
    }

    protected void setResizeBounds(int ymin, int ymax) {
        this.resizeYMin = ymin;
        this.resizeYMax = ymax;
    }

    protected void setResizeBox(double x, double y, double w, double h) {
        if (this.resizeRectangle == null) {
            this.resizeRectangle = new Rectangle();
        }
        this.resizeRectangle.x = (int)x;
        this.resizeRectangle.y = (int)y;
        this.resizeRectangle.height = (int)h;
        this.resizeRectangle.width = (int)w;
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.refresh();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    private class MyMouseListener
    implements MouseListener,
    MouseMotionListener {
        private boolean resizeTop = true;

        private MyMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            evt.translatePoint(-10, -10);
            ClickedBoxInfo b = ApptBoxPanel.this.getClickedBoxInfo(evt);
            if (evt.getButton() == 3) {
                if (b == null) {
                    return;
                }
                if (b.box != null) {
                    if (b.box.getMenu() != null) {
                        b.box.getMenu().show(evt.getComponent(), evt.getX(), evt.getY());
                    }
                } else if (b.zone != null) {
                    b.zone.getMenu().show(evt.getComponent(), evt.getX(), evt.getY());
                }
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(evt)) {
                return;
            }
            evt.getComponent().repaint();
            if (b == null) {
                return;
            }
            if (b.box != null) {
                if (b.box.clicksToActivate() <= evt.getClickCount()) {
                    b.box.onClick();
                }
            } else if (b.zone != null && evt.getClickCount() > 1 && (double)evt.getY() >= ApptBoxPanel.this.resizeYMin) {
                int clickmins;
                int realtime = clickmins = ApptBoxPanel.this.realMins(((double)evt.getY() - ApptBoxPanel.this.resizeYMin) / (ApptBoxPanel.this.resizeYMax - ApptBoxPanel.this.resizeYMin));
                int hour = realtime / 60;
                int min = realtime % 60;
                min = min / 5 * 5;
                GregorianCalendar startCal = new GregorianCalendar();
                startCal.setTime(b.zone.getDate());
                startCal.set(11, hour);
                startCal.set(12, min);
                b.zone.onClick(startCal);
            } else if (b.zone != null && evt.getClickCount() > 1 && (double)evt.getY() < ApptBoxPanel.this.resizeYMin) {
                b.zone.onClick();
            }
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            evt.translatePoint(-10, -10);
            if (!SwingUtilities.isLeftMouseButton(evt)) {
                return;
            }
            ApptBoxPanel.this.dragStarted = true;
            if (ApptBoxPanel.this.resizedBox != null) {
                if (this.resizeTop) {
                    int top = (int)Math.max((double)evt.getY(), ApptBoxPanel.this.resizeYMin);
                    ApptBoxPanel.this.setResizeBox(((ApptBoxPanel)ApptBoxPanel.this).resizedBox.getBounds().x, top, ((ApptBoxPanel)ApptBoxPanel.this).resizedBox.getBounds().width, ((ApptBoxPanel)ApptBoxPanel.this).resizedBox.getBounds().height + ((ApptBoxPanel)ApptBoxPanel.this).resizedBox.getBounds().y - top);
                } else {
                    int bot = (int)Math.min((double)evt.getY(), ApptBoxPanel.this.resizeYMax);
                    ApptBoxPanel.this.setResizeBox(((ApptBoxPanel)ApptBoxPanel.this).resizedBox.getBounds().x, ((ApptBoxPanel)ApptBoxPanel.this).resizedBox.getBounds().y, ((ApptBoxPanel)ApptBoxPanel.this).resizedBox.getBounds().width, bot - ((ApptBoxPanel)ApptBoxPanel.this).resizedBox.getBounds().y);
                }
                evt.getComponent().repaint();
            } else if (ApptBoxPanel.this.draggedBox != null) {
                int left;
                int top = evt.getY() - ((ApptBoxPanel)ApptBoxPanel.this).draggedBox.getBounds().height / 2;
                if ((double)top < ApptBoxPanel.this.dragYMin) {
                    top = (int)ApptBoxPanel.this.dragYMin;
                }
                if ((double)(top + ((ApptBoxPanel)ApptBoxPanel.this).draggedBox.getBounds().height) > ApptBoxPanel.this.dragYMax) {
                    top = (int)ApptBoxPanel.this.dragYMax - ((ApptBoxPanel)ApptBoxPanel.this).draggedBox.getBounds().height;
                }
                if ((double)(left = evt.getX() - ((ApptBoxPanel)ApptBoxPanel.this).draggedBox.getBounds().width / 2) < ApptBoxPanel.this.dragXMin) {
                    left = (int)ApptBoxPanel.this.dragXMin;
                }
                if ((double)(left + ((ApptBoxPanel)ApptBoxPanel.this).draggedBox.getBounds().width) > ApptBoxPanel.this.dragXMax) {
                    left = (int)ApptBoxPanel.this.dragXMax - ((ApptBoxPanel)ApptBoxPanel.this).draggedBox.getBounds().width;
                }
                ApptBoxPanel.this.setResizeBox(left, top, ((ApptBoxPanel)ApptBoxPanel.this).draggedBox.getBounds().width, ((ApptBoxPanel)ApptBoxPanel.this).draggedBox.getBounds().height);
                evt.getComponent().repaint();
            } else if (ApptBoxPanel.this.draggedAnchor != -1) {
                ClickedBoxInfo b = ApptBoxPanel.this.getClickedBoxInfo(evt);
                if (b == null) {
                    return;
                }
                if (ApptBoxPanel.this.dragNewBox == null) {
                    ApptBoxPanel.this.dragNewBox = new DragNewBox(b.zone);
                    ApptBoxPanel.this.setDragNewBox(b.zone.getBounds().x, evt.getY(), b.zone.getBounds().width, 5.0);
                }
                double y = evt.getY();
                y = Math.max(y, ApptBoxPanel.this.resizeYMin);
                y = Math.min(y, ApptBoxPanel.this.resizeYMax);
                Rectangle r = ApptBoxPanel.this.dragNewBox.getBounds();
                if (y > (double)ApptBoxPanel.this.draggedAnchor) {
                    ApptBoxPanel.this.setDragNewBox(r.x, r.y, r.width, y - (double)ApptBoxPanel.this.draggedAnchor);
                } else {
                    ApptBoxPanel.this.setDragNewBox(r.x, y, r.width, (double)ApptBoxPanel.this.draggedAnchor - y);
                }
                evt.getComponent().repaint();
            }
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            evt.translatePoint(-10, -10);
            JPanel panel = (JPanel)evt.getComponent();
            ClickedBoxInfo b = ApptBoxPanel.this.getClickedBoxInfo(evt);
            if (b != null && b.box != null) {
                panel.setToolTipText(b.box.getToolTipText());
            } else {
                panel.setToolTipText(null);
            }
            if (b != null && (b.onTopBorder || b.onBottomBorder)) {
                panel.setCursor(new Cursor(8));
            } else if (b != null && b.box != null && b.box instanceof Box.Draggable) {
                panel.setCursor(new Cursor(13));
            } else {
                panel.setCursor(new Cursor(12));
            }
            if (b != null && b.boxChanged) {
                evt.getComponent().repaint();
            }
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            evt.translatePoint(-10, -10);
            if (!SwingUtilities.isLeftMouseButton(evt)) {
                return;
            }
            ClickedBoxInfo b = ApptBoxPanel.this.getClickedBoxInfo(evt);
            if (b == null || b.box != ApptBoxPanel.this.dragNewBox) {
                ApptBoxPanel.this.removeDragNewBox();
            }
            ApptBoxPanel.this.dragStarted = false;
            if (b != null && (b.onTopBorder || b.onBottomBorder)) {
                if (b.box instanceof ApptBox) {
                    ApptBoxPanel.this.resizedBox = (ApptBox)b.box;
                    ApptBoxPanel.this.setResizeBox(b.box.getBounds().x, b.box.getBounds().y, b.box.getBounds().width, b.box.getBounds().height);
                    this.resizeTop = !b.onBottomBorder;
                } else if (b.box == ApptBoxPanel.this.dragNewBox) {
                    if (b.onBottomBorder) {
                        ApptBoxPanel.this.draggedAnchor = ((ApptBoxPanel)ApptBoxPanel.this).dragNewBox.getBounds().y;
                    } else {
                        ApptBoxPanel.this.draggedAnchor = ((ApptBoxPanel)ApptBoxPanel.this).dragNewBox.getBounds().y + ((ApptBoxPanel)ApptBoxPanel.this).dragNewBox.getBounds().height;
                    }
                }
                evt.getComponent().repaint();
            } else if (b != null && b.box != null && b.box instanceof Box.Draggable) {
                ApptBoxPanel.this.draggedBox = b.box;
                ApptBoxPanel.this.setResizeBox(b.box.getBounds().x, b.box.getBounds().y, b.box.getBounds().width, b.box.getBounds().height);
                evt.getComponent().repaint();
            } else if (b != null && b.zone != null && (double)evt.getY() > ApptBoxPanel.this.resizeYMin && (double)evt.getY() < ApptBoxPanel.this.resizeYMax) {
                ApptBoxPanel.this.draggedAnchor = evt.getY();
            }
            JPanel panel = (JPanel)evt.getComponent();
            if (b != null && (b.onTopBorder || b.onBottomBorder)) {
                panel.setCursor(new Cursor(8));
            } else if (b != null && b.box != null && b.box instanceof Box.Draggable) {
                panel.setCursor(new Cursor(13));
            } else {
                panel.setCursor(new Cursor(12));
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            evt.translatePoint(-10, -10);
            if (evt.getButton() == 3) {
                return;
            }
            if (ApptBoxPanel.this.resizedBox != null && ApptBoxPanel.this.dragStarted) {
                double y = evt.getY();
                y = Math.max(y, ApptBoxPanel.this.resizeYMin);
                y = Math.min(y, ApptBoxPanel.this.resizeYMax);
                try {
                    ApptBoxPanel.this.resizedBox.resize(this.resizeTop, ApptBoxPanel.this.realMins((y - ApptBoxPanel.this.resizeYMin) / (ApptBoxPanel.this.resizeYMax - ApptBoxPanel.this.resizeYMin)));
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                }
            } else if (ApptBoxPanel.this.draggedBox != null && ApptBoxPanel.this.dragStarted) {
                double y = ((ApptBoxPanel)ApptBoxPanel.this).resizeRectangle.y;
                y = Math.max(y, ApptBoxPanel.this.resizeYMin);
                y = Math.min(y, ApptBoxPanel.this.resizeYMax);
                double centerx = evt.getX();
                double centery = evt.getY();
                centery = Math.max(centery, ApptBoxPanel.this.dragYMin);
                centery = Math.min(centery, ApptBoxPanel.this.dragYMax);
                Date d = ApptBoxPanel.this.getDateForCoord(centerx, centery);
                try {
                    if (ApptBoxPanel.this.isInsideResizeArea(((ApptBoxPanel)ApptBoxPanel.this).resizeRectangle.y, ((ApptBoxPanel)ApptBoxPanel.this).resizeRectangle.y + ((ApptBoxPanel)ApptBoxPanel.this).resizeRectangle.height)) {
                        ((Box.Draggable)((Object)ApptBoxPanel.this.draggedBox)).move(ApptBoxPanel.this.realMins((y - ApptBoxPanel.this.resizeYMin) / (ApptBoxPanel.this.resizeYMax - ApptBoxPanel.this.resizeYMin)), d);
                    } else {
                        ((Box.Draggable)((Object)ApptBoxPanel.this.draggedBox)).move(-1, d);
                    }
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                }
            }
            ApptBoxPanel.this.draggedBox = null;
            ApptBoxPanel.this.resizedBox = null;
            ApptBoxPanel.this.removeResizeBox();
            evt.getComponent().repaint();
        }
    }

    private class DragNewBox
    extends Box {
        private BasicStroke thicker;
        DateZone zone;
        JPopupMenu pop;

        public DragNewBox(DateZone zone) {
            super(null, null);
            this.thicker = new BasicStroke(4.0f);
            this.pop = null;
            this.zone = zone;
        }

        private void addAppt() {
            String text = JOptionPane.showInputDialog("", (Object)Resource.getResourceString("Please_enter_some_appointment_text"));
            if (text == null || text.trim().isEmpty()) {
                Errmsg.getErrorHandler().notice(Resource.getResourceString("Please_enter_some_appointment_text"));
                return;
            }
            Appointment appt = AppointmentModel.getReference().getDefaultAppointment();
            if (appt == null) {
                appt = AppointmentModel.getReference().newAppt();
            }
            appt.setText(text);
            Rectangle r = this.getBounds();
            int topmins = ApptBoxPanel.this.realMins(((double)r.y - ApptBoxPanel.this.resizeYMin) / (ApptBoxPanel.this.resizeYMax - ApptBoxPanel.this.resizeYMin));
            int botmins = ApptBoxPanel.this.realMins(((double)r.y - ApptBoxPanel.this.resizeYMin + (double)r.height) / (ApptBoxPanel.this.resizeYMax - ApptBoxPanel.this.resizeYMin));
            int realtime = topmins;
            int hour = realtime / 60;
            int min = realtime % 60;
            min = min / 5 * 5;
            GregorianCalendar startCal = new GregorianCalendar();
            startCal.setTime(this.zone.getDate());
            startCal.set(11, hour);
            startCal.set(12, min);
            appt.setDate(startCal.getTime());
            int realend = botmins;
            int ehour = realend / 60;
            int emin = realend % 60;
            emin = emin / 5 * 5;
            int dur = 60 * (ehour - hour) + emin - min;
            appt.setDuration(new Integer(dur));
            if (dur > 0) {
                appt.setUntimed("N");
            } else {
                appt.setUntimed("Y");
            }
            AppointmentModel.getReference().saveAppt(appt);
            ApptBoxPanel.this.removeDragNewBox();
            ApptBoxPanel.this.repaint();
        }

        @Override
        public void draw(Graphics2D g2, Component comp) {
            Stroke stroke = g2.getStroke();
            g2.setStroke(this.thicker);
            g2.setColor(Color.GREEN);
            if (this.isSelected) {
                g2.setColor(Color.CYAN);
            }
            Rectangle r = this.getBounds();
            g2.drawRoundRect(r.x + 2, r.y, r.width - 2, r.height, 4, 4);
            g2.setStroke(stroke);
            double top = ((double)r.y - ApptBoxPanel.this.resizeYMin) / (ApptBoxPanel.this.resizeYMax - ApptBoxPanel.this.resizeYMin);
            double bot = ((double)r.y - ApptBoxPanel.this.resizeYMin + (double)r.height) / (ApptBoxPanel.this.resizeYMax - ApptBoxPanel.this.resizeYMin);
            g2.setColor(new Color(50, 50, 50));
            Rectangle2D bb = g2.getFont().getStringBounds("00:00", g2.getFontRenderContext());
            g2.fillRect(r.x + 2, r.y - (int)bb.getHeight(), (int)bb.getWidth(), (int)bb.getHeight());
            g2.fillRect(r.x + 2, r.y + r.height - (int)bb.getHeight(), (int)bb.getWidth(), (int)bb.getHeight());
            g2.setColor(Color.WHITE);
            g2.drawString(ApptBoxPanel.this.getTimeString(top), r.x + 2, r.y - 2);
            g2.drawString(ApptBoxPanel.this.getTimeString(bot), r.x + 2, r.y + r.height - 2);
        }

        @Override
        public JPopupMenu getMenu() {
            if (this.pop == null) {
                JMenuItem mnuitm = null;
                this.pop = new JPopupMenu();
                mnuitm = new JMenuItem(Resource.getResourceString("Add_New"));
                this.pop.add(mnuitm);
                mnuitm.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        DragNewBox.this.addAppt();
                    }
                });
            }
            return this.pop;
        }

        @Override
        public void onClick() {
            this.addAppt();
        }

        @Override
        public String getText() {
            return null;
        }

        @Override
        public String getToolTipText() {
            return null;
        }
    }

    private class ClickedBoxInfo {
        public Box box = null;
        public boolean onBottomBorder = false;
        public boolean onTopBorder = false;
        public DateZone zone = null;
        public boolean boxChanged = false;

        private ClickedBoxInfo() {
        }
    }
}

