/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.calendar;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.Resource;
import net.sf.borg.common.Warning;
import net.sf.borg.model.AppointmentModel;
import net.sf.borg.model.Repeat;
import net.sf.borg.model.entity.Appointment;
import net.sf.borg.ui.ClipBoard;
import net.sf.borg.ui.calendar.AppointmentListView;

class DateZone {
    private Rectangle bounds;
    private Date date;
    private JPopupMenu popmenu = null;
    private JMenuItem pasteItem = null;

    public DateZone(Date d, Rectangle bounds) {
        this.date = d;
        this.bounds = bounds;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public Date getDate() {
        return this.date;
    }

    public JPopupMenu getMenu() {
        if (this.popmenu == null) {
            this.popmenu = new JPopupMenu();
            JMenuItem mnuitm = new JMenuItem(Resource.getResourceString("Add_New"));
            this.popmenu.add(mnuitm);
            mnuitm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DateZone.this.onClick();
                }
            });
            mnuitm = new JMenuItem(Resource.getResourceString("todoquickentry"));
            this.popmenu.add(mnuitm);
            mnuitm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DateZone.this.quickAdd(true);
                }
            });
            mnuitm = new JMenuItem(Resource.getResourceString("Quick_Note"));
            this.popmenu.add(mnuitm);
            mnuitm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DateZone.this.quickAdd(false);
                }
            });
            this.pasteItem = new JMenuItem(Resource.getResourceString("Paste"));
            this.popmenu.add(this.pasteItem);
            this.pasteItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Appointment appt = (Appointment)ClipBoard.getReference().get(Appointment.class);
                    DateZone.this.pasteAppt(appt);
                }
            });
        }
        this.pasteItem.setEnabled(ClipBoard.getReference().get(Appointment.class) != null);
        return this.popmenu;
    }

    void onClick() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this.date);
        AppointmentListView ag = new AppointmentListView(cal.get(1), cal.get(2), cal.get(5));
        ag.showView();
        ag.showApp(-1);
    }

    void onClick(GregorianCalendar cal) {
        AppointmentListView ag = new AppointmentListView(cal.get(1), cal.get(2), cal.get(5));
        ag.setTime(cal.get(11), cal.get(12));
        ag.showView();
        ag.showApp(-1);
    }

    private void quickAdd(boolean todo) {
        String tdtext = JOptionPane.showInputDialog("", (Object)Resource.getResourceString("Please_enter_some_appointment_text"));
        if (tdtext == null || tdtext.trim().isEmpty()) {
            return;
        }
        Appointment appt = AppointmentModel.getReference().getDefaultAppointment();
        if (appt == null) {
            appt = AppointmentModel.getReference().newAppt();
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this.date);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(9, 0);
        appt.setDate(cal.getTime());
        appt.setText(tdtext);
        appt.setTodo(todo);
        appt.setUntimed("Y");
        AppointmentModel.getReference().saveAppt(appt);
    }

    private void pasteAppt(Appointment appt) {
        GregorianCalendar newcal = new GregorianCalendar();
        newcal.setTime(this.date);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(appt.getDate());
        cal.set(1, newcal.get(1));
        cal.set(2, newcal.get(2));
        cal.set(5, newcal.get(5));
        String freq = appt.getFrequency();
        try {
            if (!Repeat.isCompatible((Calendar)cal, (String)Repeat.getFreqString((String)Repeat.getFreq((String)freq)), (Collection)Repeat.getDaylist((String)freq))) {
                throw new Warning(Resource.getResourceString("recur_compat"));
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
            return;
        }
        appt.setDate(cal.getTime());
        appt.setKey(-1);
        AppointmentModel.getReference().saveAppt(appt);
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    public void setDate(Date date) {
        this.date = date;
    }
}

