/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.calendar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import net.sf.borg.model.Theme;
import net.sf.borg.model.entity.LabelEntity;
import net.sf.borg.ui.calendar.Box;

class LabelBox
extends Box {
    private LabelEntity entity = null;

    public LabelBox(LabelEntity ap, Rectangle bounds, Rectangle clip) {
        super(bounds, clip);
        this.entity = ap;
    }

    @Override
    public void draw(Graphics2D g2, Component comp) {
        Shape s = g2.getClip();
        if (this.clip != null) {
            g2.setClip(this.clip);
        }
        int smfontHeight = g2.getFontMetrics().getHeight();
        if (this.isSelected) {
            g2.setColor(Color.WHITE);
            g2.fillRect(this.bounds.x, this.bounds.y + 2, this.bounds.width, this.bounds.height);
        }
        g2.setColor(Color.black);
        Theme t = Theme.getCurrentTheme();
        if (this.getTextColor().equals("red")) {
            g2.setColor(new Color(t.getTextColor1()));
        } else if (this.getTextColor().equals("green")) {
            g2.setColor(new Color(t.getTextColor3()));
        } else if (this.getTextColor().equals("blue")) {
            g2.setColor(new Color(t.getTextColor2()));
        } else if (this.getTextColor().equals("black")) {
            g2.setColor(new Color(t.getTextColor4()));
        } else if (this.getTextColor().equals("white")) {
            g2.setColor(new Color(t.getTextColor5()));
        } else if (this.getTextColor().equals("navy")) {
            g2.setColor(new Color(t.getTaskTextColor()));
        } else if (this.getTextColor().equals("purple")) {
            g2.setColor(new Color(t.getHolidayTextColor()));
        } else if (this.getTextColor().equals("brick")) {
            g2.setColor(new Color(t.getBirthdayTextColor()));
        }
        g2.drawString(this.getText(), this.bounds.x + 2, this.bounds.y + smfontHeight);
        g2.setColor(Color.black);
        g2.setClip(s);
    }

    @Override
    public String getText() {
        return this.entity.getText();
    }

    private String getTextColor() {
        if (this.entity == null) {
            return null;
        }
        return this.entity.getColor();
    }

    @Override
    public void onClick() {
    }

    @Override
    public String getToolTipText() {
        return this.getText();
    }
}

