/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.calendar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.text.AttributedString;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import net.sf.borg.common.DateUtil;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.common.Warning;
import net.sf.borg.model.AppointmentModel;
import net.sf.borg.model.LinkModel;
import net.sf.borg.model.Repeat;
import net.sf.borg.model.TaskModel;
import net.sf.borg.model.Theme;
import net.sf.borg.model.entity.Appointment;
import net.sf.borg.model.entity.CalendarEntity;
import net.sf.borg.model.entity.KeyedEntity;
import net.sf.borg.model.entity.Project;
import net.sf.borg.model.entity.Subtask;
import net.sf.borg.model.entity.Task;
import net.sf.borg.ui.ClipBoard;
import net.sf.borg.ui.MultiView;
import net.sf.borg.ui.calendar.AppointmentListView;
import net.sf.borg.ui.calendar.AppointmentTextFormat;
import net.sf.borg.ui.calendar.ApptBoxPanel;
import net.sf.borg.ui.calendar.Box;
import net.sf.borg.ui.task.ProjectView;
import net.sf.borg.ui.task.TaskView;

public class NoteBox
extends Box
implements Box.Draggable {
    private CalendarEntity bean = null;
    private Date date;
    private boolean hasLink = false;
    private int oldFontHeight = -1;
    private JPopupMenu popmenu = null;
    private Icon todoIcon = null;
    private String todoMarker = null;
    private String noteText = null;

    public NoteBox(Date d, CalendarEntity ap, Rectangle bounds, Rectangle clip) {
        super(bounds, clip);
        this.bean = ap;
        this.date = d;
        String iconname = Prefs.getPref(PrefName.UCS_MARKER);
        String use_marker = Prefs.getPref(PrefName.UCS_MARKTODO);
        if (use_marker.equals("true")) {
            if (iconname.endsWith(".gif") || iconname.endsWith(".jpg")) {
                this.todoIcon = new ImageIcon(this.getClass().getResource("/resource/" + iconname));
            } else {
                this.todoMarker = iconname;
            }
        }
        try {
            Collection atts = LinkModel.getReference().getLinks((KeyedEntity)this.bean);
            if (atts != null && atts.size() > 0) {
                this.hasLink = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.noteText = ap instanceof Appointment ? AppointmentTextFormat.format((Appointment)ap, d) : ap.getText();
    }

    @Override
    public void delete() {
        if (this.bean instanceof Appointment) {
            AppointmentModel.getReference().delAppt(((Appointment)this.bean).getKey());
        }
    }

    @Override
    public void draw(Graphics2D g2, Component comp) {
        Shape s = g2.getClip();
        if (this.clip != null) {
            g2.setClip(this.clip);
        }
        Font sm_font = g2.getFont();
        int smfontHeight = g2.getFontMetrics().getHeight();
        if (this.oldFontHeight != smfontHeight) {
            if (this.todoIcon != null) {
                try {
                    BufferedImage image1 = ImageIO.read(this.getClass().getResource("/resource/" + Prefs.getPref(PrefName.UCS_MARKER)));
                    double size = image1.getHeight();
                    double scale = (double)smfontHeight / (2.0 * size);
                    AffineTransform tx = AffineTransform.getScaleInstance(scale, scale);
                    AffineTransformOp op = new AffineTransformOp(tx, 3);
                    BufferedImage rImage = op.filter(image1, null);
                    this.todoIcon = new ImageIcon(rImage);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.oldFontHeight = smfontHeight;
        }
        HashMap<TextAttribute, Serializable> stmap = new HashMap<TextAttribute, Serializable>();
        stmap.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        stmap.put(TextAttribute.FONT, sm_font);
        Theme t = Theme.getCurrentTheme();
        if (this.isSelected) {
            g2.setColor(new Color(t.getDefaultFg()));
            g2.fillRect(this.bounds.x, this.bounds.y + 2, this.bounds.width, this.bounds.height);
        }
        g2.setColor(Color.BLACK);
        if (this.getTextColor().equals("strike")) {
            AttributedString as = new AttributedString(this.getText(), stmap);
            g2.drawString(as.getIterator(), this.bounds.x + 2, this.bounds.y + smfontHeight);
        } else {
            if (this.isSelected) {
                g2.setColor(new Color(t.getDefaultBg()));
            } else if (this.getTextColor().equals("red")) {
                g2.setColor(new Color(t.getTextColor1()));
            } else if (this.getTextColor().equals("green")) {
                g2.setColor(new Color(t.getTextColor3()));
            } else if (this.getTextColor().equals("blue")) {
                g2.setColor(new Color(t.getTextColor2()));
            } else if (this.getTextColor().equals("black")) {
                g2.setColor(new Color(t.getTextColor4()));
            } else if (this.getTextColor().equals("white")) {
                g2.setColor(new Color(t.getTextColor5()));
            } else if (this.getTextColor().equals("navy")) {
                g2.setColor(new Color(t.getTaskTextColor()));
            } else if (this.getTextColor().equals("purple")) {
                g2.setColor(new Color(t.getHolidayTextColor()));
            } else if (this.getTextColor().equals("brick")) {
                g2.setColor(new Color(t.getBirthdayTextColor()));
            }
            int offset = 2;
            String text = this.getText();
            if (this.hasLink) {
                text = "@ " + text;
            }
            if (this.isTodo() && this.todoIcon != null) {
                this.todoIcon.paintIcon(comp, g2, this.bounds.x + offset, this.bounds.y + this.bounds.height / 2);
                offset = this.todoIcon.getIconWidth();
            } else if (this.isTodo() && this.todoMarker != null) {
                text = this.todoMarker + " " + text;
            }
            g2.drawString(text, this.bounds.x + offset, this.bounds.y + smfontHeight);
            g2.setColor(Color.black);
        }
        g2.setClip(s);
        g2.setColor(Color.black);
    }

    @Override
    public JPopupMenu getMenu() {
        if (!(this.bean instanceof Appointment)) {
            return null;
        }
        if (this.popmenu == null) {
            this.popmenu = new JPopupMenu();
            JMenuItem mnuitm = new JMenuItem(Resource.getResourceString("Edit"));
            this.popmenu.add(mnuitm);
            mnuitm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    NoteBox.this.onClick();
                }
            });
            mnuitm = new JMenuItem(Resource.getResourceString("Delete"));
            this.popmenu.add(mnuitm);
            mnuitm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int ret = JOptionPane.showConfirmDialog(null, Resource.getResourceString("Really_Delete_") + "?", Resource.getResourceString("Confirm_Delete"), 2, 3);
                    if (ret != 0) {
                        return;
                    }
                    NoteBox.this.delete();
                }
            });
            if (this.bean instanceof Appointment) {
                mnuitm = new JMenuItem(Resource.getResourceString("Copy"));
                this.popmenu.add(mnuitm);
                mnuitm.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        Appointment appt = (Appointment)NoteBox.this.bean;
                        ClipBoard.getReference().put(appt.copy());
                    }
                });
            }
            if (this.isTodo()) {
                mnuitm = new JMenuItem(Resource.getResourceString("Done_(No_Delete)"));
                this.popmenu.add(mnuitm);
                mnuitm.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        try {
                            AppointmentModel.getReference().do_todo(((Appointment)NoteBox.this.bean).getKey(), false, NoteBox.this.date);
                        }
                        catch (Exception e) {
                            Errmsg.getErrorHandler().errmsg(e);
                        }
                    }
                });
                mnuitm = new JMenuItem(Resource.getResourceString("Done_(Delete)"));
                this.popmenu.add(mnuitm);
                mnuitm.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        try {
                            AppointmentModel.getReference().do_todo(((Appointment)NoteBox.this.bean).getKey(), true, NoteBox.this.date);
                        }
                        catch (Exception e) {
                            Errmsg.getErrorHandler().errmsg(e);
                        }
                    }
                });
            }
            if (this.bean instanceof Appointment && Repeat.isRepeating((Appointment)((Appointment)this.bean))) {
                mnuitm = new JMenuItem(Resource.getResourceString("Delete_One_Only"));
                this.popmenu.add(mnuitm);
                mnuitm.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        try {
                            AppointmentModel.getReference().delOneOnly(((Appointment)NoteBox.this.bean).getKey(), NoteBox.this.date);
                        }
                        catch (Exception e) {
                            Errmsg.getErrorHandler().errmsg(e);
                        }
                    }
                });
            }
        }
        return this.popmenu;
    }

    @Override
    public String getText() {
        return this.noteText;
    }

    private String getTextColor() {
        if (this.bean == null) {
            return null;
        }
        if (ApptBoxPanel.isStrike(this.bean, this.date)) {
            return "strike";
        }
        return this.bean.getColor();
    }

    private boolean isTodo() {
        return this.bean.isTodo();
    }

    @Override
    public void move(int real_time, Date d) throws Exception {
        int realtime = real_time;
        if (this.bean instanceof Appointment) {
            int k2;
            Appointment ap = AppointmentModel.getReference().getAppt(((Appointment)this.bean).getKey());
            if (realtime == -1) {
                realtime = 0;
            }
            int hour = realtime / 60;
            int min = realtime % 60;
            int olddate = DateUtil.dayOfEpoch(ap.getDate());
            GregorianCalendar newCal = new GregorianCalendar();
            newCal.setTime(d);
            if (hour != 0 || min != 0) {
                ap.setDuration(new Integer(15));
                ap.setUntimed("N");
                newCal.set(11, hour);
                int roundMin = min / 5 * 5;
                newCal.set(12, roundMin);
            } else {
                GregorianCalendar oldCal = new GregorianCalendar();
                oldCal.setTime(ap.getDate());
                newCal.set(11, oldCal.get(11));
                newCal.set(12, oldCal.get(12));
                newCal.set(13, 0);
            }
            Date newTime = newCal.getTime();
            int newdate = DateUtil.dayOfEpoch(newTime);
            if (olddate != newdate && Repeat.isRepeating((Appointment)ap) && olddate != (k2 = DateUtil.dayOfEpoch(this.date))) {
                int incdate = newdate - k2;
                newCal.setTime(ap.getDate());
                newCal.add(5, incdate);
                newTime = newCal.getTime();
            }
            ap.setDate(newTime);
            AppointmentModel.getReference().saveAppt(ap);
        } else if (this.bean instanceof Task) {
            Task task = TaskModel.getReference().getTask(((Task)this.bean).getKey());
            Date origd = task.getDueDate();
            task.setDueDate(d);
            if (task.getDueDate() != null && DateUtil.isAfter(task.getStartDate(), task.getDueDate())) {
                throw new Warning(Resource.getResourceString("sd_dd_warn"));
            }
            TaskModel.getReference().savetask(task);
            TaskModel.getReference().addLog(task.getKey(), Resource.getResourceString("DueDate") + " " + Resource.getResourceString("Change") + ": " + DateFormat.getDateInstance().format(origd) + " --> " + DateFormat.getDateInstance().format(d));
        } else if (this.bean instanceof Subtask) {
            Subtask subtask = TaskModel.getReference().getSubTask(((Subtask)this.bean).getKey());
            subtask.setDueDate(d);
            if (subtask.getDueDate() != null && DateUtil.isAfter(subtask.getStartDate(), subtask.getDueDate())) {
                throw new Warning(Resource.getResourceString("sd_dd_warn"));
            }
            TaskModel.getReference().saveSubTask(subtask);
        } else if (this.bean instanceof Project) {
            Project project = TaskModel.getReference().getProject(((Project)this.bean).getKey());
            project.setDueDate(d);
            if (project.getDueDate() != null && DateUtil.isAfter(project.getStartDate(), project.getDueDate())) {
                throw new Warning(Resource.getResourceString("sd_dd_warn"));
            }
            TaskModel.getReference().saveProject(project);
        }
    }

    @Override
    public void onClick() {
        if (this.bean instanceof Appointment) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(this.date);
            AppointmentListView ag = new AppointmentListView(cal.get(1), cal.get(2), cal.get(5));
            ag.showView();
            ag.showApp(((Appointment)this.bean).getKey());
        } else if (this.bean instanceof Project) {
            MultiView.getMainView().setView(MultiView.ViewType.TASK);
            new ProjectView((Project)this.bean, ProjectView.Action.CHANGE, null).showView();
        } else {
            if (this.bean instanceof Task) {
                try {
                    MultiView.getMainView().setView(MultiView.ViewType.TASK);
                    new TaskView((Task)this.bean, TaskView.Action.CHANGE, null).showView();
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                    return;
                }
            }
            if (this.bean instanceof Subtask) {
                MultiView.getMainView().setView(MultiView.ViewType.TASK);
                int taskid = ((Subtask)this.bean).getTask();
                try {
                    Task t = TaskModel.getReference().getTask(taskid);
                    new TaskView(t, TaskView.Action.CHANGE, null).showView();
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                    return;
                }
            }
        }
    }

    @Override
    public String getToolTipText() {
        return this.getText();
    }
}

