/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.link;

import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.Resource;
import net.sf.borg.model.AddressModel;
import net.sf.borg.model.AppointmentModel;
import net.sf.borg.model.LinkModel;
import net.sf.borg.model.Model;
import net.sf.borg.model.TaskModel;
import net.sf.borg.model.entity.Address;
import net.sf.borg.model.entity.Appointment;
import net.sf.borg.model.entity.KeyedEntity;
import net.sf.borg.model.entity.Link;
import net.sf.borg.model.entity.Memo;
import net.sf.borg.model.entity.Project;
import net.sf.borg.model.entity.Task;
import net.sf.borg.ui.EntitySelector;
import net.sf.borg.ui.MultiView;
import net.sf.borg.ui.address.AddressView;
import net.sf.borg.ui.calendar.AppointmentListView;
import net.sf.borg.ui.memo.MemoPanel;
import net.sf.borg.ui.task.ProjectView;
import net.sf.borg.ui.task.TaskView;
import net.sf.borg.ui.util.GridBagConstraintsFactory;
import net.sf.borg.ui.util.PopupMenuHelper;
import net.sf.borg.ui.util.TableSorter;

public class LinkPanel
extends JPanel
implements Model.Listener {
    private static final long serialVersionUID = 1L;
    private KeyedEntity<?> owningEntity;
    private JTable linkTable = new JTable();
    private JScrollPane scrollPanel = new JScrollPane();

    public static String getName(Link at) throws Exception {
        if (at.getLinkType().equals(LinkModel.LinkType.URL.toString())) {
            return at.getPath();
        }
        if (at.getLinkType().equals(LinkModel.LinkType.APPOINTMENT.toString())) {
            Appointment ap = AppointmentModel.getReference().getAppt(Integer.parseInt(at.getPath()));
            if (ap != null) {
                return Resource.getResourceString("appointment") + "[" + ap.getClearText() + "]";
            }
        } else if (at.getLinkType().equals(LinkModel.LinkType.PROJECT.toString())) {
            Project ap = TaskModel.getReference().getProject(Integer.parseInt(at.getPath()));
            if (ap != null) {
                return Resource.getResourceString("project") + "[" + ap.getDescription() + "]";
            }
        } else if (at.getLinkType().equals(LinkModel.LinkType.TASK.toString())) {
            Task ap = TaskModel.getReference().getTask(Integer.parseInt(at.getPath()));
            if (ap != null) {
                return Resource.getResourceString("task") + "[" + ap.getSummary() + "]";
            }
        } else if (at.getLinkType().equals(LinkModel.LinkType.ADDRESS.toString())) {
            Address ap = AddressModel.getReference().getAddress(Integer.parseInt(at.getPath()));
            if (ap != null) {
                return Resource.getResourceString("Address") + "[" + ap.getLastName() + "," + ap.getFirstName() + "]";
            }
        } else {
            if (at.getLinkType().equals(LinkModel.LinkType.MEMO.toString())) {
                return Resource.getResourceString("memo") + "[" + at.getPath() + "]";
            }
            if (at.getLinkType().equals(LinkModel.LinkType.FILELINK.toString())) {
                File f = new File(at.getPath());
                return f.getName();
            }
            if (at.getLinkType().equals(LinkModel.LinkType.ATTACHMENT.toString())) {
                return at.getPath();
            }
        }
        return "error";
    }

    public LinkPanel() {
        this.initComponents();
        LinkModel.getReference().addListener((Model.Listener)this);
    }

    public boolean hasLinks() {
        try {
            Collection atts = LinkModel.getReference().getLinks(this.owningEntity);
            if (!atts.isEmpty()) {
                return true;
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        return false;
    }

    public void initComponents() {
        this.setLayout(new GridBagLayout());
        this.linkTable.setSelectionMode(2);
        this.linkTable.setModel(new TableSorter(new String[]{"", "Key"}, new Class[]{String.class, Integer.class}));
        TableSorter tm = (TableSorter)this.linkTable.getModel();
        tm.addMouseListenerToHeaderInTable(this.linkTable);
        this.linkTable.getColumnModel().getColumn(0).setPreferredWidth(125);
        this.linkTable.getColumnModel().getColumn(1).setPreferredWidth(75);
        this.linkTable.setPreferredScrollableViewportSize(new Dimension(150, 100));
        this.linkTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() < 2) {
                    return;
                }
                LinkPanel.this.openSelected();
            }
        });
        new PopupMenuHelper(this.linkTable, new PopupMenuHelper.Entry[]{new PopupMenuHelper.Entry(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LinkPanel.this.openSelected();
            }
        }, "Open"), new PopupMenuHelper.Entry(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableSorter ts = (TableSorter)LinkPanel.this.linkTable.getModel();
                int[] indices = LinkPanel.this.linkTable.getSelectedRows();
                ArrayList<Integer> keys = new ArrayList<Integer>();
                for (int i = 0; i < indices.length; ++i) {
                    int index = indices[i];
                    Integer key = (Integer)ts.getValueAt(index, 1);
                    keys.add(key);
                }
                for (Integer key : keys) {
                    try {
                        LinkModel.getReference().delete(key.intValue());
                    }
                    catch (Exception e) {
                        Errmsg.getErrorHandler().errmsg(e);
                    }
                }
            }
        }, "Delete"), new PopupMenuHelper.Entry(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableSorter ts = (TableSorter)LinkPanel.this.linkTable.getModel();
                int[] indices = LinkPanel.this.linkTable.getSelectedRows();
                for (int i = 0; i < indices.length; ++i) {
                    int index = indices[i];
                    try {
                        Integer key = (Integer)ts.getValueAt(index, 1);
                        Link l = LinkModel.getReference().getLink(key.intValue());
                        String info = Resource.getResourceString("Type") + ":" + l.getLinkType() + "\n\n[" + l.getPath() + "]";
                        Errmsg.getErrorHandler().notice(info);
                        continue;
                    }
                    catch (Exception e) {
                        Errmsg.getErrorHandler().errmsg(e);
                    }
                }
            }
        }, "Properties")});
        TableColumnModel tcm = this.linkTable.getColumnModel();
        TableColumn column = tcm.getColumn(1);
        tcm.removeColumn(column);
        this.scrollPanel.setViewportView(this.linkTable);
        this.add((Component)this.scrollPanel, GridBagConstraintsFactory.create(0, 0, 1, 1.0, 1.0));
        JButton linkFilebutton = new JButton(Resource.getResourceString("link_file"));
        linkFilebutton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Add16.gif")));
        linkFilebutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (LinkPanel.this.owningEntity == null || LinkPanel.this.owningEntity.getKey() == -1) {
                    Errmsg.getErrorHandler().notice(Resource.getResourceString("att_owner_null"));
                    return;
                }
                JFileChooser chooser = new JFileChooser();
                chooser.setCurrentDirectory(new File("."));
                chooser.setDialogTitle(Resource.getResourceString("choose_file"));
                chooser.setFileSelectionMode(0);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal != 0) {
                    return;
                }
                String s = chooser.getSelectedFile().getAbsolutePath();
                File file = new File(s);
                try {
                    LinkModel.getReference().addLink(LinkPanel.this.owningEntity, file.getAbsolutePath(), LinkModel.LinkType.FILELINK);
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                }
            }
        });
        JButton attachFileButton = new JButton(Resource.getResourceString("attach_file"));
        attachFileButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Copy16.gif")));
        attachFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (LinkPanel.this.owningEntity == null || LinkPanel.this.owningEntity.getKey() == -1) {
                    Errmsg.getErrorHandler().notice(Resource.getResourceString("att_owner_null"));
                    return;
                }
                JFileChooser chooser = new JFileChooser();
                chooser.setCurrentDirectory(new File("."));
                chooser.setDialogTitle(Resource.getResourceString("choose_file"));
                chooser.setFileSelectionMode(0);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal != 0) {
                    return;
                }
                String s = chooser.getSelectedFile().getAbsolutePath();
                File file = new File(s);
                try {
                    LinkModel.getReference().addLink(LinkPanel.this.owningEntity, file.getAbsolutePath(), LinkModel.LinkType.ATTACHMENT);
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                }
            }
        });
        JButton urlLinkButton = new JButton(Resource.getResourceString("url"));
        urlLinkButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/WebComponent16.gif")));
        urlLinkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (LinkPanel.this.owningEntity == null || LinkPanel.this.owningEntity.getKey() == -1) {
                    Errmsg.getErrorHandler().notice(Resource.getResourceString("att_owner_null"));
                    return;
                }
                String url = JOptionPane.showInputDialog(Resource.getResourceString("url") + "?");
                if (url == null) {
                    return;
                }
                if (url.trim().isEmpty()) {
                    Errmsg.getErrorHandler().notice(Resource.getResourceString("URL_is_Empty"));
                    return;
                }
                try {
                    LinkModel.getReference().addLink(LinkPanel.this.owningEntity, url, LinkModel.LinkType.URL);
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                }
            }
        });
        JButton entityLinkbutton = new JButton("BORG");
        entityLinkbutton.setIcon(new ImageIcon(this.getClass().getResource("/resource/borg16.jpg")));
        entityLinkbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (LinkPanel.this.owningEntity == null || LinkPanel.this.owningEntity.getKey() == -1) {
                    Errmsg.getErrorHandler().notice(Resource.getResourceString("att_owner_null"));
                    return;
                }
                Object[] possibleValues = new Object[]{Resource.getResourceString("appointment"), Resource.getResourceString("task"), Resource.getResourceString("memo"), Resource.getResourceString("Address"), Resource.getResourceString("project")};
                String selectedValue = (String)JOptionPane.showInputDialog(null, Resource.getResourceString("select_link_type"), "BORG", 1, null, possibleValues, possibleValues[0]);
                if (selectedValue == null) {
                    return;
                }
                try {
                    Memo ap;
                    if (selectedValue.equals(Resource.getResourceString("appointment"))) {
                        Appointment ap2;
                        ArrayList<Appointment> exclude = new ArrayList<Appointment>();
                        if (LinkPanel.this.owningEntity instanceof Appointment) {
                            exclude.add((Appointment)LinkPanel.this.owningEntity);
                        }
                        if ((ap2 = EntitySelector.selectAppointment(exclude)) != null) {
                            LinkModel.getReference().addLink(LinkPanel.this.owningEntity, Integer.toString(ap2.getKey()), LinkModel.LinkType.APPOINTMENT);
                        }
                    } else if (selectedValue.equals(Resource.getResourceString("project"))) {
                        Project ap3 = EntitySelector.selectProject();
                        if (ap3 != null) {
                            LinkModel.getReference().addLink(LinkPanel.this.owningEntity, Integer.toString(ap3.getKey()), LinkModel.LinkType.PROJECT);
                        }
                    } else if (selectedValue.equals(Resource.getResourceString("task"))) {
                        Task ap4 = EntitySelector.selectTask();
                        if (ap4 != null) {
                            LinkModel.getReference().addLink(LinkPanel.this.owningEntity, Integer.toString(ap4.getKey()), LinkModel.LinkType.TASK);
                        }
                    } else if (selectedValue.equals(Resource.getResourceString("Address"))) {
                        Address ap5 = EntitySelector.selectAddress();
                        if (ap5 != null) {
                            LinkModel.getReference().addLink(LinkPanel.this.owningEntity, Integer.toString(ap5.getKey()), LinkModel.LinkType.ADDRESS);
                        }
                    } else if (selectedValue.equals(Resource.getResourceString("memo")) && (ap = EntitySelector.selectMemo()) != null) {
                        LinkModel.getReference().addLink(LinkPanel.this.owningEntity, ap.getMemoName(), LinkModel.LinkType.MEMO);
                    }
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                }
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(linkFilebutton);
        buttonPanel.add(attachFileButton);
        buttonPanel.add(urlLinkButton);
        buttonPanel.add(entityLinkbutton);
        this.add((Component)buttonPanel, GridBagConstraintsFactory.create(0, 1, 0, 1.0, 1.0));
        if (LinkModel.attachmentFolder() == null) {
            attachFileButton.setEnabled(false);
        }
    }

    public void openSelected() {
        TableSorter ts = (TableSorter)this.linkTable.getModel();
        int[] indices = this.linkTable.getSelectedRows();
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            try {
                Component c;
                Appointment ap;
                File file;
                Integer key = (Integer)ts.getValueAt(index, 1);
                Link at = LinkModel.getReference().getLink(key.intValue());
                if (at.getLinkType().equals(LinkModel.LinkType.FILELINK.toString())) {
                    file = new File(at.getPath());
                    if (!file.exists()) {
                        Errmsg.getErrorHandler().notice(Resource.getResourceString("att_not_found"));
                        return;
                    }
                    if (!Desktop.isDesktopSupported()) {
                        return;
                    }
                    Desktop.getDesktop().open(file);
                    continue;
                }
                if (at.getLinkType().equals(LinkModel.LinkType.ATTACHMENT.toString())) {
                    file = new File(LinkModel.attachmentFolder() + "/" + at.getPath());
                    if (!file.exists()) {
                        Errmsg.getErrorHandler().notice(Resource.getResourceString("att_not_found"));
                        return;
                    }
                    if (!Desktop.isDesktopSupported()) {
                        return;
                    }
                    Desktop.getDesktop().open(file);
                    continue;
                }
                if (at.getLinkType().equals(LinkModel.LinkType.URL.toString())) {
                    if (!Desktop.isDesktopSupported()) {
                        return;
                    }
                    Desktop.getDesktop().browse(new URI(at.getPath()));
                    continue;
                }
                if (at.getLinkType().equals(LinkModel.LinkType.APPOINTMENT.toString())) {
                    ap = AppointmentModel.getReference().getAppt(Integer.parseInt(at.getPath()));
                    if (ap == null) {
                        Errmsg.getErrorHandler().notice(Resource.getResourceString("att_not_found"));
                        return;
                    }
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTime(ap.getDate());
                    AppointmentListView ag = new AppointmentListView(cal.get(1), cal.get(2), cal.get(5));
                    ag.showView();
                    ag.showApp(ap.getKey());
                    continue;
                }
                if (at.getLinkType().equals(LinkModel.LinkType.PROJECT.toString())) {
                    ap = TaskModel.getReference().getProject(Integer.parseInt(at.getPath()));
                    if (ap == null) {
                        Errmsg.getErrorHandler().notice(Resource.getResourceString("att_not_found"));
                        return;
                    }
                    new ProjectView((Project)ap, ProjectView.Action.CHANGE, null).showView();
                    continue;
                }
                if (at.getLinkType().equals(LinkModel.LinkType.TASK.toString())) {
                    ap = TaskModel.getReference().getTask(Integer.parseInt(at.getPath()));
                    if (ap == null) {
                        Errmsg.getErrorHandler().notice(Resource.getResourceString("att_not_found"));
                        return;
                    }
                    new TaskView((Task)ap, TaskView.Action.CHANGE, null).showView();
                    continue;
                }
                if (at.getLinkType().equals(LinkModel.LinkType.ADDRESS.toString())) {
                    ap = AddressModel.getReference().getAddress(Integer.parseInt(at.getPath()));
                    if (ap == null) {
                        Errmsg.getErrorHandler().notice(Resource.getResourceString("att_not_found"));
                        return;
                    }
                    new AddressView((Address)ap).showView();
                    continue;
                }
                if (!at.getLinkType().equals(LinkModel.LinkType.MEMO.toString()) || (c = MultiView.getMainView().setView(MultiView.ViewType.MEMO)) == null || !(c instanceof MemoPanel)) continue;
                MemoPanel mp = (MemoPanel)c;
                mp.selectMemo(at.getPath());
                continue;
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
            }
        }
    }

    public void update(Model.ChangeEvent event) {
        this.refresh();
    }

    public void refresh() {
        TableSorter tm = (TableSorter)this.linkTable.getModel();
        tm.setRowCount(0);
        try {
            Collection atts = LinkModel.getReference().getLinks(this.owningEntity);
            for (Link at : atts) {
                tm.addRow(new Object[]{LinkPanel.getName(at), new Integer(at.getKey())});
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        if (tm.getRowCount() > 0) {
            this.scrollPanel.setVisible(true);
        } else {
            this.scrollPanel.setVisible(false);
        }
        for (Container p = this.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof JFrame)) continue;
            ((JFrame)p).validate();
        }
    }

    public void setOwner(KeyedEntity<?> owner) {
        this.owningEntity = owner;
        this.refresh();
    }
}

