/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.ical.CalDav;
import net.sf.borg.model.ical.IcalFTP;
import net.sf.borg.ui.options.OptionsView;
import net.sf.borg.ui.util.GridBagConstraintsFactory;

public class IcalOptionsPanel
extends OptionsView.OptionsPanel {
    private static final long serialVersionUID = 795364188303457966L;
    private JTextField port = new JTextField();
    private JSpinner exportyears = new JSpinner(new SpinnerNumberModel(2, 1, 100, 1));
    private JCheckBox skipBox = new JCheckBox();
    private JTextField ftpserver = new JTextField();
    private JTextField ftppath = new JTextField();
    private JTextField ftpusername = new JTextField();
    private JPasswordField ftppassword = new JPasswordField();
    private JTextField importurl = new JTextField();
    private JCheckBox todoBox = new JCheckBox();
    private JTextField caldavServer = new JTextField();
    private JTextField caldavUser = new JTextField();
    private JPasswordField caldavPassword = new JPasswordField();
    private JTextField caldavCal = new JTextField();
    private JTextField caldavCal2 = new JTextField();

    public IcalOptionsPanel() {
        this.setLayout(new GridBagLayout());
        JPanel ftppanel = new JPanel();
        ftppanel.setBorder(new TitledBorder("FTP"));
        ftppanel.setLayout(new GridBagLayout());
        JPanel calpanel = new JPanel();
        calpanel.setBorder(new TitledBorder("CALDAV"));
        calpanel.setLayout(new GridBagLayout());
        this.add((Component)new JLabel(Resource.getResourceString("years_to_export")), GridBagConstraintsFactory.create(0, 0, 1));
        this.add((Component)this.exportyears, GridBagConstraintsFactory.create(1, 0, 1));
        this.add((Component)new JLabel(Resource.getResourceString("server_port")), GridBagConstraintsFactory.create(0, 1, 1));
        this.add((Component)this.port, GridBagConstraintsFactory.create(1, 1, 1, 1.0, 0.0));
        this.skipBox.setText(Resource.getResourceString("skip_borg_ical"));
        this.add((Component)this.skipBox, GridBagConstraintsFactory.create(0, 2, 1, 1.0, 0.0));
        this.add((Component)new JLabel(Resource.getResourceString("ical_import_url")), GridBagConstraintsFactory.create(0, 3, 1));
        this.add((Component)this.importurl, GridBagConstraintsFactory.create(1, 3, 1, 1.0, 0.0));
        this.todoBox.setText(Resource.getResourceString("ical_export_todos"));
        this.add((Component)this.todoBox, GridBagConstraintsFactory.create(0, 4, 1, 1.0, 0.0));
        ftppanel.add((Component)new JLabel(Resource.getResourceString("ftpserver")), GridBagConstraintsFactory.create(0, 3, 1));
        ftppanel.add((Component)this.ftpserver, GridBagConstraintsFactory.create(1, 3, 1, 1.0, 0.0));
        ftppanel.add((Component)new JLabel(Resource.getResourceString("ftppath")), GridBagConstraintsFactory.create(0, 4, 1));
        ftppanel.add((Component)this.ftppath, GridBagConstraintsFactory.create(1, 4, 1, 1.0, 0.0));
        ftppanel.add((Component)new JLabel(Resource.getResourceString("ftpusername")), GridBagConstraintsFactory.create(0, 5, 1));
        ftppanel.add((Component)this.ftpusername, GridBagConstraintsFactory.create(1, 5, 1, 1.0, 0.0));
        JLabel pl = new JLabel(Resource.getResourceString("ftppassword"));
        ftppanel.add((Component)pl, GridBagConstraintsFactory.create(0, 6, 1));
        pl.setLabelFor(this.ftppassword);
        ftppanel.add((Component)this.ftppassword, GridBagConstraintsFactory.create(1, 6, 1, 1.0, 0.0));
        this.ftppassword.setEditable(true);
        GridBagConstraints gbc = GridBagConstraintsFactory.create(0, 5, 1, 1.0, 0.0);
        gbc.gridwidth = 0;
        this.add((Component)ftppanel, gbc);
        calpanel.add((Component)new JLabel(Resource.getResourceString("CALDAV_Server")), GridBagConstraintsFactory.create(0, 9, 1));
        calpanel.add((Component)this.caldavServer, GridBagConstraintsFactory.create(1, 9, 1, 1.0, 0.0));
        calpanel.add((Component)new JLabel(Resource.getResourceString("CALDAV_User")), GridBagConstraintsFactory.create(0, 10, 1));
        calpanel.add((Component)this.caldavUser, GridBagConstraintsFactory.create(1, 10, 1, 1.0, 0.0));
        JLabel pl2 = new JLabel(Resource.getResourceString("CALDAV_Password"));
        calpanel.add((Component)pl2, GridBagConstraintsFactory.create(0, 11, 1));
        pl2.setLabelFor(this.caldavPassword);
        calpanel.add((Component)this.caldavPassword, GridBagConstraintsFactory.create(1, 11, 1, 1.0, 0.0));
        this.caldavPassword.setEditable(true);
        calpanel.add((Component)new JLabel(Resource.getResourceString("CALDAV_Cal")), GridBagConstraintsFactory.create(0, 12, 1));
        calpanel.add((Component)this.caldavCal, GridBagConstraintsFactory.create(1, 12, 1, 1.0, 0.0));
        calpanel.add((Component)new JLabel(Resource.getResourceString("CALDAV_Cal2")), GridBagConstraintsFactory.create(0, 13, 1));
        calpanel.add((Component)this.caldavCal2, GridBagConstraintsFactory.create(1, 13, 1, 1.0, 0.0));
        gbc = GridBagConstraintsFactory.create(0, 6, 1, 1.0, 0.0);
        gbc.gridwidth = 0;
        this.add((Component)calpanel, gbc);
    }

    @Override
    public void applyChanges() {
        try {
            int socket = Integer.parseInt(this.port.getText());
            Prefs.putPref(PrefName.ICAL_PORT, new Integer(socket));
        }
        catch (NumberFormatException e) {
            Errmsg.getErrorHandler().notice(Resource.getResourceString("port_warning"));
            this.port.setText(((Integer)PrefName.ICAL_PORT.getDefault()).toString());
            Prefs.putPref(PrefName.ICAL_PORT, PrefName.ICAL_PORT.getDefault());
            return;
        }
        Prefs.putPref(PrefName.FTPUSER, this.ftpusername.getText());
        Prefs.putPref(PrefName.FTPSERVER, this.ftpserver.getText());
        Prefs.putPref(PrefName.FTPPATH, this.ftppath.getText());
        try {
            IcalFTP.sep((String)new String(this.ftppassword.getPassword()));
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        Prefs.putPref(PrefName.ICAL_EXPORTYEARS, this.exportyears.getValue());
        OptionsView.OptionsPanel.setBooleanPref(this.skipBox, PrefName.SKIP_BORG);
        OptionsView.OptionsPanel.setBooleanPref(this.todoBox, PrefName.ICAL_EXPORT_TODO);
        Prefs.putPref(PrefName.ICAL_IMPORT_URL, this.importurl.getText());
        Prefs.putPref(PrefName.CALDAV_USER, this.caldavUser.getText());
        Prefs.putPref(PrefName.CALDAV_SERVER, this.caldavServer.getText());
        try {
            CalDav.sep((String)new String(this.caldavPassword.getPassword()));
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        Prefs.putPref(PrefName.CALDAV_CAL, this.caldavCal.getText());
        Prefs.putPref(PrefName.CALDAV_CAL2, this.caldavCal2.getText());
    }

    @Override
    public void loadOptions() {
        int p = Prefs.getIntPref(PrefName.ICAL_PORT);
        this.port.setText(Integer.toString(p));
        this.exportyears.setValue(Prefs.getIntPref(PrefName.ICAL_EXPORTYEARS));
        this.skipBox.setSelected(Prefs.getBoolPref(PrefName.SKIP_BORG));
        this.todoBox.setSelected(Prefs.getBoolPref(PrefName.ICAL_EXPORT_TODO));
        this.ftpusername.setText(Prefs.getPref(PrefName.FTPUSER));
        this.ftpserver.setText(Prefs.getPref(PrefName.FTPSERVER));
        this.ftppath.setText(Prefs.getPref(PrefName.FTPPATH));
        try {
            this.ftppassword.setText(IcalFTP.gep());
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        this.importurl.setText(Prefs.getPref(PrefName.ICAL_IMPORT_URL));
        this.caldavUser.setText(Prefs.getPref(PrefName.CALDAV_USER));
        this.caldavCal.setText(Prefs.getPref(PrefName.CALDAV_CAL));
        this.caldavCal2.setText(Prefs.getPref(PrefName.CALDAV_CAL2));
        this.caldavServer.setText(Prefs.getPref(PrefName.CALDAV_SERVER));
        try {
            this.caldavPassword.setText(CalDav.gep());
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    @Override
    public String getPanelName() {
        return Resource.getResourceString("ical_options");
    }

    public static void main(String[] args) {
        JFrame jf = new JFrame();
        jf.setContentPane(new IcalOptionsPanel());
        jf.setVisible(true);
    }
}

