/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.options;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.Model;
import net.sf.borg.ui.ResourceHelper;
import net.sf.borg.ui.SunTrayIconProxy;
import net.sf.borg.ui.View;
import net.sf.borg.ui.options.AddressOptionsPanel;
import net.sf.borg.ui.options.AppearanceOptionsPanel;
import net.sf.borg.ui.options.ColorOptionsPanel;
import net.sf.borg.ui.options.DatabaseOptionsPanel;
import net.sf.borg.ui.options.EmailOptionsPanel;
import net.sf.borg.ui.options.EncryptionOptionsPanel;
import net.sf.borg.ui.options.FontOptionsPanel;
import net.sf.borg.ui.options.MiscellaneousOptionsPanel;
import net.sf.borg.ui.options.PopupOptionsPanel;
import net.sf.borg.ui.options.StartupViewsOptionsPanel;
import net.sf.borg.ui.options.TaskOptionsPanel;
import net.sf.borg.ui.options.TodoOptionsPanel;
import net.sf.borg.ui.util.GridBagConstraintsFactory;

public class OptionsView
extends View {
    private static PrefName OPTVIEWSIZE = new PrefName("optviewsize", "-1,-1,-1,-1,N");
    private static final long serialVersionUID = 1L;
    private static OptionsView singleton = null;
    private JButton applyButton;
    private JButton dismissButton;
    private JTabbedPane jTabbedPane1;
    private JPanel topPanel = null;
    private Collection<OptionsPanel> panels = new ArrayList<OptionsPanel>();

    public static void dbSelectOnly() {
        singleton = new OptionsView(true);
        singleton.setVisible(true);
    }

    public static OptionsView getReference() {
        if (singleton == null) {
            singleton = new OptionsView(false);
        } else if (!singleton.isShowing()) {
            for (int t = 0; t < OptionsView.singleton.jTabbedPane1.getTabCount(); ++t) {
                OptionsPanel panel = (OptionsPanel)OptionsView.singleton.jTabbedPane1.getComponentAt(t);
                panel.loadOptions();
            }
        }
        return singleton;
    }

    private OptionsView(boolean dbonly) {
        this.jTabbedPane1 = new JTabbedPane();
        this.setDefaultCloseOperation(2);
        this.setTitle(Resource.getResourceString("Options"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                OptionsView.this.destroy();
            }
        });
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new GridBagLayout());
        this.topPanel.add((Component)this.jTabbedPane1, GridBagConstraintsFactory.create(0, 0, 1, 1.0, 1.0));
        if (!dbonly) {
            this.dismissButton = new JButton();
            this.applyButton = new JButton();
            JPanel applyDismissPanel = new JPanel();
            this.applyButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Save16.gif")));
            ResourceHelper.setText(this.applyButton, "apply");
            this.applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    OptionsView.this.applyChanges();
                }
            });
            applyDismissPanel.add((Component)this.applyButton, null);
            this.dismissButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Stop16.gif")));
            ResourceHelper.setText(this.dismissButton, "Dismiss");
            this.dismissButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    OptionsView.this.destroy();
                }
            });
            this.setDismissButton(this.dismissButton);
            applyDismissPanel.add((Component)this.dismissButton, null);
            this.topPanel.add((Component)applyDismissPanel, GridBagConstraintsFactory.create(0, 1, 1));
            this.addPanel(new AppearanceOptionsPanel());
            this.addPanel(new FontOptionsPanel());
            this.addPanel(new EmailOptionsPanel());
            this.addPanel(new PopupOptionsPanel());
            this.addPanel(new MiscellaneousOptionsPanel());
            this.addPanel(new ColorOptionsPanel());
            this.addPanel(new TaskOptionsPanel());
            this.addPanel(new TodoOptionsPanel());
            this.addPanel(new EncryptionOptionsPanel());
            this.addPanel(new StartupViewsOptionsPanel());
            this.addPanel(new AddressOptionsPanel());
        }
        this.addPanel(new DatabaseOptionsPanel());
        JScrollPane sp = new JScrollPane();
        sp.setViewportView(this.topPanel);
        this.setContentPane(sp);
        this.setSize(629, 493);
        this.pack();
        if (!dbonly) {
            this.manageMySize(OPTVIEWSIZE);
        }
    }

    private void applyChanges() {
        for (OptionsPanel panel : this.panels) {
            panel.applyChanges();
        }
        Prefs.notifyListeners();
        if (SunTrayIconProxy.hasTrayIcon()) {
            SunTrayIconProxy.getReference().updateImage();
        }
    }

    @Override
    public void destroy() {
        this.dispose();
    }

    @Override
    public void refresh() {
    }

    public void update(Model.ChangeEvent event) {
        this.refresh();
    }

    public void addPanel(OptionsPanel panel) {
        panel.loadOptions();
        this.jTabbedPane1.addTab(panel.getPanelName(), panel);
        this.panels.add(panel);
    }

    public static abstract class OptionsPanel
    extends JPanel {
        private static final long serialVersionUID = -4942616624428977307L;

        public static void setBooleanPref(JCheckBox box, PrefName pn) {
            if (box.isSelected()) {
                Prefs.putPref(pn, "true");
            } else {
                Prefs.putPref(pn, "false");
            }
        }

        public static void setCheckBox(JCheckBox box, PrefName pn) {
            String val = Prefs.getPref(pn);
            if (val.equals("true")) {
                box.setSelected(true);
            } else {
                box.setSelected(false);
            }
        }

        public abstract String getPanelName();

        public abstract void applyChanges();

        public abstract void loadOptions();

        static String chooseDir() {
            String path = null;
            while (true) {
                JFileChooser chooser = new JFileChooser();
                chooser.setCurrentDirectory(new File("."));
                chooser.setDialogTitle("Please choose directory for database files");
                chooser.setFileSelectionMode(1);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal != 0) {
                    return null;
                }
                path = chooser.getSelectedFile().getAbsolutePath();
                File dir = new File(path);
                String err = null;
                if (!dir.exists()) {
                    err = "Directory [" + path + "] does not exist";
                } else if (!dir.isDirectory()) {
                    err = "Directory [" + path + "] is not a directory";
                }
                if (err == null) break;
                Errmsg.getErrorHandler().notice(err);
            }
            return path;
        }
    }
}

