/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.options;

import java.awt.GridLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.ui.MultiView;
import net.sf.borg.ui.options.OptionsView;

public class StartupViewsOptionsPanel
extends OptionsView.OptionsPanel {
    private static final long serialVersionUID = -4357089819869820396L;
    private HashMap<MultiView.ViewType, JCheckBox> boxMap = new HashMap();

    private static PrefName getPrefForView(MultiView.ViewType vt) {
        String def = "false";
        if (vt == MultiView.ViewType.MONTH) {
            def = "true";
        }
        return new PrefName("startview_" + vt.toString(), def);
    }

    public static boolean getStartPref(MultiView.ViewType vt) {
        return Prefs.getBoolPref(StartupViewsOptionsPanel.getPrefForView(vt));
    }

    public static void setStartPref(MultiView.ViewType vt, boolean start) {
        Prefs.putPref(StartupViewsOptionsPanel.getPrefForView(vt), start ? "true" : "false");
    }

    public StartupViewsOptionsPanel() {
        this.setLayout(new GridLayout(0, 2));
        for (MultiView.ViewType vt : MultiView.ViewType.values()) {
            MultiView.Module m = MultiView.getMainView().getModuleForView(vt);
            if (m == null) continue;
            JCheckBox cb = new JCheckBox(m.getModuleName());
            this.boxMap.put(vt, cb);
            this.add(cb);
        }
    }

    @Override
    public void applyChanges() {
        for (Map.Entry<MultiView.ViewType, JCheckBox> e : this.boxMap.entrySet()) {
            StartupViewsOptionsPanel.setStartPref(e.getKey(), e.getValue().isSelected());
        }
    }

    @Override
    public String getPanelName() {
        return Resource.getResourceString("startupViews");
    }

    @Override
    public void loadOptions() {
        for (Map.Entry<MultiView.ViewType, JCheckBox> e : this.boxMap.entrySet()) {
            boolean start = StartupViewsOptionsPanel.getStartPref(e.getKey());
            e.getValue().setSelected(start);
        }
    }
}

