/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.ui.options.OptionsView;
import net.sf.borg.ui.util.GridBagConstraintsFactory;

public class TaskOptionsPanel
extends OptionsView.OptionsPanel {
    private static final long serialVersionUID = 1192889023921958906L;
    private JCheckBox calShowSubtaskBox = new JCheckBox();
    private JCheckBox calShowTaskBox = new JCheckBox();
    private JCheckBox taskAbbrevBox = new JCheckBox();
    private JCheckBox taskTreeStatusBox = new JCheckBox();
    private JSpinner redSpinner = new JSpinner(new SpinnerNumberModel());
    private JSpinner orangeSpinner = new JSpinner(new SpinnerNumberModel());
    private JSpinner yellowSpinner = new JSpinner(new SpinnerNumberModel());
    private final ImageIcon redIcon = new ImageIcon(this.getClass().getResource("/resource/red.png"));
    private final ImageIcon orangeIcon = new ImageIcon(this.getClass().getResource("/resource/orange.png"));
    private final ImageIcon yellowIcon = new ImageIcon(this.getClass().getResource("/resource/yellow.png"));

    public TaskOptionsPanel() {
        this.calShowSubtaskBox.setName("calShowSubtaskBox");
        this.calShowSubtaskBox.setHorizontalAlignment(2);
        this.calShowTaskBox.setName("calShowTaskBox");
        this.calShowTaskBox.setHorizontalAlignment(2);
        this.taskAbbrevBox.setName("taskAbbrevBox");
        this.taskAbbrevBox.setHorizontalAlignment(2);
        this.taskTreeStatusBox.setName("taskTreeStatusBox");
        this.taskTreeStatusBox.setHorizontalAlignment(2);
        GridBagConstraints gridBagConstraints = GridBagConstraintsFactory.create(0, -1, 0);
        gridBagConstraints.anchor = 17;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.taskAbbrevBox, gridBagConstraints);
        this.add((Component)this.calShowTaskBox, gridBagConstraints);
        this.add((Component)this.calShowSubtaskBox, gridBagConstraints);
        this.add((Component)this.taskTreeStatusBox, gridBagConstraints);
        this.taskAbbrevBox.setText(Resource.getResourceString("task_abbrev"));
        this.calShowTaskBox.setText(Resource.getResourceString("calShowTask"));
        this.calShowSubtaskBox.setText(Resource.getResourceString("calShowSubtask"));
        this.taskTreeStatusBox.setText(Resource.getResourceString("show_task_status_in_tree"));
        JPanel spinnerPanel = new JPanel();
        spinnerPanel.setBorder(new TitledBorder(Resource.getResourceString("DaysLeftColors")));
        spinnerPanel.setLayout(new GridLayout(4, 2));
        spinnerPanel.add(new JLabel(this.redIcon));
        spinnerPanel.add(this.redSpinner);
        spinnerPanel.add(new JLabel(this.orangeIcon));
        spinnerPanel.add(this.orangeSpinner);
        spinnerPanel.add(new JLabel(this.yellowIcon));
        spinnerPanel.add(this.yellowSpinner);
        this.add((Component)spinnerPanel, GridBagConstraintsFactory.create(0, -1, 2));
    }

    @Override
    public void applyChanges() {
        OptionsView.OptionsPanel.setBooleanPref(this.taskAbbrevBox, PrefName.TASK_SHOW_ABBREV);
        OptionsView.OptionsPanel.setBooleanPref(this.calShowTaskBox, PrefName.CAL_SHOW_TASKS);
        OptionsView.OptionsPanel.setBooleanPref(this.calShowSubtaskBox, PrefName.CAL_SHOW_SUBTASKS);
        OptionsView.OptionsPanel.setBooleanPref(this.taskTreeStatusBox, PrefName.TASK_TREE_SHOW_STATUS);
        Prefs.putPref(PrefName.RED_DAYS, this.redSpinner.getValue());
        Prefs.putPref(PrefName.ORANGE_DAYS, this.orangeSpinner.getValue());
        Prefs.putPref(PrefName.YELLOW_DAYS, this.yellowSpinner.getValue());
    }

    @Override
    public void loadOptions() {
        OptionsView.OptionsPanel.setCheckBox(this.taskAbbrevBox, PrefName.TASK_SHOW_ABBREV);
        OptionsView.OptionsPanel.setCheckBox(this.calShowTaskBox, PrefName.CAL_SHOW_TASKS);
        OptionsView.OptionsPanel.setCheckBox(this.calShowSubtaskBox, PrefName.CAL_SHOW_SUBTASKS);
        OptionsView.OptionsPanel.setCheckBox(this.taskTreeStatusBox, PrefName.TASK_TREE_SHOW_STATUS);
        this.redSpinner.setValue(Prefs.getIntPref(PrefName.RED_DAYS));
        this.orangeSpinner.setValue(Prefs.getIntPref(PrefName.ORANGE_DAYS));
        this.yellowSpinner.setValue(Prefs.getIntPref(PrefName.YELLOW_DAYS));
    }

    @Override
    public String getPanelName() {
        return Resource.getResourceString("taskOptions");
    }
}

