/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.popup;

import java.util.Date;
import java.util.GregorianCalendar;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.AddressModel;
import net.sf.borg.model.entity.Address;
import net.sf.borg.ui.popup.ReminderInstance;

public class BirthdayReminderInstance
extends ReminderInstance {
    private Address addr;

    public BirthdayReminderInstance(Address addr, Date instanceTime) {
        this.addr = addr;
        this.setInstanceTime(instanceTime);
    }

    @Override
    public void do_todo(boolean delete) {
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BirthdayReminderInstance other = (BirthdayReminderInstance)obj;
        if (this.addr == null ? other.addr != null : this.addr.getKey() != other.addr.getKey()) {
            return false;
        }
        return !(this.getInstanceTime() == null ? other.getInstanceTime() != null : !this.getInstanceTime().equals(other.getInstanceTime()));
    }

    @Override
    public int getCurrentReminder() {
        return -1;
    }

    @Override
    public String getText() {
        GregorianCalendar inst = new GregorianCalendar();
        inst.setTime(this.getInstanceTime());
        Date bd = this.addr.getBirthday();
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(bd);
        int bdyear = g.get(1);
        int yrs = inst.get(1) - bdyear;
        String tx = Resource.getResourceString("Birthday") + ": " + this.addr.getFirstName() + " " + this.addr.getLastName() + "(" + yrs + ")";
        return tx;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.addr == null ? 0 : this.addr.getKey());
        result = 31 * result + (this.getInstanceTime() == null ? 0 : this.getInstanceTime().hashCode());
        return result;
    }

    @Override
    public String calculateToGoMessage() {
        return Resource.getResourceString("Birthday");
    }

    @Override
    public boolean isNote() {
        return true;
    }

    @Override
    public boolean isTodo() {
        return true;
    }

    @Override
    public boolean reloadAndCheckForChanges() {
        try {
            Address orig = this.addr;
            this.addr = AddressModel.getReference().getAddress(this.addr.getKey());
            if (this.addr == null) {
                return true;
            }
            if (this.addr.getBirthday() == null) {
                return true;
            }
            if (!this.addr.getBirthday().equals(orig.getBirthday())) {
                return true;
            }
        }
        catch (Exception e) {
            this.addr = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldBeShown() {
        if (this.addr == null || this.addr.getBirthday() == null) {
            return false;
        }
        long minutesToGo = this.getInstanceTime().getTime() / 60000L - new Date().getTime() / 60000L;
        if (minutesToGo < 0L) {
            return false;
        }
        int bd_days = Prefs.getIntPref(PrefName.BIRTHDAYREMINDERDAYS);
        return minutesToGo < (long)(++bd_days * 24 * 60);
    }
}

