/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.popup;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.Model;
import net.sf.borg.ui.ResourceHelper;
import net.sf.borg.ui.View;
import net.sf.borg.ui.popup.ReminderInstance;
import net.sf.borg.ui.popup.ReminderListManager;
import net.sf.borg.ui.popup.ReminderManager;
import net.sf.borg.ui.popup.ReminderSound;
import net.sf.borg.ui.util.GridBagConstraintsFactory;
import net.sf.borg.ui.util.TableSorter;

public class ReminderList
extends View {
    private static final long serialVersionUID = 1L;
    private static final PrefName REMINDERLISTSIZE = new PrefName("reminderlistsize", "-1,-1,-1,-1,N");
    private JPanel buttonPanel = new JPanel();
    private JTable reminderTable = new JTable();
    private static final int SELECT_COLUMN = 0;
    private static final int TEXT_COLUMN = 1;
    private static final int TOGO_MESSAGE_COLUMN = 2;
    private static final int REMINDER_INSTANCE_COLUMN = 3;
    private static final int TOGO_MINUTES_COLUMN = 4;

    public ReminderList() {
        this.initComponents();
        this.setTitle("Borg " + Resource.getResourceString("Reminder"));
        this.reminderTable.setModel(new TableSorter(new String[]{"", Resource.getResourceString("Reminder"), Resource.getResourceString("Due"), "inst", "mins"}, new Class[]{Boolean.class, String.class, String.class, ReminderInstance.class, Long.class}, new boolean[]{true, false, false, false, false}));
        this.reminderTable.removeColumn(this.reminderTable.getColumnModel().getColumn(3));
        this.reminderTable.removeColumn(this.reminderTable.getColumnModel().getColumn(3));
        this.reminderTable.getColumnModel().getColumn(0).setMaxWidth(30);
        this.reminderTable.getColumnModel().getColumn(0).setMinWidth(20);
        this.reminderTable.setDefaultRenderer(String.class, new MyTableCellRenderer());
        this.reminderTable.getTableHeader().setReorderingAllowed(false);
        this.pack();
        this.manageMySize(REMINDERLISTSIZE);
    }

    @Override
    public void destroy() {
        this.dispose();
    }

    private List<ReminderInstance> getSelectedReminders() {
        ArrayList<ReminderInstance> list = new ArrayList<ReminderInstance>();
        TableSorter tm = (TableSorter)this.reminderTable.getModel();
        for (int row = 0; row < tm.getRowCount(); ++row) {
            Boolean selected = (Boolean)tm.getValueAt(row, 0);
            if (!selected.booleanValue()) continue;
            list.add((ReminderInstance)tm.getValueAt(row, 3));
        }
        return list;
    }

    private void initComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.reminderTable = new JTable();
        this.buttonPanel = new JPanel();
        this.reminderTable.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.reminderTable.setRowSelectionAllowed(false);
        JScrollPane jScrollPane1 = new JScrollPane();
        jScrollPane1.setPreferredSize(new Dimension(554, 404));
        jScrollPane1.setViewportView(this.reminderTable);
        JButton hideButton = new JButton();
        hideButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Delete16.gif")));
        hideButton.setText(Resource.getResourceString("Hide"));
        hideButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                for (ReminderInstance inst : ReminderList.this.getSelectedReminders()) {
                    inst.setHidden(true);
                }
                ReminderList.this.refresh(true);
            }
        });
        this.buttonPanel.add(hideButton);
        JButton doneButton = new JButton();
        doneButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Undo16.gif")));
        ResourceHelper.setText(doneButton, "Done_(Delete)");
        doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                for (ReminderInstance inst : ReminderList.this.getSelectedReminders()) {
                    if (!inst.isTodo()) continue;
                    inst.do_todo(true);
                }
            }
        });
        this.buttonPanel.add(doneButton);
        JButton donendButton = new JButton();
        donendButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Undo16.gif")));
        ResourceHelper.setText(donendButton, "Done_(No_Delete)");
        donendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                for (ReminderInstance inst : ReminderList.this.getSelectedReminders()) {
                    if (!inst.isTodo()) continue;
                    inst.do_todo(false);
                }
            }
        });
        this.buttonPanel.add(donendButton);
        JButton resetButton = new JButton();
        resetButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Undo16.gif")));
        ResourceHelper.setText(resetButton, "Unhide_All");
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    ReminderListManager m = (ReminderListManager)ReminderListManager.getReference();
                    List<ReminderInstance> list = m.getReminders();
                    for (ReminderInstance inst : list) {
                        inst.setHidden(false);
                    }
                    ReminderList.this.refresh(true);
                    ReminderManager.getReminderManager().checkPopups();
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                }
            }
        });
        this.buttonPanel.add(resetButton);
        this.getContentPane().add((Component)jScrollPane1, GridBagConstraintsFactory.create(0, 0, 1, 1.0, 1.0));
        this.getContentPane().add((Component)this.buttonPanel, GridBagConstraintsFactory.create(0, 2));
    }

    @Override
    public void refresh() {
        this.refresh(false);
    }

    public void update(Model.ChangeEvent event) {
        this.refresh();
    }

    public void refresh(boolean silent) {
        ReminderListManager m = (ReminderListManager)ReminderListManager.getReference();
        List<ReminderInstance> list = m.getReminders();
        TableSorter tm = (TableSorter)this.reminderTable.getModel();
        tm.sortByColumn(4);
        tm.setRowCount(0);
        this.reminderTable.clearSelection();
        for (ReminderInstance inst : list) {
            String message;
            if (inst.isHidden() || (message = inst.calculateToGoMessage()) == null) continue;
            inst.setShown(true);
            Object[] row = new Object[]{Boolean.FALSE, inst, message, inst, inst.isNote() && inst.isTodo() ? new Long(inst.getInstanceTime().getTime()) : new Long(inst.minutesToGo())};
            tm.addRow(row);
            tm.tableChanged(new TableModelEvent(tm));
        }
        if (!silent) {
            this.setVisible(true);
            this.toFront();
            ReminderSound.playReminderSound(Prefs.getPref(PrefName.BEEPINGREMINDERS));
        }
    }

    public void updateTimes() {
        int selected = this.reminderTable.getSelectedRow();
        TableSorter tm = (TableSorter)this.reminderTable.getModel();
        for (int index = 0; index < tm.getRowCount(); ++index) {
            ReminderInstance inst;
            String message;
            Object o = tm.getValueAt(index, 3);
            if (o == null || !(o instanceof ReminderInstance) || (message = (inst = (ReminderInstance)o).calculateToGoMessage()) == null) continue;
            tm.setValueAt(message, index, 2);
        }
        if (selected != -1) {
            this.reminderTable.getSelectionModel().setSelectionInterval(selected, selected);
        }
    }

    private class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private MyTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            label.setIcon(null);
            if (column == 1) {
                ReminderInstance inst = (ReminderInstance)value;
                String tx = DateFormat.getDateInstance(3).format(inst.getInstanceTime());
                tx = tx + " " + inst.getText();
                label.setText(tx);
                if (inst.isTodo()) {
                    String iconname = Prefs.getPref(PrefName.UCS_MARKER);
                    String use_marker = Prefs.getPref(PrefName.UCS_MARKTODO);
                    if (use_marker.equals("true")) {
                        if (iconname.endsWith(".gif") || iconname.endsWith(".jpg")) {
                            ImageIcon todoIcon = new ImageIcon(this.getClass().getResource("/resource/" + iconname));
                            label.setIcon(todoIcon);
                        } else {
                            label.setText(iconname + " " + tx);
                        }
                    }
                }
            }
            return label;
        }
    }
}

