/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.popup;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.SwingUtilities;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.AddressModel;
import net.sf.borg.model.AppointmentModel;
import net.sf.borg.model.CategoryModel;
import net.sf.borg.model.Model;
import net.sf.borg.model.ReminderTimes;
import net.sf.borg.model.TaskModel;
import net.sf.borg.model.entity.Address;
import net.sf.borg.model.entity.Appointment;
import net.sf.borg.model.entity.Project;
import net.sf.borg.model.entity.Subtask;
import net.sf.borg.model.entity.Task;
import net.sf.borg.ui.popup.ApptReminderInstance;
import net.sf.borg.ui.popup.BirthdayReminderInstance;
import net.sf.borg.ui.popup.ProjectReminderInstance;
import net.sf.borg.ui.popup.ReminderInstance;
import net.sf.borg.ui.popup.SubtaskReminderInstance;
import net.sf.borg.ui.popup.TaskReminderInstance;

public abstract class ReminderManager
implements Model.Listener,
Prefs.Listener {
    protected static ReminderManager singleton = null;
    final Runnable doPopupChk = new Runnable(){

        @Override
        public void run() {
            ReminderManager.this.checkPopups();
        }
    };
    private Timer timer = null;

    public static ReminderManager getReminderManager() {
        return singleton;
    }

    protected ReminderManager() {
        AppointmentModel.getReference().addListener((Model.Listener)this);
        TaskModel.getReference().addListener((Model.Listener)this);
        AddressModel.getReference().addListener((Model.Listener)this);
        Prefs.addListener(this);
        this.timer = new Timer("PopupTimer");
        GregorianCalendar cur = new GregorianCalendar();
        int secs_left = 60 - cur.get(13);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(ReminderManager.this.doPopupChk);
            }
        }, secs_left * 1000, 60000L);
    }

    @Override
    public void prefsChanged() {
        this.refresh();
    }

    public abstract void addToUI(ReminderInstance var1);

    public void checkPopups() {
        ReminderInstance inst;
        int bd_days;
        String enable = Prefs.getPref(PrefName.REMINDERS);
        if (enable.equals("false")) {
            return;
        }
        int earliestReminderTime = -100000;
        for (int i = 0; i < ReminderTimes.getNum(); ++i) {
            int time = ReminderTimes.getTimes((int)i);
            if (time <= earliestReminderTime) continue;
            earliestReminderTime = ReminderTimes.getTimes((int)i);
        }
        int daysAhead = earliestReminderTime / 1440 + 1;
        if (daysAhead < 1) {
            daysAhead = 1;
        }
        GregorianCalendar cal = new GregorianCalendar();
        for (int dayAhead = 0; dayAhead < daysAhead; ++dayAhead) {
            List apptKeyList = AppointmentModel.getReference().getAppts(cal.getTime());
            if (apptKeyList != null) {
                for (Integer apptKey : apptKeyList) {
                    try {
                        Appointment appt = AppointmentModel.getReference().getAppt(apptKey.intValue());
                        if (AppointmentModel.isNote((Appointment)appt) && appt.isTodo()) continue;
                        GregorianCalendar instTime = new GregorianCalendar();
                        instTime.setTime(appt.getDate());
                        instTime.set(13, 0);
                        instTime.set(14, 0);
                        instTime.set(1, cal.get(1));
                        instTime.set(2, cal.get(2));
                        instTime.set(5, cal.get(5));
                        ApptReminderInstance apptInstance = new ApptReminderInstance(appt, instTime.getTime());
                        if (!((ReminderInstance)apptInstance).shouldBeShown()) continue;
                        this.addToUI(apptInstance);
                    }
                    catch (Exception e) {
                        Errmsg.getErrorHandler().errmsg(e);
                    }
                }
            }
            ((Calendar)cal).add(5, 1);
        }
        Collection tds = AppointmentModel.getReference().get_todos();
        if (tds != null) {
            for (Appointment appt : tds) {
                try {
                    ApptReminderInstance apptInstance;
                    if (!AppointmentModel.isNote((Appointment)appt)) continue;
                    Date nt = appt.getNextTodo();
                    if (nt == null) {
                        nt = appt.getDate();
                    }
                    if (!((ReminderInstance)(apptInstance = new ApptReminderInstance(appt, nt))).shouldBeShown()) continue;
                    this.addToUI(apptInstance);
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                }
            }
        }
        if ((bd_days = Prefs.getIntPref(PrefName.BIRTHDAYREMINDERDAYS)) >= 0) {
            Date now = new Date();
            cal.setTime(now);
            cal.set(13, 0);
            cal.set(12, 0);
            cal.set(11, 0);
            try {
                Collection addrs = AddressModel.getReference().getAddresses();
                if (addrs != null) {
                    for (Address addr : addrs) {
                        Date bd = addr.getBirthday();
                        if (bd == null) continue;
                        GregorianCalendar bdcal = new GregorianCalendar();
                        bdcal.setTime(bd);
                        bdcal.set(1, cal.get(1));
                        bdcal.set(13, 59);
                        bdcal.set(12, 59);
                        bdcal.set(11, 23);
                        if (bdcal.before(cal)) {
                            ((Calendar)bdcal).add(1, 1);
                        }
                        if (!(inst = new BirthdayReminderInstance(addr, bdcal.getTime())).shouldBeShown()) continue;
                        this.addToUI(inst);
                    }
                }
            }
            catch (Exception e1) {
                Errmsg.getErrorHandler().errmsg(e1);
            }
        }
        if (Prefs.getBoolPref(PrefName.TASKREMINDERS)) {
            ReminderInstance inst2;
            try {
                Collection pjs = TaskModel.getReference().getProjects();
                for (Project pj : pjs) {
                    if (pj.getDueDate() == null || pj.getStatus().equals(Resource.getResourceString("CLOSED")) || !CategoryModel.getReference().isShown(pj.getCategory()) || !(inst2 = new ProjectReminderInstance(pj)).shouldBeShown()) continue;
                    this.addToUI(inst2);
                }
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
                return;
            }
            Vector mrs = TaskModel.getReference().get_tasks();
            for (int i = 0; i < mrs.size(); ++i) {
                Task mr = (Task)mrs.elementAt(i);
                if (mr.getDueDate() == null || !(inst2 = new TaskReminderInstance(mr)).shouldBeShown()) continue;
                this.addToUI(inst2);
            }
            try {
                Collection sts = TaskModel.getReference().getSubTasks();
                for (Subtask st : sts) {
                    if (st.getDueDate() == null || st.getCloseDate() != null) continue;
                    Task task = TaskModel.getReference().getTask(st.getTask().intValue());
                    String cat = task.getCategory();
                    if (!CategoryModel.getReference().isShown(cat) || !(inst = new SubtaskReminderInstance(st)).shouldBeShown()) continue;
                    this.addToUI(inst);
                }
            }
            catch (Exception e) {
                return;
            }
        }
        this.periodicUpdate();
    }

    public abstract void hideAll();

    public abstract void periodicUpdate();

    public abstract void refresh();

    public void remove() {
        this.timer.cancel();
    }

    public abstract void showAll();

    protected boolean shouldShowUntimedTodosNow() {
        int min;
        GregorianCalendar now = new GregorianCalendar();
        int todoFreq = Prefs.getIntPref(PrefName.TODOREMINDERMINS);
        if (todoFreq == 0) {
            return false;
        }
        int hr = now.get(11);
        int mins_since_midnight = hr * 60 + (min = new GregorianCalendar().get(12));
        return mins_since_midnight % todoFreq == 0;
    }
}

