/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.popup;

import java.util.Date;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.ReminderTimes;
import net.sf.borg.model.TaskModel;
import net.sf.borg.model.entity.Task;
import net.sf.borg.ui.popup.ReminderInstance;

public class TaskReminderInstance
extends ReminderInstance {
    private Task task;

    @Override
    public void do_todo(boolean delete) {
        try {
            TaskModel.getReference().close(this.task.getKey());
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskReminderInstance other = (TaskReminderInstance)obj;
        if (this.task == null ? other.task != null : this.task.getKey() != other.task.getKey()) {
            return false;
        }
        return !(this.getInstanceTime() == null ? other.getInstanceTime() != null : !this.getInstanceTime().equals(other.getInstanceTime()));
    }

    @Override
    public int getCurrentReminder() {
        return -1;
    }

    public TaskReminderInstance(Task task) {
        this.task = task;
        this.setInstanceTime(task.getDueDate());
    }

    @Override
    public String getText() {
        return this.task.getText();
    }

    @Override
    public String calculateToGoMessage() {
        return Resource.getResourceString("task");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.task == null ? 0 : this.task.getKey());
        result = 31 * result + (this.getInstanceTime() == null ? 0 : this.getInstanceTime().hashCode());
        return result;
    }

    @Override
    public boolean isNote() {
        return true;
    }

    @Override
    public boolean isTodo() {
        return true;
    }

    @Override
    public boolean reloadAndCheckForChanges() {
        try {
            Task orig = this.task;
            this.task = TaskModel.getReference().getTask(this.task.getKey());
            if (this.task == null) {
                return true;
            }
            if (TaskModel.isClosed((Task)this.task)) {
                return true;
            }
            if (this.task.getDueDate() == null) {
                return true;
            }
            if (!this.task.getDueDate().equals(orig.getDueDate())) {
                return true;
            }
            if (!this.task.getSummary().equals(orig.getSummary())) {
                return true;
            }
        }
        catch (Exception e) {
            this.task = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldBeShown() {
        if (!Prefs.getBoolPref(PrefName.TASKREMINDERS)) {
            return false;
        }
        if (this.task == null || TaskModel.isClosed((Task)this.task)) {
            return false;
        }
        long minutesToGo = this.getInstanceTime().getTime() / 60000L - new Date().getTime() / 60000L;
        int earliestReminderTime = -100000;
        for (int i = 0; i < ReminderTimes.getNum(); ++i) {
            int time = ReminderTimes.getTimes((int)i);
            if (time <= earliestReminderTime) continue;
            earliestReminderTime = time;
        }
        if (earliestReminderTime == -100000) {
            return false;
        }
        return minutesToGo < (long)earliestReminderTime;
    }
}

