/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.task;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.Resource;
import net.sf.borg.common.Warning;
import net.sf.borg.model.CategoryModel;
import net.sf.borg.model.Model;
import net.sf.borg.model.TaskModel;
import net.sf.borg.model.entity.Project;
import net.sf.borg.model.entity.Task;
import net.sf.borg.ui.task.ProjectView;
import net.sf.borg.ui.util.GridBagConstraintsFactory;
import net.sf.borg.ui.util.PopupMenuHelper;
import net.sf.borg.ui.util.StripedTable;
import net.sf.borg.ui.util.TablePrinter;
import net.sf.borg.ui.util.TableSorter;

public class ProjectPanel
extends JPanel
implements Model.Listener {
    private static final long serialVersionUID = 1L;
    private static final int MAGIC_NO_DUE_DATE = 9999;
    private JPanel buttonPanel = null;
    private TableCellRenderer defaultTableCellRenderer;
    private StripedTable projectTable;
    private JComboBox<String> projectStatusComboBox = new JComboBox();

    public ProjectPanel() {
        TaskModel.getReference().addListener((Model.Listener)this);
        try {
            this.initComponents();
            this.refresh();
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
            return;
        }
    }

    private void projectChangeRequested() {
        int row = this.projectTable.getSelectedRow();
        if (row == -1) {
            return;
        }
        TableSorter tm = (TableSorter)this.projectTable.getModel();
        Integer projectId = (Integer)tm.getValueAt(row, 0);
        try {
            Project p = TaskModel.getReference().getProject(projectId.intValue());
            if (p == null) {
                return;
            }
            new ProjectView(p, ProjectView.Action.CHANGE, null).showView();
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    private void cloneSelectedProject() {
        int row = this.projectTable.getSelectedRow();
        if (row == -1) {
            return;
        }
        TableSorter tm = (TableSorter)this.projectTable.getModel();
        Integer projectId = (Integer)tm.getValueAt(row, 0);
        try {
            Project p = TaskModel.getReference().getProject(projectId.intValue());
            if (p == null) {
                return;
            }
            new ProjectView(p, ProjectView.Action.CLONE, null).showView();
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    private void closeSelectedProject() {
        int row = this.projectTable.getSelectedRow();
        if (row == -1) {
            return;
        }
        TableSorter tm = (TableSorter)this.projectTable.getModel();
        Integer projectId = (Integer)tm.getValueAt(row, 0);
        try {
            TaskModel.getReference().closeProject(projectId.intValue());
        }
        catch (Warning w) {
            Errmsg.getErrorHandler().notice(w.getMessage());
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    private void deleteActionPerformed() {
        int row = this.projectTable.getSelectedRow();
        if (row == -1) {
            return;
        }
        TableSorter tm = (TableSorter)this.projectTable.getModel();
        Integer projectId = (Integer)tm.getValueAt(row, 0);
        int ret = JOptionPane.showConfirmDialog(null, Resource.getResourceString("Really_delete_number_") + " " + projectId, "", 0);
        if (ret == 0) {
            try {
                TaskModel.getReference().deleteProject(projectId.intValue());
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
            }
        }
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new FlowLayout());
            JButton addbutton = new JButton();
            addbutton.setText(Resource.getResourceString("Add"));
            addbutton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Add16.gif")));
            addbutton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        new ProjectView(null, ProjectView.Action.ADD, null).showView();
                    }
                    catch (Exception ex) {
                        Errmsg.getErrorHandler().errmsg(ex);
                    }
                }
            });
            this.buttonPanel.add((Component)addbutton, null);
            JButton changebutton1 = new JButton();
            changebutton1.setIcon(new ImageIcon(this.getClass().getResource("/resource/Edit16.gif")));
            changebutton1.setText(Resource.getResourceString("Change"));
            changebutton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProjectPanel.this.projectChangeRequested();
                }
            });
            this.buttonPanel.add((Component)changebutton1, null);
            JButton deletebutton1 = new JButton();
            deletebutton1.setIcon(new ImageIcon(this.getClass().getResource("/resource/Delete16.gif")));
            deletebutton1.setText(Resource.getResourceString("Delete"));
            deletebutton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProjectPanel.this.deleteActionPerformed();
                }
            });
            this.buttonPanel.add((Component)deletebutton1, null);
            JButton closebutton1 = new JButton();
            closebutton1.setIcon(new ImageIcon(this.getClass().getResource("/resource/greenlight.gif")));
            closebutton1.setText(Resource.getResourceString("Close"));
            closebutton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProjectPanel.this.closeSelectedProject();
                }
            });
            this.buttonPanel.add((Component)closebutton1, null);
            JButton clonebutton1 = new JButton();
            clonebutton1.setIcon(new ImageIcon(this.getClass().getResource("/resource/Copy16.gif")));
            clonebutton1.setText(Resource.getResourceString("Clone"));
            clonebutton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProjectPanel.this.cloneSelectedProject();
                }
            });
            this.buttonPanel.add((Component)clonebutton1, null);
        }
        return this.buttonPanel;
    }

    private void initComponents() throws Exception {
        this.setLayout(new GridBagLayout());
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(0);
        JPanel filterPanel = new JPanel();
        filterPanel.setLayout(flowLayout);
        JLabel statusLabel = new JLabel();
        statusLabel.setText(Resource.getResourceString("Status") + ":");
        filterPanel.add((Component)statusLabel, null);
        this.projectStatusComboBox.removeAllItems();
        this.projectStatusComboBox.addItem(Resource.getResourceString("All"));
        this.projectStatusComboBox.addItem(Resource.getResourceString("OPEN"));
        this.projectStatusComboBox.addItem(Resource.getResourceString("CLOSED"));
        this.projectStatusComboBox.setSelectedItem(Resource.getResourceString("OPEN"));
        this.projectStatusComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.refresh();
            }
        });
        filterPanel.add(this.projectStatusComboBox, null);
        this.add((Component)filterPanel, GridBagConstraintsFactory.create(0, 0, 2));
        JScrollPane tableScroll = new JScrollPane();
        this.projectTable = new StripedTable();
        this.defaultTableCellRenderer = this.projectTable.getDefaultRenderer(Integer.class);
        this.projectTable.setDefaultRenderer(Integer.class, new ProjIntRenderer());
        this.projectTable.setModel(new TableSorter(new String[]{Resource.getResourceString("Item_#"), Resource.getResourceString("Category"), Resource.getResourceString("Status"), Resource.getResourceString("Start_Date"), Resource.getResourceString("Due_Date"), Resource.getResourceString("total_tasks"), Resource.getResourceString("open_tasks"), Resource.getResourceString("Days_Left"), Resource.getResourceString("Description")}, new Class[]{Integer.class, String.class, String.class, Date.class, Date.class, Integer.class, Integer.class, Integer.class, String.class}));
        new PopupMenuHelper(this.projectTable, new PopupMenuHelper.Entry[]{new PopupMenuHelper.Entry(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    new ProjectView(null, ProjectView.Action.ADD, null).showView();
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                }
            }
        }, "Add"), new PopupMenuHelper.Entry(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.projectChangeRequested();
            }
        }, "Change"), new PopupMenuHelper.Entry(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.cloneSelectedProject();
            }
        }, "Clone"), new PopupMenuHelper.Entry(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.deleteActionPerformed();
            }
        }, "Delete"), new PopupMenuHelper.Entry(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.closeSelectedProject();
            }
        }, "Close")});
        this.projectTable.getColumnModel().getColumn(0).setPreferredWidth(80);
        this.projectTable.getColumnModel().getColumn(1).setPreferredWidth(80);
        this.projectTable.getColumnModel().getColumn(2).setPreferredWidth(80);
        this.projectTable.getColumnModel().getColumn(3).setPreferredWidth(80);
        this.projectTable.getColumnModel().getColumn(5).setPreferredWidth(80);
        this.projectTable.getColumnModel().getColumn(6).setPreferredWidth(80);
        this.projectTable.getColumnModel().getColumn(7).setPreferredWidth(80);
        this.projectTable.getColumnModel().getColumn(8).setPreferredWidth(400);
        this.projectTable.setSelectionMode(0);
        TableSorter tm = (TableSorter)this.projectTable.getModel();
        tm.addMouseListenerToHeaderInTable(this.projectTable);
        tm.setRowCount(0);
        tm.tableChanged(new TableModelEvent(tm));
        tableScroll.setViewportView(this.projectTable);
        this.projectTable.setAutoResizeMode(0);
        this.add((Component)tableScroll, GridBagConstraintsFactory.create(0, 1, 1, 1.0, 1.0));
        this.add((Component)this.getButtonPanel(), GridBagConstraintsFactory.create(0, 2));
    }

    public void print() {
        try {
            TablePrinter.printTable(this.projectTable);
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    public void update(Model.ChangeEvent event) {
        this.refresh();
    }

    public void refresh() {
        TableSorter tm = (TableSorter)this.projectTable.getModel();
        tm.setRowCount(0);
        tm.tableChanged(new TableModelEvent(tm));
        String pstatfilt = (String)this.projectStatusComboBox.getSelectedItem();
        try {
            Collection projects = TaskModel.getReference().getProjects();
            for (Project project : projects) {
                if (!pstatfilt.equals(Resource.getResourceString("All")) && !pstatfilt.equals(project.getStatus()) || !CategoryModel.getReference().isShown(project.getCategory())) continue;
                Object[] ro = new Object[10];
                ro[0] = new Integer(project.getKey());
                ro[1] = project.getCategory();
                ro[2] = project.getStatus();
                ro[3] = project.getStartDate();
                ro[4] = project.getDueDate();
                Collection ptasks = TaskModel.getReference().getTasks(project.getKey());
                ro[5] = new Integer(ptasks.size());
                int open = 0;
                for (Task pt : ptasks) {
                    if (TaskModel.isClosed((Task)pt)) continue;
                    ++open;
                }
                ro[6] = new Integer(open);
                ro[7] = new Integer(0);
                if (ro[4] == null) {
                    ro[7] = new Integer(9999);
                } else {
                    Date dd = (Date)ro[4];
                    ro[7] = new Integer(TaskModel.daysLeft((Date)dd));
                }
                String de = project.getDescription();
                String tmp = "";
                for (int i = 0; de != null && i < de.length(); ++i) {
                    char c = de.charAt(i);
                    tmp = c == '\n' || c == '\r' ? tmp + ' ' : tmp + c;
                }
                ro[8] = tmp;
                tm.addRow(ro);
                tm.tableChanged(new TableModelEvent(tm));
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    private class ProjIntRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public ProjIntRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel l = (JLabel)ProjectPanel.this.defaultTableCellRenderer.getTableCellRendererComponent(table, obj, isSelected, hasFocus, row, column);
            String nm = table.getColumnName(column);
            if (obj == null || !nm.equals(Resource.getResourceString("Days_Left"))) {
                return l;
            }
            int daysLeft = (Integer)obj;
            this.setText(l.getText());
            this.setHorizontalAlignment(0);
            this.setBackground(l.getBackground());
            this.setForeground(l.getForeground());
            if (daysLeft == 9999) {
                this.setText("--");
            }
            if (isSelected) {
                return this;
            }
            if (daysLeft < 10) {
                this.setBackground(new Color(255, 255, 175));
            }
            if (daysLeft < 5) {
                this.setBackground(new Color(255, 200, 120));
            }
            if (daysLeft < 2) {
                this.setBackground(new Color(255, 120, 120));
            }
            return this;
        }
    }
}

