/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.task;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.CategoryModel;
import net.sf.borg.model.Model;
import net.sf.borg.model.TaskModel;
import net.sf.borg.model.entity.KeyedEntity;
import net.sf.borg.model.entity.Project;
import net.sf.borg.model.entity.Task;
import net.sf.borg.ui.task.ProjectView;
import net.sf.borg.ui.task.TaskView;
import net.sf.borg.ui.util.GridBagConstraintsFactory;

public class ProjectTreePanel
extends JPanel
implements TreeSelectionListener,
MouseListener,
Model.Listener,
Prefs.Listener {
    private static final long serialVersionUID = 1L;
    private HashMap<Integer, Integer> daysLeftCache = new HashMap();
    private boolean isExpanded = true;
    private JPopupMenu projmenu = new JPopupMenu();
    private JPopupMenu rootmenu = new JPopupMenu();
    private JCheckBox showClosedCheckBox = new JCheckBox(Resource.getResourceString("show_closed"));
    private JCheckBox showClosedTasksCheckBox = new JCheckBox(Resource.getResourceString("show_closed_tasks"));
    private JTree projectTree = null;
    private JScrollPane treeScrollPane = null;
    private JScrollPane entityScrollPane = new JScrollPane(new JPanel());

    private static void expandOrCollapseSubTree(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                ProjectTreePanel.expandOrCollapseSubTree(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public ProjectTreePanel() {
        super(new GridLayout(0, 1));
        TaskModel.getReference().addListener((Model.Listener)this);
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(Resource.getResourceString("projects"));
        this.createNodes(rootNode);
        this.projectTree = new JTree(rootNode);
        this.projectTree.getSelectionModel().setSelectionMode(1);
        this.projectTree.setCellRenderer(new ProjectTreeCellRenderer());
        this.projectTree.addTreeSelectionListener(this);
        this.treeScrollPane = new JScrollPane(this.projectTree);
        JPanel treePane = new JPanel();
        treePane.setLayout(new GridBagLayout());
        treePane.add((Component)this.treeScrollPane, GridBagConstraintsFactory.create(0, 0, 1, 1.0, 1.0));
        treePane.add((Component)this.showClosedCheckBox, GridBagConstraintsFactory.create(0, 1, 1));
        treePane.add((Component)this.showClosedTasksCheckBox, GridBagConstraintsFactory.create(0, 2, 1));
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setTopComponent(treePane);
        splitPane.setBottomComponent(this.entityScrollPane);
        Dimension minimumSize = new Dimension(200, 50);
        this.entityScrollPane.setMinimumSize(minimumSize);
        this.treeScrollPane.setMinimumSize(minimumSize);
        splitPane.setDividerLocation(250);
        this.add(splitPane);
        this.projectTree.addMouseListener(this);
        JMenuItem jm = this.rootmenu.add(Resource.getResourceString("Add") + " " + Resource.getResourceString("project"));
        jm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ProjectView pv = new ProjectView(null, ProjectView.Action.ADD, null);
                    ProjectTreePanel.this.entityScrollPane.setViewportView(pv);
                }
                catch (Exception ex) {
                    Errmsg.getErrorHandler().errmsg(ex);
                }
            }
        });
        JMenuItem jmex = this.rootmenu.add(Resource.getResourceString("expand"));
        jmex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectTreePanel.this.isExpanded = true;
                ProjectTreePanel.this.expandOrCollapseAll(ProjectTreePanel.this.isExpanded);
            }
        });
        JMenuItem jmcol = this.rootmenu.add(Resource.getResourceString("collapse"));
        jmcol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectTreePanel.this.isExpanded = false;
                ProjectTreePanel.this.expandOrCollapseAll(ProjectTreePanel.this.isExpanded);
            }
        });
        JMenuItem jm2 = this.projmenu.add(Resource.getResourceString("Add") + " " + Resource.getResourceString("task"));
        jm2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectTreePanel.this.addTask();
            }
        });
        JMenuItem jm3 = this.projmenu.add(Resource.getResourceString("Add") + " " + Resource.getResourceString("project"));
        jm3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectTreePanel.this.addSubProject();
            }
        });
        this.showClosedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectTreePanel.this.refresh();
            }
        });
        this.showClosedTasksCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectTreePanel.this.refresh();
            }
        });
        this.expandOrCollapseAll(this.isExpanded);
        Prefs.addListener(this);
    }

    private void addSubProject() {
        KeyedEntity<?> o = this.getSelectedEntity();
        if (o == null) {
            return;
        }
        if (o instanceof Project) {
            Project p = (Project)o;
            try {
                try {
                    ProjectView pv = new ProjectView(null, ProjectView.Action.ADD, new Integer(p.getKey()));
                    this.entityScrollPane.setViewportView(pv);
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                }
            }
            catch (Exception e1) {
                Errmsg.getErrorHandler().errmsg(e1);
                return;
            }
        }
    }

    private void addTask() {
        KeyedEntity<?> o = this.getSelectedEntity();
        if (o == null) {
            return;
        }
        if (o instanceof Project) {
            Project p = (Project)o;
            try {
                TaskView pv = new TaskView(null, TaskView.Action.ADD, new Integer(p.getKey()));
                this.entityScrollPane.setViewportView(pv);
            }
            catch (Exception e1) {
                Errmsg.getErrorHandler().errmsg(e1);
                return;
            }
        }
    }

    private void addProjectChildren(Project p, DefaultMutableTreeNode node) throws Exception {
        Collection tasks = TaskModel.getReference().getTasks(p.getKey());
        for (Task task : tasks) {
            if (!CategoryModel.getReference().isShown(task.getCategory()) || !this.showClosedTasksCheckBox.isSelected() && TaskModel.isClosed((Task)task)) continue;
            String taskdesc = task.getSummary();
            if (Prefs.getBoolPref(PrefName.TASK_TREE_SHOW_STATUS)) {
                node.add(new DefaultMutableTreeNode(new Node("[" + task.getKey() + "-" + task.getState() + "] " + taskdesc, (KeyedEntity<?>)task)));
                continue;
            }
            node.add(new DefaultMutableTreeNode(new Node(taskdesc, (KeyedEntity<?>)task)));
        }
        Collection subpcoll = TaskModel.getReference().getSubProjects(p.getKey());
        for (Project project : subpcoll) {
            if (!CategoryModel.getReference().isShown(project.getCategory()) || !this.showClosedCheckBox.isSelected() && TaskModel.isClosed((Project)project)) continue;
            DefaultMutableTreeNode subnode = new DefaultMutableTreeNode(new Node(project.getDescription(), (KeyedEntity<?>)project));
            node.add(subnode);
            this.addProjectChildren(project, subnode);
        }
    }

    private void createNodes(DefaultMutableTreeNode top) {
        try {
            Collection projects = TaskModel.getReference().getProjects();
            for (Project p : projects) {
                if (!this.showClosedCheckBox.isSelected() && TaskModel.isClosed((Project)p) || !CategoryModel.getReference().isShown(p.getCategory()) || p.getParent() != null) continue;
                DefaultMutableTreeNode pnode = new DefaultMutableTreeNode(new Node(p.getDescription(), (KeyedEntity<?>)p));
                top.add(pnode);
                this.addProjectChildren(p, pnode);
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    public void expandOrCollapseAll(boolean expand) {
        TreeNode root = (TreeNode)this.projectTree.getModel().getRoot();
        ProjectTreePanel.expandOrCollapseSubTree(this.projectTree, new TreePath(root), expand);
    }

    private KeyedEntity<?> getSelectedEntity() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.projectTree.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        Object nodeobj = node.getUserObject();
        if (!(nodeobj instanceof Node)) {
            return null;
        }
        Node mynode = (Node)node.getUserObject();
        return mynode.getEntity();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            return;
        }
        TreePath selPath = this.projectTree.getPathForLocation(e.getX(), e.getY());
        if (selPath == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
        if (node == null) {
            return;
        }
        this.projectTree.setSelectionPath(selPath);
        Object nodeobj = node.getUserObject();
        if (!(nodeobj instanceof Node)) {
            this.rootmenu.show(this, e.getX(), e.getY());
            return;
        }
        Node mynode = (Node)node.getUserObject();
        KeyedEntity<?> o = mynode.getEntity();
        if (o == null) {
            return;
        }
        if (o instanceof Project) {
            this.projmenu.show(this, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    public void update(Model.ChangeEvent event) {
        this.daysLeftCache.clear();
        this.refresh();
        Component o = this.entityScrollPane.getViewport().getView();
        if (o instanceof ProjectView && event.getObject() instanceof Project) {
            ProjectView pv = (ProjectView)o;
            Project p = (Project)event.getObject();
            if (event.getAction() == Model.ChangeEvent.ChangeAction.DELETE && p.getKey() == pv.getShownId()) {
                this.entityScrollPane.setViewportView(null);
            }
        } else if (o instanceof TaskView && event.getObject() instanceof Task) {
            TaskView pv = (TaskView)o;
            Task p = (Task)event.getObject();
            if (event.getAction() == Model.ChangeEvent.ChangeAction.DELETE && p.getKey() == pv.getShownId()) {
                this.entityScrollPane.setViewportView(null);
            }
        }
    }

    public void refresh() {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(Resource.getResourceString("projects"));
        this.createNodes(top);
        this.projectTree = new JTree(top);
        this.projectTree.setCellRenderer(new ProjectTreeCellRenderer());
        this.projectTree.getSelectionModel().setSelectionMode(1);
        this.projectTree.addTreeSelectionListener(this);
        this.treeScrollPane.setViewportView(this.projectTree);
        this.projectTree.addMouseListener(this);
        this.expandOrCollapseAll(this.isExpanded);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        KeyedEntity<?> o = this.getSelectedEntity();
        if (o == null) {
            this.entityScrollPane.setViewportView(null);
        } else {
            if (o instanceof Task) {
                Task t = (Task)o;
                try {
                    TaskView tv = new TaskView(t, TaskView.Action.CHANGE, t.getProject());
                    this.entityScrollPane.setViewportView(tv);
                }
                catch (Exception e1) {
                    Errmsg.getErrorHandler().errmsg(e1);
                    return;
                }
            }
            if (o instanceof Project) {
                Project p = (Project)o;
                try {
                    ProjectView pv = new ProjectView(p, ProjectView.Action.CHANGE, null);
                    this.entityScrollPane.setViewportView(pv);
                }
                catch (Exception e1) {
                    Errmsg.getErrorHandler().errmsg(e1);
                    return;
                }
            }
        }
    }

    @Override
    public void prefsChanged() {
        this.refresh();
    }

    private class Node {
        private String name;
        private KeyedEntity<?> entity;

        public Node(String name, KeyedEntity<?> o) {
            this.name = name;
            this.entity = o;
        }

        public String getName() {
            return this.name;
        }

        public KeyedEntity<?> getEntity() {
            return this.entity;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setEntity(KeyedEntity<?> obj) {
            this.entity = obj;
        }

        public String toString() {
            return this.name;
        }
    }

    private class ProjectTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;
        private final ImageIcon redIcon = new ImageIcon(this.getClass().getResource("/resource/red.png"));
        private final ImageIcon orangeIcon = new ImageIcon(this.getClass().getResource("/resource/orange.png"));
        private final ImageIcon yellowIcon = new ImageIcon(this.getClass().getResource("/resource/yellow.png"));
        private final ImageIcon greenIcon = new ImageIcon(this.getClass().getResource("/resource/green.png"));
        private final ImageIcon emptyIcon = new ImageIcon(this.getClass().getResource("/resource/empty.png"));
        private final ImageIcon doneIcon = new ImageIcon(this.getClass().getResource("/resource/done.png"));

        private ProjectTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean has_focus) {
            DefaultMutableTreeNode treeNode;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, has_focus);
            if (value instanceof DefaultMutableTreeNode && (treeNode = (DefaultMutableTreeNode)value).getUserObject() != null && treeNode.getUserObject() instanceof Node) {
                Node node = (Node)treeNode.getUserObject();
                if (node.getEntity() instanceof Task) {
                    Task task = (Task)node.getEntity();
                    if (TaskModel.isClosed((Task)((Task)node.getEntity()))) {
                        this.setIcon(this.doneIcon);
                    } else {
                        try {
                            int daysLeft;
                            Integer dl = (Integer)ProjectTreePanel.this.daysLeftCache.get(new Integer(task.getKey()));
                            if (dl == null) {
                                daysLeft = TaskModel.getReference().daysLeft(task);
                                ProjectTreePanel.this.daysLeftCache.put(new Integer(task.getKey()), new Integer(daysLeft));
                            } else {
                                daysLeft = dl;
                            }
                            if (daysLeft < Prefs.getIntPref(PrefName.RED_DAYS)) {
                                this.setIcon(this.redIcon);
                            } else if (daysLeft < Prefs.getIntPref(PrefName.ORANGE_DAYS)) {
                                this.setIcon(this.orangeIcon);
                            } else if (daysLeft < Prefs.getIntPref(PrefName.YELLOW_DAYS)) {
                                this.setIcon(this.yellowIcon);
                            } else if (daysLeft == 9999999) {
                                this.setIcon(this.emptyIcon);
                            } else {
                                this.setIcon(this.greenIcon);
                            }
                        }
                        catch (Exception e) {
                            Errmsg.getErrorHandler().errmsg(e);
                        }
                    }
                }
                if (leaf && node.getEntity() instanceof Project) {
                    this.setIcon(this.closedIcon);
                }
            }
            return this;
        }
    }
}

