/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.task;

import com.toedter.calendar.JDateChooser;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.sf.borg.common.DateUtil;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.Resource;
import net.sf.borg.common.Warning;
import net.sf.borg.model.CategoryModel;
import net.sf.borg.model.Model;
import net.sf.borg.model.TaskModel;
import net.sf.borg.model.entity.KeyedEntity;
import net.sf.borg.model.entity.Project;
import net.sf.borg.model.entity.Task;
import net.sf.borg.ui.DockableView;
import net.sf.borg.ui.ResourceHelper;
import net.sf.borg.ui.link.LinkPanel;
import net.sf.borg.ui.task.TaskListPanel;
import net.sf.borg.ui.task.TaskView;
import net.sf.borg.ui.util.GridBagConstraintsFactory;

public class ProjectView
extends DockableView {
    private static final long serialVersionUID = 1L;
    private JComboBox<String> categoryBox = null;
    private JTextField daysLeftText = null;
    private JTextField description;
    private JDateChooser dueDateChooser;
    private JTextField projectIdText;
    private LinkPanel linkPanel = new LinkPanel();
    private JTextField openTaskCount = null;
    private JComboBox<String> parentProjectComboBox = new JComboBox();
    private JDateChooser startDateChooser;
    private JComboBox<String> statusComboBox;
    private JPanel taskBorder = null;
    private TaskListPanel taskPanel = null;
    private String windowTitle = "";
    private JTextField totalTaskCount = null;

    private static Integer getProjectId(String s) throws Exception {
        int i = s.indexOf(":");
        if (i == -1) {
            throw new Exception("Cannot parse project label");
        }
        String ss = s.substring(0, i);
        int pid = Integer.parseInt(ss);
        return new Integer(pid);
    }

    private static String getProjectString(Project p) {
        String desc = p.getDescription();
        if (desc != null && desc.length() > 20) {
            desc = desc.substring(0, 20) + "...";
        }
        return p.getKey() + ":" + desc;
    }

    public ProjectView(Project p, Action function, Integer parentId) {
        this.addModel((Model)TaskModel.getReference());
        this.initComponents();
        try {
            Collection cats = CategoryModel.getReference().getCategories();
            Iterator it = cats.iterator();
            while (it.hasNext()) {
                this.categoryBox.addItem((String)it.next());
            }
            this.categoryBox.setSelectedIndex(0);
            this.showProject(function, p, parentId);
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    @Override
    public String getFrameTitle() {
        return this.windowTitle;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        JPanel projectInfoPanel = new JPanel();
        projectInfoPanel.setLayout(new GridBagLayout());
        projectInfoPanel.setBorder(new TitledBorder(Resource.getResourceString("ProjectInformation")));
        this.projectIdText = new JTextField();
        this.projectIdText.setText("projectIdText");
        this.description = new JTextField(10);
        JLabel lblItemNum = new JLabel();
        lblItemNum.setText(Resource.getResourceString("Item_#"));
        this.dueDateChooser = new JDateChooser();
        JLabel lblStartDate = new JLabel();
        JLabel lblDueDate = new JLabel();
        this.statusComboBox = new JComboBox();
        JLabel catlabel = new JLabel();
        JLabel lblStatus = new JLabel();
        ResourceHelper.setText(lblStatus, "Status");
        lblStatus.setLabelFor(this.statusComboBox);
        this.startDateChooser = new JDateChooser();
        ResourceHelper.setText(lblStartDate, "Start_Date");
        lblStartDate.setLabelFor((Component)this.startDateChooser);
        ResourceHelper.setText(lblDueDate, "Due_Date");
        lblDueDate.setLabelFor((Component)this.dueDateChooser);
        ResourceHelper.setText(catlabel, "Category");
        this.categoryBox = new JComboBox();
        catlabel.setLabelFor(this.categoryBox);
        projectInfoPanel.add((Component)lblItemNum, GridBagConstraintsFactory.create(0, 0, 1));
        projectInfoPanel.add((Component)lblStatus, GridBagConstraintsFactory.create(0, 1, 1));
        projectInfoPanel.add((Component)catlabel, GridBagConstraintsFactory.create(0, 2, 1));
        JLabel descLabel = new JLabel();
        descLabel.setText(Resource.getResourceString("Description"));
        projectInfoPanel.add((Component)descLabel, GridBagConstraintsFactory.create(0, 3, 1));
        projectInfoPanel.add((Component)this.projectIdText, GridBagConstraintsFactory.create(1, 0, 1));
        projectInfoPanel.add(this.statusComboBox, GridBagConstraintsFactory.create(1, 1, 1, 1.0, 0.0));
        projectInfoPanel.add(this.categoryBox, GridBagConstraintsFactory.create(1, 2, 1, 1.0, 0.0));
        GridBagConstraints dgbc = GridBagConstraintsFactory.create(1, 3, 1, 1.0, 0.0);
        dgbc.gridwidth = 5;
        dgbc.weightx = 0.0;
        projectInfoPanel.add((Component)this.description, dgbc);
        JLabel parentLabel = new JLabel(Resource.getResourceString("parent"));
        projectInfoPanel.add((Component)parentLabel, GridBagConstraintsFactory.create(2, 0, 1));
        projectInfoPanel.add((Component)lblStartDate, GridBagConstraintsFactory.create(2, 1, 1));
        projectInfoPanel.add((Component)lblDueDate, GridBagConstraintsFactory.create(2, 2, 1));
        projectInfoPanel.add(this.parentProjectComboBox, GridBagConstraintsFactory.create(3, 0, 1, 0.0, 0.0));
        projectInfoPanel.add((Component)this.startDateChooser, GridBagConstraintsFactory.create(3, 1, 1, 1.0, 0.0));
        projectInfoPanel.add((Component)this.dueDateChooser, GridBagConstraintsFactory.create(3, 2, 1, 1.0, 0.0));
        JLabel daysLeftLabel = new JLabel();
        daysLeftLabel.setText(Resource.getResourceString("Days_Left"));
        daysLeftLabel.setHorizontalTextPosition(4);
        daysLeftLabel.setHorizontalAlignment(4);
        projectInfoPanel.add((Component)daysLeftLabel, GridBagConstraintsFactory.create(4, 0));
        JLabel totalLabel = new JLabel();
        totalLabel.setText(Resource.getResourceString("total_tasks"));
        projectInfoPanel.add((Component)totalLabel, GridBagConstraintsFactory.create(4, 1));
        JLabel openLabel = new JLabel();
        openLabel.setText(Resource.getResourceString("open_tasks"));
        projectInfoPanel.add((Component)openLabel, GridBagConstraintsFactory.create(4, 2));
        this.daysLeftText = new JTextField();
        this.daysLeftText.setEditable(false);
        projectInfoPanel.add((Component)this.daysLeftText, GridBagConstraintsFactory.create(5, 0, 1, 1.0, 0.0));
        this.totalTaskCount = new JTextField();
        this.totalTaskCount.setEditable(false);
        projectInfoPanel.add((Component)this.totalTaskCount, GridBagConstraintsFactory.create(5, 1, 1, 1.0, 0.0));
        this.openTaskCount = new JTextField();
        this.openTaskCount.setEditable(false);
        projectInfoPanel.add((Component)this.openTaskCount, GridBagConstraintsFactory.create(5, 2, 1, 1.0, 0.0));
        this.add((Component)projectInfoPanel, GridBagConstraintsFactory.create(0, 0, 1, 0.0, 0.0));
        JPanel buttonPanel = new JPanel();
        JButton savebutton = new JButton();
        savebutton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Save16.gif")));
        ResourceHelper.setText(savebutton, "Save");
        savebutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectView.this.saveProject();
            }
        });
        buttonPanel.add((Component)savebutton, savebutton.getName());
        GridBagConstraints bc = GridBagConstraintsFactory.create(0, 7, 1, 0.0, 0.0);
        bc.gridwidth = 6;
        projectInfoPanel.add((Component)buttonPanel, bc);
        this.linkPanel.setBorder(new TitledBorder(Resource.getResourceString("links")));
        this.add((Component)this.linkPanel, GridBagConstraintsFactory.create(0, 2, 1));
        this.taskBorder = new JPanel();
        this.taskBorder.setBorder(new TitledBorder(Resource.getResourceString("tasks")));
        this.taskBorder.setLayout(new GridBagLayout());
        this.add((Component)this.taskBorder, GridBagConstraintsFactory.create(0, 3, 1, 1.0, 1.0));
    }

    @Override
    public void refresh() {
    }

    public void update(Model.ChangeEvent event) {
        this.refresh();
        if (event.getAction() == Model.ChangeEvent.ChangeAction.DELETE && event.getObject() instanceof Project && ((Project)event.getObject()).getKey() == this.getShownId()) {
            try {
                this.showProject(Action.ADD, null, null);
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
            }
        }
    }

    private void saveProject() {
        if (this.description.getText() == null || this.description.getText().trim().equals("")) {
            Errmsg.getErrorHandler().notice(Resource.getResourceString("empty_desc"));
            return;
        }
        try {
            Calendar cal;
            String num = this.projectIdText.getText();
            Project p = new Project();
            if (!num.equals("NEW") && !num.equals("CLONE")) {
                p.setKey(Integer.parseInt(num));
                Project indb = TaskModel.getReference().getProject(p.getKey());
                if (indb == null) {
                    Errmsg.getErrorHandler().notice(Resource.getResourceString("project_not_found"));
                    return;
                }
            }
            if ((cal = this.startDateChooser.getCalendar()) == null) {
                cal = new GregorianCalendar();
            }
            p.setStartDate(cal.getTime());
            cal = this.dueDateChooser.getCalendar();
            if (cal != null) {
                p.setDueDate(cal.getTime());
                if (DateUtil.isAfter(p.getStartDate(), p.getDueDate())) {
                    throw new Warning(Resource.getResourceString("sd_dd_warn"));
                }
            }
            p.setDescription(this.description.getText());
            p.setStatus((String)this.statusComboBox.getSelectedItem());
            String cat = (String)this.categoryBox.getSelectedItem();
            if (cat.equals("") || cat.equals(CategoryModel.UNCATEGORIZED)) {
                p.setCategory(null);
            } else {
                p.setCategory(cat);
            }
            p.setParent(null);
            String proj = (String)this.parentProjectComboBox.getSelectedItem();
            try {
                p.setParent(ProjectView.getProjectId(proj));
            }
            catch (Exception e) {
                // empty catch block
            }
            TaskModel.getReference().saveProject(p);
            p.setKey(p.getKey());
            this.showProject(Action.CHANGE, p, null);
        }
        catch (Warning w) {
            Errmsg.getErrorHandler().notice(w.getMessage());
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    private void showProject(Action function, Project p, Integer parentId) throws Exception {
        this.linkPanel.setOwner((KeyedEntity<?>)p);
        this.parentProjectComboBox.removeAllItems();
        this.parentProjectComboBox.addItem("");
        Collection projects = TaskModel.getReference().getProjects();
        if (projects != null) {
            for (Project project : projects) {
                if (p != null && p.getKey() == project.getKey() || !project.getStatus().equals(Resource.getResourceString("OPEN"))) continue;
                this.parentProjectComboBox.addItem(ProjectView.getProjectString(project));
            }
        }
        if (p != null) {
            this.projectIdText.setText(Integer.toString(p.getKey()));
            this.projectIdText.setEditable(false);
            this.windowTitle = Resource.getResourceString("Item_") + " " + p.getKey();
            GregorianCalendar gc = new GregorianCalendar();
            Date dd = p.getDueDate();
            if (dd != null) {
                gc.setTime(dd);
                this.dueDateChooser.setCalendar((Calendar)gc);
            }
            GregorianCalendar gc2 = new GregorianCalendar();
            dd = p.getStartDate();
            if (dd != null) {
                gc2.setTime(dd);
            }
            this.startDateChooser.setCalendar((Calendar)gc2);
            int daysleft = TaskModel.daysLeft((Date)p.getDueDate());
            this.daysLeftText.setText(Integer.toString(daysleft));
            String cat = p.getCategory();
            if (cat != null && !cat.equals("")) {
                this.categoryBox.setSelectedItem(cat);
            } else {
                this.categoryBox.setSelectedIndex(0);
            }
            this.description.setText(p.getDescription());
            this.statusComboBox.setEditable(false);
            Collection ptasks = TaskModel.getReference().getTasks(p.getKey());
            this.totalTaskCount.setText(Integer.toString(ptasks.size()));
            int openTasks = 0;
            for (Task pt : ptasks) {
                if (TaskModel.isClosed((Task)pt)) continue;
                ++openTasks;
            }
            this.openTaskCount.setText(Integer.toString(openTasks));
            Integer pid = p.getParent();
            if (pid != null) {
                Project par = TaskModel.getReference().getProject(pid.intValue());
                if (TaskModel.isClosed((Project)par)) {
                    this.parentProjectComboBox.addItem(ProjectView.getProjectString(par));
                }
                this.parentProjectComboBox.setSelectedItem(ProjectView.getProjectString(par));
            }
            if (this.taskPanel == null) {
                this.taskPanel = new TaskListPanel(TaskView.getProjectString(p));
                this.taskPanel.addClosedTaskFilter();
                this.taskBorder.add((Component)this.taskPanel, GridBagConstraintsFactory.create(0, 0, 1, 1.0, 1.0));
            }
        } else {
            this.projectIdText.setText("NEW");
            this.projectIdText.setEditable(false);
            this.windowTitle = Resource.getResourceString("NEW_Item");
            this.statusComboBox.addItem(Resource.getResourceString("OPEN"));
            this.statusComboBox.setEnabled(false);
            this.categoryBox.setSelectedIndex(0);
            this.description.setText("");
            this.totalTaskCount.setText("");
            this.openTaskCount.setText("");
            if (parentId != null) {
                Date sd;
                Project par = TaskModel.getReference().getProject(parentId.intValue());
                if (TaskModel.isClosed((Project)par)) {
                    this.parentProjectComboBox.addItem(ProjectView.getProjectString(par));
                }
                this.parentProjectComboBox.setSelectedItem(ProjectView.getProjectString(par));
                String cat = par.getCategory();
                if (cat != null && !cat.equals("")) {
                    this.categoryBox.setSelectedItem(cat);
                } else {
                    this.categoryBox.setSelectedIndex(0);
                }
                GregorianCalendar gc = new GregorianCalendar();
                Date dd = par.getDueDate();
                if (dd != null) {
                    gc.setTime(dd);
                    this.dueDateChooser.setCalendar((Calendar)gc);
                }
                if ((sd = par.getStartDate()) != null) {
                    gc.setTime(sd);
                    this.startDateChooser.setCalendar((Calendar)gc);
                }
            }
        }
        if (p == null) {
            this.statusComboBox.setEnabled(false);
        }
        if (function == Action.CLONE) {
            this.projectIdText.setText("CLONE");
            this.projectIdText.setEditable(false);
            this.statusComboBox.removeAllItems();
            this.statusComboBox.addItem(Resource.getResourceString("OPEN"));
            this.statusComboBox.setEnabled(false);
        } else if (function == Action.CHANGE) {
            String state = null;
            if (p != null) {
                state = p.getStatus();
            }
            this.statusComboBox.removeAllItems();
            this.statusComboBox.addItem(Resource.getResourceString("OPEN"));
            this.statusComboBox.addItem(Resource.getResourceString("CLOSED"));
            this.statusComboBox.setSelectedItem(state);
            this.statusComboBox.setEnabled(true);
        }
    }

    public int getShownId() {
        String num = this.projectIdText.getText();
        if (!num.equals("NEW") && !num.equals("CLONE")) {
            return Integer.parseInt(num);
        }
        return -1;
    }

    public static enum Action {
        ADD,
        CHANGE,
        CLONE;

    }
}

